/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActionEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActionServiceImpl
implements IActionService {
    @Autowired
    private ActionDas actionDas;
    @Autowired
    private IActionTemplateService actionTemplateService;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Long addAction(ActionReqDto dto) {
        ActionEo eo = ActionEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.actionDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void modifyAction(ActionReqDto dto) {
        ActionEo eo = ActionEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        if (eo.getId() == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        this.actionDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void insertBatchActions(Long activityId, long activityTemplateId, List<ActionReqDto> actions) {
        if (!CollectionUtils.isEmpty(actions)) {
            Collection<ActionTemplateRespDto> actionTemplateRespDtos = this.actionTemplateService.queryByAcTemplateId(activityTemplateId);
            actionTemplateRespDtos.forEach(actionTemplate -> {
                TemplateDefine conditionTemplateDefine = (TemplateDefine)JSON.parseObject((String)actionTemplate.getActionDefine(), TemplateDefine.class);
                ActionReqDto matchDto = actions.stream().filter(actionInstance -> actionInstance.getActionTemplateId().equals(actionTemplate.getId())).findAny().orElse(null);
                String params = "{}";
                if (null != matchDto) {
                    params = matchDto.getActionParams();
                }
                ConditionTemplate.validateConfigParams(conditionTemplateDefine, params);
            });
            List<ActionEo> actionEoList = BeanCopyUtil.copyCollections(actions, ActionEo.class, new String[0]);
            actionEoList.forEach(a -> {
                a.setActivityId(activityId);
                a.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                a.setTenantId(ServiceContext.getContext().getRequestTenantId());
            });
            this.actionDas.insertBatch(actionEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteAction(long id) {
        this.actionDas.logicDeleteById(Long.valueOf(id));
    }

    @Override
    public List<ActionRespDto> queryActionList(ActionReqDto dto) {
        ActionEo eo = this.getActionEo(dto);
        List eoList = this.actionDas.select((BaseEo)eo);
        ArrayList<ActionRespDto> dtoList = new ArrayList<ActionRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, ActionRespDto.class);
        return dtoList;
    }

    @Override
    @Cacheable(key="'cache_action_list_' +  #activityId", value={"actionListCache"}, unless="#result == null")
    public List<ActionRespDto> queryActionListByActivityId(Long activityId) {
        ActionReqDto actionReqDto = new ActionReqDto();
        actionReqDto.setActivityId(activityId);
        List<ActionRespDto> list = this.queryActionList(actionReqDto);
        return list;
    }

    @Override
    @CacheEvict(key="'cache_action_list_' +  #activityId", value={"actionListCache"})
    public void clearActionListByActivityId(Long activityId) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAction(ActionEo actionEo) {
        if (null != actionEo.getId()) {
            this.actionDas.updateSelective((BaseEo)actionEo);
        } else {
            this.actionDas.update((BaseEo)actionEo);
        }
    }

    @Override
    public void deleteByActivityId(long activity) {
        ActionEo eo = new ActionEo();
        eo.setActivityId(Long.valueOf(activity));
        this.actionDas.delete((BaseEo)eo);
    }

    @Override
    public PageInfo<ActionRespDto> queryActionPage(ActionReqDto dto, Integer pageNum, Integer pageSize) {
        ActionEo eo = this.getActionEo(dto);
        PageInfo pageInfo = this.actionDas.selectPage((BaseEo)eo, pageNum, pageSize);
        ArrayList respDtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), respDtoList, ActionRespDto.class);
        pageInfo.setList(respDtoList);
        return pageInfo;
    }

    private ActionEo getActionEo(ActionReqDto dto) {
        ActionEo eo = ActionEo.newInstance();
        CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        eo.setSqlFilters(SqlFilterBuilder.newInstance().buildBetweenSqlFilter("create_time", dto.getCreateStartTime(), dto.getCreateEndTime()).get());
        return eo;
    }

    private void checkBase(Long instanceId, Long tenantId) {
        if (instanceId == null || tenantId == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.PARAMETER_ERROR);
        }
    }
}

