/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemStorageApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageBranchQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemStorageQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityItemStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConstantsStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ActivityItemTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizExceptionCodeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityJoinLogExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.param.ActivityStockTypeParam;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityItemDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityItemEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityItemEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ActivityItemServiceImpl
implements IActivityItemService {
    private static final Logger logger = LoggerFactory.getLogger(ActivityItemServiceImpl.class);
    @Autowired
    private ActivityItemDas activityItemDas;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private ICommonsMqService commonsMqService;
    @Autowired
    private ActivityDas activityDas;
    @Resource
    private IItemStorageApi itemStorageApi;
    @Resource
    private IItemStorageQueryApi itemStorageQueryApi;
    @Resource
    private IActivityJoinLogExtService activityJoinLogExtService;
    @Autowired
    private IActivityItemRuleService activityItemRuleService;
    @CubeResource
    private ActivityStockTypeParam activityStockTypeParam;
    @Resource
    private IActivityService activityService;
    private static final String ACTIVITY_ITEM = "ACTIVITY_ITEM";
    @Resource
    private IItemQueryApi itemQueryApi;

    @Override
    public ActivityItemRespDto queryActivityItemDetail(Long id) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActivityItemEo eo = this.checkById(id, ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActivityItemRespDto activityItemRespDto = new ActivityItemRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)activityItemRespDto);
        return activityItemRespDto;
    }

    @Override
    public List<ActivityItemRespDto> queryActivityItem(ActivityItemQueryReqDto reqDto) {
        this.checkBase(ServiceContext.getContext().getRequestInstanceId(), ServiceContext.getContext().getRequestTenantId());
        ActivityItemEo eo = new ActivityItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        List eos = this.activityItemDas.select((BaseEo)eo);
        ArrayList<ActivityItemRespDto> dtos = new ArrayList<ActivityItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtos, ActivityItemRespDto.class);
        return dtos;
    }

    @Override
    public List<ActivityItemRespDto> queryByActivity(Long activityTemplateId, Long activityId) {
        ArrayList<ActivityItemRespDto> activityItemlist;
        block7: {
            block6: {
                activityItemlist = new ArrayList<ActivityItemRespDto>();
                if (null == activityTemplateId && null == activityId) {
                    return activityItemlist;
                }
                if (null == activityId) break block6;
                ActivityItemEo record = new ActivityItemEo();
                record.setActivityId(activityId);
                List eos = this.activityItemDas.select((BaseEo)record);
                if (CollectionUtils.isEmpty((Collection)eos)) break block7;
                for (ActivityItemEo activityItemEo : eos) {
                    ActivityItemRespDto activityItemRespDto = new ActivityItemRespDto();
                    activityItemRespDto.setActivityId(activityItemEo.getActivityId());
                    activityItemRespDto.setItemId(activityItemEo.getItemId());
                    activityItemlist.add(activityItemRespDto);
                }
                break block7;
            }
            ActivityEo activityEo = new ActivityEo();
            activityEo.setActivityTemplateId(activityTemplateId);
            ArrayList activitySqlFilters = Lists.newArrayList();
            activitySqlFilters.add(SqlFilter.in((String)"activityStatus", (Object)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()})));
            activityEo.setSqlFilters((List)activitySqlFilters);
            List activitys = this.activityDas.select((BaseEo)activityEo);
            if (CollectionUtils.isEmpty((Collection)activitys)) {
                return activityItemlist;
            }
            ArrayList<Long> activityIds = new ArrayList<Long>();
            for (ActivityEo activity : activitys) {
                activityIds.add(activity.getId());
            }
            ActivityItemEo record = new ActivityItemEo();
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"activityId", activityIds));
            record.setSqlFilters((List)sqlFilters);
            List eos = this.activityItemDas.select((BaseEo)record);
            HashSet<Long> set = new HashSet<Long>();
            if (!CollectionUtils.isEmpty((Collection)eos)) {
                for (ActivityItemEo activityItemEo : eos) {
                    if (set.contains(activityItemEo.getItemId())) continue;
                    ActivityItemRespDto activityItemRespDto = new ActivityItemRespDto();
                    activityItemRespDto.setItemId(activityItemEo.getItemId());
                    activityItemRespDto.setActivityId(activityItemEo.getActivityId());
                    activityItemlist.add(activityItemRespDto);
                    set.add(activityItemEo.getItemId());
                }
            }
        }
        return activityItemlist;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Long addActivityItem(ActivityItemReqDto dto) {
        ActivityItemEo eo = new ActivityItemEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        this.activityItemDas.insert((BaseEo)eo);
        return eo.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Collection<Long> saveActivityItems(Collection<ActivityItemReqDto> dtos) {
        LinkedList<ActivityItemEo> saveEos = new LinkedList<ActivityItemEo>();
        CubeBeanUtils.copyCollection(saveEos, dtos, ActivityItemEo.class);
        return this.saveActivityItems((List<ActivityItemEo>)saveEos);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Collection<Long> saveActivityItems(List<ActivityItemEo> saveEos) {
        LinkedList<Long> result = new LinkedList<Long>();
        List partition = Lists.partition(saveEos, (int)500);
        partition.forEach(listEos -> {
            this.activityItemDas.insertBatch(listEos);
            listEos.forEach(eo -> result.add(eo.getId()));
        });
        return result;
    }

    private void operateVirStorage(Long shopId, Long skuId, Long quantity) {
        ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
        itemStorageReqDto.setSkuId(skuId);
        itemStorageReqDto.setShopId(shopId);
        itemStorageReqDto.setBalance(quantity);
        try {
            RestResponse restResponse = this.itemStorageApi.operatingItemStorage(itemStorageReqDto);
            if (!"0".equals(restResponse.getResultCode())) {
                throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
            }
            logger.info("\u3010\u5546\u54c1\u865a\u62df\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1ashopId={}, skuId={}, quantity={}\u3011", new Object[]{shopId, skuId, quantity});
        }
        catch (Exception e) {
            logger.error("\u5546\u54c1\u4e2d\u5fc3\u629b\u9519", (Throwable)e);
            throw new BizException(ProBizExceptionCodeEnum.ITEM_STORAGE_NOT_ENOUGH.getCode(), ProBizExceptionCodeEnum.ITEM_STORAGE_NOT_ENOUGH.getMsg());
        }
    }

    @Override
    public Boolean returnItemVirStockFromActivityStock(Long activityId) {
        BatchItemStorageRespDto batchItemStorageRespDto;
        ActivityRespDto activityRespDto = this.activityService.queryById(activityId);
        if (null == activityRespDto) {
            logger.info("\u6d3b\u52a8\u4e0d\u5b58\u5728id={}", (Object)activityId);
            return false;
        }
        boolean newStatus = false;
        if (ActivityStatusEnum.NEW.getKey().equals(activityRespDto.getActivityStatus())) {
            newStatus = true;
        }
        List<ActivityItemRespDto> activityItemRespDtos = this.queryActivityItems(activityId, null);
        List<Long> itemIds = activityItemRespDtos.stream().map(ActivityItemRespDto::getItemId).collect(Collectors.toList());
        Map<Long, Boolean> bundleItemMap = this.getBundleItems(itemIds);
        ArrayList returnItemStockList = Lists.newArrayList();
        for (ActivityItemRespDto activityItemRespDto : activityItemRespDtos) {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setSkuId(activityItemRespDto.getSkuId());
            itemStorageReqDto.setShopId(activityItemRespDto.getShopId());
            if (bundleItemMap.get(activityItemRespDto.getItemId()).booleanValue()) {
                itemStorageReqDto.setItemType(ItemTypeEnum.BUNDLE.getType());
            }
            if (newStatus) {
                itemStorageReqDto.setBalance(activityItemRespDto.getOriginalStock());
            } else {
                itemStorageReqDto.setBalance(activityItemRespDto.getRemainingStock());
            }
            itemStorageReqDto.setActivity(activityId);
            if (itemStorageReqDto.getBalance() <= 0L) continue;
            returnItemStockList.add(itemStorageReqDto);
        }
        if (CollectionUtils.isEmpty((Collection)returnItemStockList)) {
            logger.info("\u6d3b\u52a8id={}\uff0c\u6d3b\u52a8\u5e93\u5b58\u90fd\u4e3a0\u65e0\u9700\u56de\u6eda\u5e93\u5b58", (Object)activityId);
            return true;
        }
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList((List)returnItemStockList);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
            logger.error("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u65b0\u589e\u5546\u54c1\u5e93\u5b58\u5931\u8d25code={}\uff0cmsg={}", (Object)batchItemStorageRespDtoRestResponse.getResultCode(), (Object)batchItemStorageRespDtoRestResponse.getResultMsg());
        }
        if ((batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData()).getIfAllSuccess().booleanValue()) {
            logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u5b8c\u6574\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58");
            for (ActivityItemRespDto activityItemRespDto : activityItemRespDtos) {
                try {
                    this.activityItemRuleService.increase(activityId, activityItemRespDto.getSkuId(), activityItemRespDto.getShopId(), -activityItemRespDto.getRemainingStock().intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u5e93\u5b58");
                }
                catch (Exception e) {
                    logger.error("\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", new Object[]{e, activityId, activityItemRespDto.getSkuId(), activityItemRespDto.getRemainingStock()});
                }
            }
        } else {
            logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u4e0d\u5b8c\u6574\u6263\u51cf\u5e93\u5b58");
            if (CollectionUtils.isEmpty((Collection)batchItemStorageRespDto.getSuccessList())) {
                logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u4e0d\u5b8c\u6574\u6263\u51cf\u5e93\u5b58\uff0c\u5217\u8868\u4e0d\u4e3a\u7a7a");
                for (ItemStorageRespDto itemStorageRespDto : batchItemStorageRespDto.getSuccessList()) {
                    try {
                        this.activityItemRuleService.increase(activityId, itemStorageRespDto.getSkuId(), -itemStorageRespDto.getShopId().longValue(), -itemStorageRespDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u5e93\u5b58");
                    }
                    catch (Exception e) {
                        logger.error("\u4e0d\u5b8c\u6574\u65b0\u589e\u6210\u529f\u7684\u6263\u51cf\u5e93\u5b58\uff0c\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", new Object[]{e, activityId, itemStorageRespDto.getSkuId(), itemStorageRespDto.getBalance()});
                    }
                }
            }
        }
        logger.info("\u6d3b\u52a8id={}\u6263\u51cf\u5269\u4f59\u6d3b\u52a8\u5e93\u5b58\u5b8c\u6bd5", (Object)activityId);
        return batchItemStorageRespDto.getIfAllSuccess();
    }

    @Override
    public Boolean rollbackStock(Long activityId) {
        logger.info("\u6d3b\u52a8id={}\uff0c\u7ed3\u675f\u6d3b\u52a8\u56de\u9000\u5e93\u5b58\u5904\u7406\uff0c\u8bfb\u53d6\u914d\u7f6e\u9879={}", (Object)activityId, this.activityStockTypeParam.getValue());
        if (ActivityStockTypeParam.PREEMPT.equals(this.activityStockTypeParam.getValue())) {
            return this.returnItemVirStockFromActivityStock(activityId);
        }
        return true;
    }

    @Override
    public boolean validateBranchItemStock(List<ItemVo> items) {
        if (CollectionUtils.isEmpty(items)) {
            return false;
        }
        ItemStorageBranchQueryReqDto itemStorageBranchQueryReqDto = new ItemStorageBranchQueryReqDto();
        HashMap itemNumMap = new HashMap();
        List selfList = items.stream().map(item -> {
            itemNumMap.put(item.getShopId() + "_" + item.getSkuId(), item.getNum());
            Long itemId = Long.valueOf(item.getItemId());
            Long skuId = Long.valueOf(item.getSkuId());
            Long shopId = Long.valueOf(item.getShopId());
            ShelfReqDto itemShelfReqDto = new ShelfReqDto();
            itemShelfReqDto.setItemId(itemId);
            itemShelfReqDto.setShopId(shopId);
            itemShelfReqDto.setSkuId(skuId);
            return itemShelfReqDto;
        }).collect(Collectors.toList());
        itemStorageBranchQueryReqDto.setShelfList(selfList);
        RestResponse listRestResponse = this.itemStorageQueryApi.queryBranchItemStorage(itemStorageBranchQueryReqDto);
        if (!"0".equals(listRestResponse.getResultCode())) {
            throw new BizException(listRestResponse.getResultCode(), listRestResponse.getResultMsg());
        }
        List itemStorageQueryRespDtoList = (List)listRestResponse.getData();
        for (ItemStorageQueryRespDto itemStorageQueryRespDto : itemStorageQueryRespDtoList) {
            Long stock = itemStorageQueryRespDto.getAvaNum();
            Integer itemNum = (Integer)itemNumMap.get(itemStorageQueryRespDto.getShopId() + "_" + itemStorageQueryRespDto.getSkuId());
            if (stock != null && stock >= 0L && (long)itemNum.intValue() <= stock) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean returnItemVirStockFromActivityStockTob(Long activityId) {
        BatchItemStorageRespDto batchItemStorageRespDto;
        List<Object> activityItemRespDtos = this.queryActivityItems(activityId, null);
        if (CollectionUtils.isEmpty(activityItemRespDtos = activityItemRespDtos.stream().filter(activityItemRespDto -> activityItemRespDto.getRemainingStock() > 0L).collect(Collectors.toList()))) {
            logger.info("\u6d3b\u52a8id={}\uff0c\u6d3b\u52a8\u5e93\u5b58\u90fd\u4e3a0\u65e0\u9700\u56de\u6eda\u5e93\u5b58", (Object)activityId);
            return true;
        }
        HashMap activityStockMap = new HashMap();
        List returnItemStockList = activityItemRespDtos.stream().map(activityItemRespDto -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setSkuId(activityItemRespDto.getSkuId());
            itemStorageReqDto.setShopId(activityItemRespDto.getShopId());
            itemStorageReqDto.setBalance(activityItemRespDto.getRemainingStock());
            itemStorageReqDto.setActivity(activityId);
            activityStockMap.put(activityItemRespDto.getShopId() + "_" + activityItemRespDto.getSkuId(), activityItemRespDto.getActivityStock());
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(returnItemStockList);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
            logger.error("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u65b0\u589e\u5546\u54c1\u5e93\u5b58\u5931\u8d25code={}\uff0cmsg={}", (Object)batchItemStorageRespDtoRestResponse.getResultCode(), (Object)batchItemStorageRespDtoRestResponse.getResultMsg());
        }
        if ((batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData()).getIfAllSuccess().booleanValue()) {
            logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u5b8c\u6574\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58", (Object)activityId);
            for (ActivityItemRespDto activityItemRespDto2 : activityItemRespDtos) {
                try {
                    this.activityItemRuleService.increaseJoinNum(activityId, activityItemRespDto2.getSkuId(), activityItemRespDto2.getShopId(), -activityItemRespDto2.getActivityStock().intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u53c2\u4e0e\u6b21\u6570");
                }
                catch (Exception e) {
                    logger.error("\u62a5\u9519\u4fe1\u606f{}\uff0c\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u53c2\u4e0e\u6b21\u6570\u5931\u8d25", new Object[]{e, activityId, activityItemRespDto2.getSkuId(), activityItemRespDto2.getRemainingStock()});
                }
                try {
                    this.activityItemRuleService.increase(activityId, activityItemRespDto2.getSkuId(), activityItemRespDto2.getShopId(), -activityItemRespDto2.getRemainingStock().intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u5e93\u5b58");
                }
                catch (Exception e) {
                    logger.error("\u62a5\u9519\u4fe1\u606f{}\uff0c\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", new Object[]{e, activityId, activityItemRespDto2.getSkuId(), activityItemRespDto2.getRemainingStock()});
                }
            }
        } else {
            logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u4e0d\u5b8c\u6574\u6263\u51cf\u5e93\u5b58", (Object)activityId);
            if (CollectionUtils.isEmpty((Collection)batchItemStorageRespDto.getSuccessList())) {
                logger.info("\u6d3b\u52a8id={}\uff0c\u8fdb\u5165\u4e0d\u5b8c\u6574\u6263\u51cf\u5e93\u5b58\uff0c\u5217\u8868\u4e0d\u4e3a\u7a7a", (Object)activityId);
                for (ItemStorageRespDto itemStorageRespDto : batchItemStorageRespDto.getSuccessList()) {
                    Long activityStock = (Long)activityStockMap.get(itemStorageRespDto.getShopId() + "_" + itemStorageRespDto.getSkuId());
                    if (Objects.nonNull(activityStock)) {
                        try {
                            this.activityItemRuleService.increaseJoinNum(activityId, itemStorageRespDto.getSkuId(), itemStorageRespDto.getShopId(), -activityStock.intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u53c2\u4e0e\u6b21\u6570");
                        }
                        catch (Exception e) {
                            logger.error("\u62a5\u9519\u4fe1\u606f{}\uff0c\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u53c2\u4e0e\u6b21\u6570\u5931\u8d25", new Object[]{e, activityId, itemStorageRespDto.getSkuId(), activityStock});
                        }
                    }
                    try {
                        this.activityItemRuleService.increase(activityId, itemStorageRespDto.getSkuId(), itemStorageRespDto.getShopId(), -itemStorageRespDto.getBalance().intValue(), ActivityItemTypeEnum.ITEM, "\u7ed3\u675f\u6d3b\u52a8\u6263\u53d6\u5269\u4f59\u5e93\u5b58");
                    }
                    catch (Exception e) {
                        logger.error("\u62a5\u9519\u4fe1\u606f{}\uff0c\u4e0d\u5b8c\u6574\u65b0\u589e\u6210\u529f\u7684\u6263\u51cf\u5e93\u5b58\uff0c\u6d3b\u52a8id={},\u56de\u9000\u5e93\u5b58\u4e2d\uff0csku={}\uff0c\u56de\u9000\u6570\u91cf\u4e3a{}.\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", new Object[]{e, activityId, itemStorageRespDto.getSkuId(), itemStorageRespDto.getBalance()});
                    }
                }
            }
        }
        logger.info("\u6d3b\u52a8id={}\u6263\u51cf\u5269\u4f59\u6d3b\u52a8\u5e93\u5b58\u5b8c\u6bd5", (Object)activityId);
        return batchItemStorageRespDto.getIfAllSuccess();
    }

    @Override
    public void returnStockFromCancelJoinActivity(String orderCode, Long activityId, Map<String, List<String>> activityIdsMap) {
        Integer stockType = (Integer)this.activityStockTypeParam.getValue();
        List<ActivityJoinLogEo> activityJoinLogEos = this.activityJoinLogExtService.getByOrderCodeAndActivityId(orderCode, activityId);
        if (!CollectionUtils.isEmpty(activityJoinLogEos)) {
            List newActivityJoinLogEos = activityJoinLogEos.stream().filter(join -> !join.getStatus().equals(ConstantsStatusEnum.CANCEL.getStatus())).collect(Collectors.toList());
            ArrayList<ActivityJoinLogEo> successList = new ArrayList<ActivityJoinLogEo>();
            ArrayList<ActivityJoinLogEo> needReturnLogs = new ArrayList<ActivityJoinLogEo>();
            ArrayList<ActivityJoinLogEo> preemptNeedReturnLogs = new ArrayList<ActivityJoinLogEo>();
            List<ActivityItemRespDto> activityItemRespDtos = this.queryActivityItems(activityId, null);
            if (CollectionUtils.isEmpty(activityItemRespDtos)) {
                if (ActivityStockTypeParam.SHARE.equals(stockType)) {
                    if (!CollectionUtils.isEmpty(newActivityJoinLogEos)) {
                        logger.info("\u8ba2\u5355\u53f7={}\u6d3b\u52a8id={}\uff0c\u53d6\u6d88\u53c2\u4e0e\u6d3b\u52a8\u56de\u6eda\u5e93\u5b58\u5546\u54c1\u5217\u8868{}", new Object[]{orderCode, activityId, JSON.toJSONString(activityJoinLogEos)});
                        List<Long> cancelIds = newActivityJoinLogEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                        this.activityJoinLogExtService.cancel(cancelIds);
                    }
                    return;
                }
                ArrayList rollBackItemStorages = Lists.newArrayList();
                for (ActivityJoinLogEo newActivityJoinLogEo : newActivityJoinLogEos) {
                    List<String> activityIds = activityIdsMap.get(newActivityJoinLogEo.getShopId() + "_" + newActivityJoinLogEo.getSkuId());
                    if (CollectionUtils.isEmpty(activityIds) || !activityIds.get(0).equals(activityId.toString())) continue;
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(newActivityJoinLogEo.getItemNum().intValue()));
                    itemStorageReqDto.setOrderNo(orderCode);
                    itemStorageReqDto.setShopId(Long.valueOf(newActivityJoinLogEo.getShopId()));
                    itemStorageReqDto.setSkuId(Long.valueOf(newActivityJoinLogEo.getSkuId()));
                    rollBackItemStorages.add(itemStorageReqDto);
                }
                if (!CollectionUtils.isEmpty((Collection)rollBackItemStorages)) {
                    BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                    batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                    batchItemStorageReqDto.setItemStorageReqDtoList((List)rollBackItemStorages);
                    RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
                    if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
                        logger.error("\u53d6\u6d88\u8ba2\u5355\u65f6\uff0c\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u65b0\u589e\u5546\u54c1\u5e93\u5b58\u5931\u8d25code={}\uff0cmsg={}", (Object)batchItemStorageRespDtoRestResponse.getResultCode(), (Object)batchItemStorageRespDtoRestResponse.getResultMsg());
                    }
                    BatchItemStorageRespDto batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData();
                    logger.info("\u56de\u6eda\u5546\u54c1\u5e93\u5b58ifAllSuccess={}\uff0csuccessList={}", (Object)JSON.toJSONString((Object)batchItemStorageRespDto.getIfAllSuccess()), (Object)JSON.toJSONString((Object)batchItemStorageRespDto.getSuccessList()));
                }
                if (!CollectionUtils.isEmpty(newActivityJoinLogEos)) {
                    logger.info("\u8ba2\u5355\u53f7={}\u6d3b\u52a8id={}\uff0c\u53d6\u6d88\u53c2\u4e0e\u6d3b\u52a8\u56de\u6eda\u5e93\u5b58\u5546\u54c1\u5217\u8868{}", new Object[]{orderCode, activityId, JSON.toJSONString(activityJoinLogEos)});
                    List<Long> cancelIds = newActivityJoinLogEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.activityJoinLogExtService.cancel(cancelIds);
                }
                return;
            }
            logger.info("\u5f00\u59cb\u56de\u6eda\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u548c\u6d3b\u52a8\u5e93\u5b58\uff0c\u6d3b\u52a8\u5e93\u5b58\u7b56\u7565\u914d\u7f6e\u9879={}", (Object)stockType);
            for (ActivityJoinLogEo newActivityJoinLogEo : newActivityJoinLogEos) {
                boolean isFirst = false;
                List<String> activityIds = activityIdsMap.get(newActivityJoinLogEo.getShopId() + "_" + newActivityJoinLogEo.getSkuId());
                if (!CollectionUtils.isEmpty(activityIds) && activityIds.get(0).equals(activityId.toString())) {
                    needReturnLogs.add(newActivityJoinLogEo);
                    isFirst = true;
                }
                int joinNum = this.activityItemRuleService.getJoinNum(newActivityJoinLogEo.getActivityId(), Long.parseLong(newActivityJoinLogEo.getSkuId()), Long.valueOf(newActivityJoinLogEo.getShopId()), ActivityItemTypeEnum.ITEM);
                if (ActivityStockTypeParam.PREEMPT.equals(stockType) && isFirst && joinNum == -1) {
                    preemptNeedReturnLogs.add(newActivityJoinLogEo);
                }
                if (joinNum == -1) continue;
                try {
                    this.activityItemRuleService.increaseJoinNum(newActivityJoinLogEo.getActivityId(), Long.parseLong(newActivityJoinLogEo.getSkuId()), Long.valueOf(newActivityJoinLogEo.getShopId()), newActivityJoinLogEo.getItemNum(), ActivityItemTypeEnum.ITEM, "\u53d6\u6d88\u53c2\u4e0e\u6d3b\u52a8\u56de\u6eda\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570");
                    successList.add(newActivityJoinLogEo);
                }
                catch (Exception e) {
                    logger.info("\u8ba2\u5355\u53f7={}\u6d3b\u52a8id={}\u53d6\u6d88\u6d3b\u52a8\u65b0\u589e\u6d3b\u52a8\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u5931\u8d25", new Object[]{orderCode, activityId, e});
                }
                if (!isFirst) continue;
                try {
                    this.activityItemRuleService.increase(newActivityJoinLogEo.getActivityId(), Long.parseLong(newActivityJoinLogEo.getSkuId()), Long.valueOf(newActivityJoinLogEo.getShopId()), newActivityJoinLogEo.getItemNum(), ActivityItemTypeEnum.ITEM, "\u53d6\u6d88\u53c2\u4e0e\u6d3b\u52a8\u56de\u6eda\u6d3b\u52a8\u5e93\u5b58");
                }
                catch (Exception e) {
                    logger.info("\u8ba2\u5355\u53f7={}\u6d3b\u52a8id={}\u53d6\u6d88\u6d3b\u52a8\u65b0\u589e\u6d3b\u52a8\u5e93\u5b58\u5931\u8d25", new Object[]{orderCode, activityId, e});
                }
            }
            logger.info("\u7ed3\u675f\u56de\u6eda\u5269\u4f59\u53c2\u4e0e\u6b21\u6570\u548c\u6d3b\u52a8\u5e93\u5b58\uff0cneedReturnLogs={}", (Object)JSON.toJSONString(needReturnLogs));
            if (ActivityStockTypeParam.PREEMPT.equals(stockType) && !CollectionUtils.isEmpty(preemptNeedReturnLogs)) {
                List rollBackItemStorages = preemptNeedReturnLogs.stream().map(joinLogEo -> {
                    ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
                    itemStorageReqDto.setBalance(Long.valueOf(joinLogEo.getItemNum().intValue()));
                    itemStorageReqDto.setOrderNo(orderCode);
                    itemStorageReqDto.setShopId(Long.valueOf(joinLogEo.getShopId()));
                    itemStorageReqDto.setSkuId(Long.valueOf(joinLogEo.getSkuId()));
                    return itemStorageReqDto;
                }).collect(Collectors.toList());
                BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                batchItemStorageReqDto.setItemStorageReqDtoList(rollBackItemStorages);
                RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
                if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
                    logger.error("\u53d6\u6d88\u8ba2\u5355\u65f6\uff0c\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\uff0c\u65b0\u589e\u5546\u54c1\u5e93\u5b58\u5931\u8d25code={}\uff0cmsg={}", (Object)batchItemStorageRespDtoRestResponse.getResultCode(), (Object)batchItemStorageRespDtoRestResponse.getResultMsg());
                }
                BatchItemStorageRespDto batchItemStorageRespDto = (BatchItemStorageRespDto)batchItemStorageRespDtoRestResponse.getData();
                logger.info("\u56de\u6eda\u5546\u54c1\u5e93\u5b58ifAllSuccess={}\uff0csuccessList={}", (Object)JSON.toJSONString((Object)batchItemStorageRespDto.getIfAllSuccess()), (Object)JSON.toJSONString((Object)batchItemStorageRespDto.getSuccessList()));
            }
            if (!CollectionUtils.isEmpty(successList)) {
                logger.info("\u8ba2\u5355\u53f7={}\u6d3b\u52a8id={}\uff0c\u53d6\u6d88\u53c2\u4e0e\u6d3b\u52a8\u56de\u6eda\u5e93\u5b58\u5546\u54c1\u5217\u8868{}", new Object[]{orderCode, activityId, JSON.toJSONString(activityJoinLogEos)});
                List<Long> cancelIds = successList.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.activityJoinLogExtService.cancel(cancelIds);
            }
        }
    }

    @Override
    public boolean checkIsSubItemVirStock(Long activityTemplateId) {
        boolean isSubItemStock = ActivityStockTypeParam.PREEMPT.equals(this.activityStockTypeParam.getValue());
        if (isSubItemStock) {
            if (Long.valueOf(ActivityType.SECKILL_ACTIVITY.getId()).equals(activityTemplateId)) {
                return true;
            }
            if (Long.valueOf(ActivityType.GROUP_ACTIVITY.getId()).equals(activityTemplateId)) {
                return true;
            }
            if (Long.valueOf(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId()).equals(activityTemplateId) || Long.valueOf(ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId()).equals(activityTemplateId) || Long.valueOf(ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId()).equals(activityTemplateId) || Long.valueOf(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId()).equals(activityTemplateId) || Long.valueOf(ActivityType.SECKILL_TOB_ACTIVITY.getId()).equals(activityTemplateId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void subItemVirStock(String name, List<ActivityItemReqDto> activityItems) {
        if (CollectionUtils.isEmpty(activityItems)) {
            return;
        }
        logger.info("\u6d3b\u52a8\u540d\u79f0={},\u6b63\u5728\u6263\u51cf\u5e93\u5b58", (Object)name);
        List subList = activityItems.stream().filter(activityItemRespDto -> activityItemRespDto.getOriginalStock() != null && activityItemRespDto.getOriginalStock() > 0L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(subList)) {
            logger.info("\u6d3b\u52a8\u540d\u79f0={},\u65e0\u6d3b\u52a8\u5e93\u5b58\u53ef\u4ee5\u6263\u51cf", (Object)name);
            return;
        }
        logger.info("\u6d3b\u52a8\u6263\u51cf\u7684\u5546\u54c1\u5217\u8868\u4e3a\u5927\u5c0f\u4e3a{}", (Object)activityItems.size());
        List<Long> itemIds = subList.stream().map(ActivityItemReqDto::getItemId).collect(Collectors.toList());
        Map<Long, Boolean> bundleItemMap = this.getBundleItems(itemIds);
        List returnItemStockList = subList.stream().map(activityItemRespDto -> {
            ItemStorageReqDto itemStorageReqDto = new ItemStorageReqDto();
            itemStorageReqDto.setSkuId(activityItemRespDto.getSkuId());
            itemStorageReqDto.setShopId(activityItemRespDto.getShopId());
            itemStorageReqDto.setBalance(Long.valueOf(-activityItemRespDto.getOriginalStock().longValue()));
            if (((Boolean)bundleItemMap.get(activityItemRespDto.getItemId())).booleanValue()) {
                itemStorageReqDto.setItemType(ItemTypeEnum.BUNDLE.getType());
            }
            return itemStorageReqDto;
        }).collect(Collectors.toList());
        BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
        batchItemStorageReqDto.setItemStorageReqDtoList(returnItemStockList);
        batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.SUB);
        RestResponse batchItemStorageRespDtoRestResponse = this.itemStorageApi.batchOperatingItemStorage(batchItemStorageReqDto);
        if (!"0".equals(batchItemStorageRespDtoRestResponse.getResultCode())) {
            throw new BizException(batchItemStorageRespDtoRestResponse.getResultCode(), batchItemStorageRespDtoRestResponse.getResultMsg());
        }
    }

    private Map<Long, Boolean> getBundleItems(List<Long> itemIds) {
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>();
        List bundleItemRespDtos = null;
        for (Long itemId : itemIds) {
            bundleItemRespDtos = (List)this.itemQueryApi.queryBundleItem(itemId).getData();
            if (!CollectionUtils.isEmpty((Collection)bundleItemRespDtos)) {
                map.put(itemId, true);
                continue;
            }
            map.put(itemId, false);
        }
        logger.info("\u6d3b\u52a8\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
        return map;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void insertBatchItem(Long activityId, List<ActivityItemReqDto> activityItems) {
        if (CollectionUtils.isEmpty(activityItems)) {
            return;
        }
        ArrayList activityItemEos = Lists.newArrayList();
        for (ActivityItemReqDto activityItemReqDto : activityItems) {
            if (null == activityItemReqDto.getStatus() || null == activityItemReqDto.getItemId()) continue;
            ActivityItemEo activityItemEo = ActivityItemEo.newInstance();
            DtoHelper.dto2Eo((BaseVo)activityItemReqDto, (BaseEo)activityItemEo);
            activityItemEo.setActivityId(activityId);
            if (null != activityItemReqDto.getStatus()) {
                activityItemEo.setStatus(activityItemReqDto.getStatus().getKey());
            }
            activityItemEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
            activityItemEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
            activityItemEos.add(activityItemEo);
        }
        if (!CollectionUtils.isEmpty((Collection)activityItemEos)) {
            this.activityItemDas.insertBatch((List)activityItemEos);
        }
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void modifyActivityItem(Long id, ActivityItemReqDto dto) {
        ActivityItemEo eo = new ActivityItemEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
        if (id == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.PARAMETER_ERROR);
        }
        eo.setId(id);
        this.activityItemDas.updateSelective((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void enable(Long id) {
        ActivityItemEo eo = (ActivityItemEo)this.activityItemDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!ActivityItemStatusEnum.NEW.getKey().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("\u6d3b\u52a8\u5546\u54c1\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        ActivityItemEo updateEo = ActivityItemEo.newInstance();
        updateEo.setId(id);
        updateEo.setStatus(ActivityItemStatusEnum.ENABLED.getKey());
        this.activityItemDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void disable(Long id) {
        ActivityItemEo eo = (ActivityItemEo)this.activityItemDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new ProBusinessRuntimeException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!ActivityItemStatusEnum.ENABLED.getKey().equals(eo.getStatus())) {
            throw new BusinessRuntimeException("\u6d3b\u52a8\u5546\u54c1\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        ActivityItemEo updateEo = ActivityItemEo.newInstance();
        updateEo.setId(id);
        updateEo.setStatus(ActivityItemStatusEnum.DISABLED.getKey());
        this.activityItemDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteById(Long id) {
        this.activityItemDas.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteByItemId(Long itemId) {
        ActivityItemEo eo = new ActivityItemEo();
        eo.setItemId(itemId);
        this.activityItemDas.logicDelete((BaseEo)eo);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void deleteByActId(Long aId) {
        ActivityItemEo activityItemEo = ActivityItemEo.newInstance();
        activityItemEo.setActivityId(aId);
        activityItemEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        activityItemEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        this.activityItemDas.logicDelete((BaseEo)activityItemEo);
    }

    private void checkBase(Long instanceId, Long tenantId) {
    }

    private ActivityItemEo checkById(Long id, Long instanceId, Long tenantId) {
        ActivityItemEo eo = (ActivityItemEo)this.activityItemDas.selectByPrimaryKey(id);
        return eo;
    }

    @Override
    public List<ActivityItemRespDto> attachGift(Long activityId) {
        ActivityItemQueryReqDto reqDto = new ActivityItemQueryReqDto();
        reqDto.setActivityId(activityId);
        reqDto.setItemType(ActivityItemTypeEnum.GIFT.getKey());
        reqDto.setStatus(ActivityItemStatusEnum.ENABLED.getKey());
        List<ActivityItemRespDto> dtoList = this.queryActivityItem(reqDto);
        if (dtoList == null || dtoList.isEmpty()) {
            logger.debug("\u8be5\u6d3b\u52a8\u672a\u914d\u7f6e\u8d60\u54c1");
        }
        ArrayList<ActivityItemRespDto> giftList = new ArrayList<ActivityItemRespDto>();
        for (ActivityItemRespDto dto : dtoList) {
            Long giftId = dto.getId();
            Integer attachNum = dto.getAttachNum();
            if (attachNum == null) {
                logger.error("\u8be5\u8d60\u54c1\u672a\u914d\u7f6e\u8d60\u9001\u6570\u91cf | activityItemId = {}", (Object)giftId);
                break;
            }
            if (!this.activityItemRuleService.increase(activityId, dto.getId(), null, -attachNum.intValue(), ActivityItemTypeEnum.GIFT, "\u8d60\u9001\u5546\u54c1")) continue;
            giftList.add(dto);
        }
        return giftList;
    }

    @Override
    public List<Long> queryByItemId(long itemId) {
        ActivityItemEo eo = ActivityItemEo.newInstance();
        eo.setItemId(Long.valueOf(itemId));
        eo.setStatus(EnableStatusEnum.ENABLE.getKey());
        LinkedList acIds = this.activityItemDas.findListColumn((BaseEo)eo, new String[]{"activity_id"});
        if (null == acIds) {
            acIds = new LinkedList();
        }
        return acIds.stream().map(StdActivityItemEo::getActivityId).collect(Collectors.toList());
    }

    @Override
    public List<ActivityItemEo> queryActivityByActivityId(Long activityId) {
        ActivityItemEo eo = ActivityItemEo.newInstance();
        eo.setActivityId(activityId);
        return this.activityItemDas.select((BaseEo)eo);
    }

    @Override
    public List<ActivityItemEo> queryActivityByActivityIds(List<Long> activityIds) {
        ActivityItemEo eo = ActivityItemEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"activityId", activityIds));
        eo.setSqlFilters((List)sqlFilters);
        return this.activityItemDas.select((BaseEo)eo);
    }

    @Override
    public List<ActivityItemRespDto> queryActivityItems(Long activityId, Long itemId) {
        String key = "activityItems_" + activityId + "_" + itemId;
        ArrayList<ActivityItemRespDto> items = this.cacheService.getList(key, ActivityItemRespDto.class);
        if (null == items) {
            items = new ArrayList<ActivityItemRespDto>();
            ActivityItemEo activityItemEo = new ActivityItemEo();
            activityItemEo.setActivityId(activityId);
            activityItemEo.setItemId(itemId);
            List activityItemEos = this.activityItemDas.select((BaseEo)activityItemEo);
            DtoHelper.eoList2DtoList((Collection)activityItemEos, items, ActivityItemRespDto.class);
            this.cacheService.rpush(key, items, 1800);
        }
        items.forEach(item -> {
            int stock = this.activityItemRuleService.get(activityId, item.getSkuId(), item.getShopId(), ActivityItemTypeEnum.ITEM);
            item.setRemainingStock(Long.valueOf(stock));
            int joinNum = this.activityItemRuleService.getJoinNum(activityId, item.getSkuId(), item.getShopId(), ActivityItemTypeEnum.ITEM);
            item.setActivityStock(Long.valueOf(joinNum));
        });
        return items;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public void batchStock(Long activityId, List<ItemVo> items) {
        items.stream().forEach(gift -> {
            ActivityItemQueryReqDto dto = new ActivityItemQueryReqDto();
            dto.setActivityId(activityId);
            dto.setItemType(ActivityItemTypeEnum.GIFT.getKey());
            dto.setItemId(Long.valueOf(Long.parseLong(gift.getItemId())));
            ActivityItemRespDto activityItemRespDto = this.queryActivityItem(dto).get(0);
            if (activityItemRespDto.getRemainingStock() < (long)gift.getNum()) {
                throw new BusinessRuntimeException("\u8d60\u54c1\u5e93\u5b58\u4e0d\u8db3,\u8d60\u9001\u5931\u8d25\uff01");
            }
            ActivityItemEo eo = new ActivityItemEo();
            eo.setId(activityItemRespDto.getId());
            eo.setRemainingStock(Long.valueOf(activityItemRespDto.getRemainingStock() - (long)gift.getNum()));
            this.activityItemDas.updateSelective((BaseEo)eo);
        });
    }
}

