/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.constant.GroupActivityConstant;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupAddReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupDetailReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupJoinReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.mq.producer.ActivityGroupOperateProducer;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.IActivityGroupService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.ICacheGroupService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.crowdordering.service.IScheduleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.crowdordering.das.ActivityGroupDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.crowdordering.das.ActivityGroupDetailDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.crowdordering.ActivityGroupDetailEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.crowdordering.ActivityGroupEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.crowdordering.StdActivityGroupDetailEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityGroupServiceImpl
implements IActivityGroupService {
    private Logger logger = LoggerFactory.getLogger(ActivityGroupServiceImpl.class);
    @Autowired
    private ActivityGroupDas activityGroupDas;
    @Resource
    private ActivityGroupDetailDas activityGroupDetailDas;
    @Resource
    private ICacheGroupService cacheGroupService;
    @Resource
    private IScheduleService scheduleService;
    @Resource
    ActivityGroupOperateProducer activityGroupOperateProducer;

    @Override
    public List<ActivityGroupRespDto> query(ActivityGroupEo query) {
        List select = this.activityGroupDas.select((BaseEo)query);
        return BeanCopyUtil.copyCollections(select, ActivityGroupRespDto.class, new String[0]);
    }

    @Override
    public PageInfo<ActivityGroupRespDto> queryByPage(ActivityGroupReqDto activityGroupReqDto, Integer pageNum, Integer pageSize) {
        ActivityGroupEo activityGroupEo = ActivityGroupEo.newInstance();
        CubeBeanUtils.copyProperties((Object)activityGroupEo, (Object)activityGroupReqDto, (String[])new String[0]);
        activityGroupEo.setOrderBy("open_time");
        if (CollectionUtils.isNotEmpty((Collection)activityGroupReqDto.getGroupStatusList())) {
            ArrayList sqlFilterList = Lists.newArrayList();
            sqlFilterList.add(SqlFilter.in((String)"groupStatus", (Object)activityGroupReqDto.getGroupStatusList()));
            activityGroupEo.setSqlFilters((List)sqlFilterList);
        }
        PageInfo pageInfo = this.activityGroupDas.selectPage((BaseEo)activityGroupEo, pageNum, pageSize);
        List<ActivityGroupRespDto> list = BeanCopyUtil.copyCollections(pageInfo.getList(), ActivityGroupRespDto.class, new String[0]);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public BigDecimal countOrderAmount(Long activityId, Long groupId) {
        BigDecimal orderAmount = this.activityGroupDetailDas.countOrderAmount(activityId, groupId);
        return orderAmount == null ? BigDecimal.ZERO : orderAmount;
    }

    @Override
    public Long countGroupNumber(Long activityId, Long groupId) {
        Long groupNumber = this.activityGroupDetailDas.countGroupNumber(activityId, groupId);
        return groupNumber == null ? 0L : groupNumber;
    }

    @Override
    public void checkJoinStatusActivityGroup(Long id) {
        ActivityGroupEo activityGroupEo = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(id);
        if (!activityGroupEo.getGroupStatus().equals(0)) {
            throw new BizException("\u62fc\u56e2\u6d3b\u52a8\u7ed3\u675f\u65e0\u6cd5\u53c2\u56e2");
        }
    }

    @Override
    public void modifyGroupSuccess(Long id) {
        ActivityGroupEo activityGroupEo = new ActivityGroupEo();
        activityGroupEo.setId(id);
        activityGroupEo.setGroupStatus(Integer.valueOf(1));
        activityGroupEo.setSuccessTime(new Date());
        this.activityGroupDas.updateSelective((BaseEo)activityGroupEo);
        this.activityGroupOperateProducer.sendOperateOrderMqMessage(id, "CONFIRM_DELIVERY");
    }

    @Override
    public void modifyGroupClose(Long id) {
        ActivityGroupEo activityGroup = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(id);
        if (activityGroup.getGroupStatus().equals(1)) {
            this.logger.info("\u6d3b\u52a8\u5206\u7ec4id={}\u7684\u72b6\u6001\u5df2\u7ecf\u6539\u6210\u529f\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406", (Object)id);
            return;
        }
        ActivityGroupEo activityGroupEo = new ActivityGroupEo();
        activityGroupEo.setId(id);
        activityGroupEo.setGroupStatus(Integer.valueOf(4));
        activityGroupEo.setCloseTime(new Date());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"group_status", (Object)3));
        sqlFilters.add(SqlFilter.eq((String)"id", (Object)id));
        activityGroupEo.setSqlFilters(sqlFilters);
        this.activityGroupDas.updateSelectiveSqlFilter((BaseEo)activityGroupEo);
        this.activityGroupOperateProducer.sendOperateOrderMqMessage(id, "CANCEL");
    }

    @Override
    public void modifyGroupFail(Long id) {
        ActivityGroupEo activityGroup = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(id);
        if (activityGroup.getGroupStatus().equals(1)) {
            this.logger.info("\u6d3b\u52a8\u5206\u7ec4id={}\u7684\u72b6\u6001\u5df2\u7ecf\u6539\u6210\u529f\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406", (Object)id);
            return;
        }
        ActivityGroupEo activityGroupEo = new ActivityGroupEo();
        activityGroupEo.setId(id);
        activityGroupEo.setGroupStatus(Integer.valueOf(2));
        activityGroupEo.setCloseTime(new Date());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"group_status", (Object)0));
        sqlFilters.add(SqlFilter.eq((String)"id", (Object)id));
        activityGroupEo.setSqlFilters(sqlFilters);
        this.activityGroupDas.updateSelectiveSqlFilter((BaseEo)activityGroupEo);
        this.activityGroupOperateProducer.sendOperateOrderMqMessage(id, "CANCEL");
    }

    public void openingGroup(Long id, Integer addMinutes, Long tenantId, Long instanceId) {
        Date closeTime = DateUtils.addMinutes((Date)new Date(), (int)addMinutes);
        ActivityGroupEo activityGroupEo = new ActivityGroupEo();
        activityGroupEo.setId(id);
        activityGroupEo.setGroupStatus(Integer.valueOf(0));
        activityGroupEo.setOpenTime(new Date());
        activityGroupEo.setCloseTime(closeTime);
        this.activityGroupDas.updateSelective((BaseEo)activityGroupEo);
        this.scheduleService.addGroupActivityOverTime(id, closeTime, tenantId, instanceId);
    }

    private void replyGroupJoinCheckAndDo(String orderNo, String groupId) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u8fdb\u5165\u91cd\u8bd5\u9636\u6bb5,\u6d3b\u52a8id={}", (Object)orderNo, (Object)groupId);
        ActivityGroupEo activityGroupEo = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(Long.valueOf(groupId));
        if (activityGroupEo.getGroupStatus().equals(2)) {
            this.modifyGroupFail(Long.valueOf(groupId));
        }
        if (activityGroupEo.getGroupStatus().equals(1)) {
            this.modifyGroupSuccess(Long.valueOf(groupId));
        }
    }

    @Override
    public void preJoin(ActivityGroupJoinReqDto activityGroupJoinReqDto) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u9884\u53c2\u4e0e\u6d3b\u52a8{}", (Object)activityGroupJoinReqDto.getOrderNo(), (Object)activityGroupJoinReqDto.getGroupId());
        ActivityGroupDetailEo activityGroupDetailEo = new ActivityGroupDetailEo();
        BeanUtils.copyProperties((Object)activityGroupJoinReqDto, (Object)activityGroupDetailEo);
        activityGroupDetailEo.setStatus(Integer.valueOf(0));
        activityGroupDetailEo.setPayAmount(activityGroupJoinReqDto.getPayAmount());
        this.activityGroupDetailDas.insert((BaseEo)activityGroupDetailEo);
    }

    @Override
    public void join(ActivityGroupJoinReqDto activityGroupJoinReqDto) {
        this.logger.info("\u8ba2\u5355\u53f7{}\u53c2\u4e0e\u6d3b\u52a8{}", (Object)activityGroupJoinReqDto.getOrderNo(), (Object)activityGroupJoinReqDto.getGroupId());
        ActivityGroupDetailEo queryJoin = new ActivityGroupDetailEo();
        queryJoin.setStatus(Integer.valueOf(1));
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"order_no", (Object)activityGroupJoinReqDto.getOrderNo()));
        queryJoin.setSqlFilters(sqlFilters);
        int count = this.activityGroupDetailDas.count((BaseEo)queryJoin);
        this.activityGroupDetailDas.updateSelectiveSqlFilter((BaseEo)queryJoin);
        ActivityGroupEo activityGroupEo = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(Long.valueOf(activityGroupJoinReqDto.getGroupId()));
        if (activityGroupEo.getGroupStatus().equals(3)) {
            this.openingGroup(Long.valueOf(activityGroupJoinReqDto.getGroupId()), activityGroupJoinReqDto.getAddMinutes(), activityGroupJoinReqDto.getTenantId(), activityGroupJoinReqDto.getInstanceId());
        }
        if (activityGroupJoinReqDto.getLimitType().equals(GroupActivityConstant.JOIN_NUM)) {
            try {
                Long remainJoinNum = null;
                if (count > 0) {
                    this.logger.info("\u8ba2\u5355\u53f7{}\u53c2\u4e0e\u6d3b\u52a8{}\u4e0d\u518d\u6263\u51cf\u62fc\u56e2\u4eba\u6570");
                } else {
                    remainJoinNum = this.cacheGroupService.subJoinNum(activityGroupJoinReqDto.getGroupId(), 1L);
                }
                if (remainJoinNum == null) {
                    this.replyGroupJoinCheckAndDo(activityGroupJoinReqDto.getOrderNo(), activityGroupJoinReqDto.getGroupId());
                } else if (remainJoinNum <= 0L) {
                    this.modifyGroupSuccess(Long.valueOf(activityGroupJoinReqDto.getGroupId()));
                }
            }
            catch (Exception e) {
                this.logger.error("\u7f13\u5b58\u6263\u51cf\u5931\u8d25", (Throwable)e);
                this.replyGroupJoinCheckAndDo(activityGroupJoinReqDto.getOrderNo(), activityGroupJoinReqDto.getGroupId());
            }
        } else if (activityGroupJoinReqDto.getLimitType().equals(GroupActivityConstant.JOIN_AMOUNT)) {
            // empty if block
        }
    }

    @Override
    public List<String> queryAllOrderNosByGroupId(Long groupId, String operate) {
        List result;
        ActivityGroupDetailEo activityGroupDetailEo = new ActivityGroupDetailEo();
        activityGroupDetailEo.setGroupId(groupId.toString());
        if ("CONFIRM_DELIVERY".equals(operate)) {
            activityGroupDetailEo.setStatus(Integer.valueOf(1));
        }
        if (CollectionUtils.isNotEmpty((Collection)(result = this.activityGroupDetailDas.select((BaseEo)activityGroupDetailEo)))) {
            return result.stream().map(activityGroupDetail -> activityGroupDetail.getOrderNo()).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public Long add(ActivityGroupAddReqDto activityGroupAddReqDto) {
        ActivityGroupEo activityGroupEo = new ActivityGroupEo();
        BeanUtils.copyProperties((Object)activityGroupAddReqDto, (Object)activityGroupEo);
        activityGroupEo.setOpenTime(new Date());
        activityGroupEo.setCloseTime(DateUtils.addMinutes((Date)new Date(), (int)activityGroupAddReqDto.getAddMinutes()));
        activityGroupEo.setOpenGroupPerson(activityGroupAddReqDto.getOpenGroupPerson());
        activityGroupEo.setGroupStatus(Integer.valueOf(3));
        this.activityGroupDas.insert((BaseEo)activityGroupEo);
        this.cacheGroupService.init(activityGroupEo.getId().toString(), activityGroupAddReqDto.getAddMinutes(), activityGroupAddReqDto.getJoinNum(), activityGroupAddReqDto.getJoinAmount());
        return activityGroupEo.getId();
    }

    @Override
    public PageInfo<ActivityGroupDetailRespDto> queryGroupDetailByPage(ActivityGroupDetailReqDto activityGroupDetailReqDto, Integer pageNum, Integer pageSize) {
        ActivityGroupDetailEo activityGroupDetailEo = ActivityGroupDetailEo.newInstance();
        CubeBeanUtils.copyProperties((Object)activityGroupDetailEo, (Object)activityGroupDetailReqDto, (String[])new String[0]);
        PageInfo pageInfo = this.activityGroupDetailDas.selectPage((BaseEo)activityGroupDetailEo, pageNum, pageSize);
        List<ActivityGroupDetailRespDto> list = BeanCopyUtil.copyCollections(pageInfo.getList(), ActivityGroupDetailRespDto.class, new String[0]);
        pageInfo.setList(list);
        return pageInfo;
    }

    @Override
    public int countGroupDetail(ActivityGroupDetailReqDto activityGroupDetailReqDto) {
        ActivityGroupDetailEo activityGroupDetailEo = ActivityGroupDetailEo.newInstance();
        CubeBeanUtils.copyProperties((Object)activityGroupDetailEo, (Object)activityGroupDetailReqDto, (String[])new String[0]);
        return this.activityGroupDetailDas.count((BaseEo)activityGroupDetailEo);
    }

    @Override
    public int countJoinGroupDetail(ActivityGroupDetailReqDto activityGroupDetailReqDto) {
        ActivityGroupDetailEo activityGroupDetailEo = ActivityGroupDetailEo.newInstance();
        CubeBeanUtils.copyProperties((Object)activityGroupDetailEo, (Object)activityGroupDetailReqDto, (String[])new String[0]);
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(0);
        status.add(1);
        List<SqlFilter> sqlFilters = SqlFilterBuilder.newInstance().buildInSqlFilter("status", status).get();
        activityGroupDetailEo.setSqlFilters(sqlFilters);
        return this.activityGroupDetailDas.count((BaseEo)activityGroupDetailEo);
    }

    @Override
    public void modifyGroupDetailStatus(String orderNo, Integer status) {
        ActivityGroupDetailEo activityGroupDetailEo = ActivityGroupDetailEo.newInstance();
        activityGroupDetailEo.setStatus(status);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"order_no", (Object)orderNo));
        activityGroupDetailEo.setSqlFilters(sqlFilters);
        this.activityGroupDetailDas.updateSelectiveSqlFilter((BaseEo)activityGroupDetailEo);
    }

    @Override
    public List<ActivityGroupEo> queryActivityGroups(Long activityId, Integer groupStatus) {
        ActivityGroupEo activityGroupEo = ActivityGroupEo.newInstance();
        activityGroupEo.setActivityId(activityId);
        activityGroupEo.setGroupStatus(groupStatus);
        List groupEos = this.activityGroupDas.select((BaseEo)activityGroupEo);
        return groupEos;
    }

    @Override
    public List<String> queryOrderNos(List<ActivityGroupEo> groupEos) {
        List groupIds = groupEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        ActivityGroupDetailEo groupDetailEo = ActivityGroupDetailEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"groupId", groupIds));
        groupDetailEo.setSqlFilters((List)sqlFilters);
        List groupDetailEos = this.activityGroupDetailDas.select((BaseEo)groupDetailEo);
        if (CollectionUtils.isEmpty((Collection)groupDetailEos)) {
            return Collections.emptyList();
        }
        List<String> orderNos = groupDetailEos.stream().map(StdActivityGroupDetailEo::getOrderNo).collect(Collectors.toList());
        return orderNos;
    }

    @Override
    public void modifyGroupStatus(List<ActivityGroupEo> groupEos, Integer groupStatus) {
        if (CollectionUtils.isNotEmpty(groupEos)) {
            groupEos.forEach(activityGroupEo -> {
                ActivityGroupEo updateGroupEo = ActivityGroupEo.newInstance();
                updateGroupEo.setId(activityGroupEo.getId());
                updateGroupEo.setGroupStatus(groupStatus);
                this.activityGroupDas.updateSelective((BaseEo)updateGroupEo);
            });
        }
    }

    @Override
    public ActivityGroupRespDto getById(Long id) {
        ActivityGroupRespDto resultDto = null;
        ActivityGroupEo activityGroupEo = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(id);
        if (activityGroupEo != null) {
            resultDto = BeanCopyUtil.copyProperties(ActivityGroupRespDto.class, activityGroupEo, new String[0]);
        }
        return resultDto;
    }

    @Override
    public ActivityGroupRespDto getByOrderNo(String orderNo) {
        ActivityGroupEo activityGroupEo;
        ActivityGroupDetailEo activityGroupDetailEo = ActivityGroupDetailEo.newInstance();
        activityGroupDetailEo.setOrderNo(orderNo);
        List select = this.activityGroupDetailDas.select((BaseEo)activityGroupDetailEo);
        if (CollectionUtils.isNotEmpty((Collection)select) && (activityGroupEo = (ActivityGroupEo)this.activityGroupDas.selectByPrimaryKey(Long.valueOf(((ActivityGroupDetailEo)select.get(0)).getGroupId()))) != null) {
            ActivityGroupRespDto resultDto = BeanCopyUtil.copyProperties(ActivityGroupRespDto.class, activityGroupEo, new String[0]);
            return resultDto;
        }
        return null;
    }
}

