/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.seckill.condition;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinNumService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinNumPerUserCondition
extends ConditionTemplate
implements ILoadConditionTemplate {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICacheService commonCacheService;
    private static final String CONFIG_PARAM_KEY = "JoinNumPerUserCondition.joinActNum";
    @Resource
    private IActivityJoinNumService activityJoinNumService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u6761\u4ef6\u53c2\u6570\u672a\u914d\u7f6e"}));
        }
        boolean validate = params.getExtendsAttribute().getOrDefault("validateJoinNum", true);
        if (!validate) {
            return true;
        }
        Integer limitJoinNum = (Integer)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY), param, define.getLoadClass());
        if (null == limitJoinNum) {
            return true;
        }
        params.getExtendsAttribute().put("activityJoinNumLimit", limitJoinNum);
        Long joinNum = this.activityJoinNumService.getJoinNum(conditionRespDto.getActivityId(), params.getUserId());
        if (joinNum >= (long)limitJoinNum.intValue()) {
            if (ActivityType.EXCHANGE_ACTIVITY.getId() == params.getActivityRespDto().getActivityTemplateId().longValue()) {
                throw new BizException("\u4f60\u5df2\u8d85\u51fa\u672c\u6b21\u6362\u8d2d\u6d3b\u52a8\u7684\u53c2\u4e0e\u6b21\u6570~");
            }
            throw new BizException("\u5df2\u8d85\u51fa\u6d3b\u52a8\u53c2\u4e0e\u6b21\u6570!");
        }
        return true;
    }

    @Override
    public void load(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> activityParams, int expire) {
        Long activityId = conditionRespDto.getActivityId();
        this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u6bcf\u4eba\u53c2\u4e0e\u6b21\u6570\u9650\u5236\u6761\u4ef6\u5f00\u59cb=====", (Object)activityId);
        Param param = define.getParam(CONFIG_PARAM_KEY);
        if (null != param && Objects.nonNull(activityParams.get(CONFIG_PARAM_KEY))) {
            Integer joinActNum = (Integer)ConditionTemplate.converter(activityParams.get(CONFIG_PARAM_KEY), param, define.getLoadClass());
            String activityLimitKey = "activity_limit:" + activityId;
            this.commonCacheService.setCache(activityLimitKey, (Object)joinActNum, expire);
            this.logger.info("\u3010activityId={}\u3011\u6d3b\u52a8\u52a0\u8f7d\u6bcf\u4eba\u53c2\u4e0e\u6b21\u6570\u9650\u5236\u6761\u4ef6\u7ed3\u675f=====", (Object)activityId);
        }
    }
}

