/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.agg.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.Base64;
import com.dtyunxi.yundt.center.message.api.IMessageApi;
import com.dtyunxi.yundt.center.message.api.dto.request.MessageReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.LicenseInfo;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.Merchant;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.MerchantBizScope;
import com.dtyunxi.yundt.cube.center.shop.api.agg.bo.UserConstant;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerBusinessScopeReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerReqDto;
import com.dtyunxi.yundt.cube.center.user.api.IUserApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.RoleDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.vo.UserAccessVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.dtyunxi.yundt.module.context.api.IAppContext;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShopModuleHelper {
    private static final Logger logger = LoggerFactory.getLogger(ShopModuleHelper.class);
    @Resource(name="huieryunCubeContext")
    private IContext context;
    @Autowired
    private IAppContext appContext;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IUserQueryApi userQueryApi;
    @Autowired
    private IMessageApi messageApi;

    public Integer validRoleType() {
        UserAccessVo userAccess = this.appContext.findUserAccess();
        if (userAccess != null && CollectionUtils.isNotEmpty((Collection)userAccess.getRoleSet())) {
            for (RoleDto role : userAccess.getRoleSet()) {
                if ("platMgmt".equals(role.getCode()) || "platMgmtChild".equals(role.getCode())) {
                    return UserConstant.OPERATOR;
                }
                if (!"merchant".equals(role.getCode()) && !"merchantChild".equals(role.getCode())) continue;
                return UserConstant.MERCHANT;
            }
        }
        return UserConstant.CONSUME;
    }

    public UserDto relateAccount(String account, Integer loginNameType) {
        Long tenantId = this.context.tenantId();
        Long instanceId = this.context.instanceId();
        UserDto userDto = (UserDto)this.userQueryApi.queryByLoginNameAndType(account, loginNameType, tenantId, instanceId).getData();
        UserDto userBindDto = new UserDto();
        userBindDto.setTenantId(tenantId);
        UserDto userReqDto = new UserDto();
        userReqDto.setUserName(account);
        if (userDto == null) {
            userReqDto.setRegisterType(Integer.valueOf(4));
            String password = this.getPassword();
            userReqDto.setPassword(Base64.encodeString((String)password));
            userReqDto.setInstanceId(instanceId);
            userReqDto.setTenantId(tenantId);
            userReqDto.setUserType(Integer.valueOf(4));
            RestResponse restResponse = this.userApi.addUser(instanceId, userReqDto);
            if (!"0".equals(restResponse.getResultCode())) {
                throw new BizException(restResponse.getResultCode(), restResponse.getResultMsg());
            }
            Long userId = (Long)restResponse.getData();
            userReqDto.setId(userId);
            userReqDto.setPassword(password);
            userBindDto.setPhone(account);
            this.userApi.updatePasswordPermitted(userId, userBindDto);
        } else {
            Long userId = userDto.getId();
            userReqDto.setId(userId);
            userReqDto.setUserType(Integer.valueOf(2));
            userBindDto.setUserName(account);
            this.userApi.updatePasswordPermitted(userId, userBindDto);
        }
        return userReqDto;
    }

    private String getPassword() {
        StringBuffer sb = new StringBuffer();
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 6; ++i) {
            sb.append(random.nextInt(10));
        }
        return sb.toString();
    }

    public void sendSms(String target, String templateCode, String tplParamCode, String tplParamValue) {
        MessageReqDto messageReqDto = new MessageReqDto();
        messageReqDto.setInstanceId(this.context.instanceId());
        messageReqDto.setTenantId(this.context.tenantId());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(StringUtils.isNotBlank((CharSequence)tplParamValue) ? tplParamCode : "", tplParamValue);
        messageReqDto.setTemplateParam(paramMap);
        messageReqDto.setTemplateCode(templateCode);
        messageReqDto.setContent("");
        messageReqDto.setContentType(Integer.valueOf(0));
        messageReqDto.setMsgType(Integer.valueOf(1));
        messageReqDto.setTargets(target);
        try {
            logger.info("\u53d1\u9001\u77ed\u4fe1\uff0cmessageReqDto:{}", (Object)JSON.toJSONString((Object)messageReqDto));
            this.messageApi.send(messageReqDto);
        }
        catch (InterruptedException e) {
            throw new BizException(e.getMessage());
        }
    }

    public void sendSms(String target, String templateCode, Map<String, Object> paramMap) {
        MessageReqDto messageReqDto = new MessageReqDto();
        messageReqDto.setInstanceId(this.context.instanceId());
        messageReqDto.setTenantId(this.context.tenantId());
        messageReqDto.setTemplateCode(templateCode);
        if (!CollectionUtils.sizeIsEmpty(paramMap)) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                String tplParamCode = entry.getKey();
                String tplParamValue = entry.getValue().toString();
                messageReqDto.getTemplateParam().put(StringUtils.isNotBlank((CharSequence)tplParamValue) ? tplParamCode : "", tplParamValue);
            }
        }
        messageReqDto.setContent("");
        messageReqDto.setContentType(Integer.valueOf(0));
        messageReqDto.setMsgType(Integer.valueOf(1));
        messageReqDto.setTargets(target);
        try {
            this.messageApi.send(messageReqDto);
        }
        catch (InterruptedException e) {
            throw new BizException(e.getMessage());
        }
    }

    public void transMerchantParam(Merchant merchant, Long tenantId, Long instanceId, SellerReqDto sellerReqDto) {
        JSONObject extension = new JSONObject();
        extension.put("email", merchant.getEmail());
        extension.put("website", merchant.getWebsite());
        extension.put("serviceTel", merchant.getServiceTel());
        extension.put("account", merchant.getAccount());
        LicenseInfo licenseInfo = merchant.getLicenseInfo();
        CubeBeanUtils.copyProperties((Object)sellerReqDto, (Object)licenseInfo, (String[])new String[0]);
        extension.put("licenseType", licenseInfo.getLicenseType());
        extension.put("socialCode", licenseInfo.getSocialCode());
        extension.put("tradeTermUp", licenseInfo.getTradeTermUp());
        extension.put("tradeTermEnd", licenseInfo.getTradeTermEnd());
        extension.put("cardType", licenseInfo.getCardType());
        extension.put("cardNo", licenseInfo.getCardNo());
        extension.put("cardPeriodUp", licenseInfo.getCardPeriodUp());
        extension.put("cardPeriodEnd", licenseInfo.getCardPeriodEnd());
        List<SellerBusinessScopeReqDto> sellerBusinessScopeReqDtoList = this.buildSellerBusinessScopeReqDtoList(merchant);
        sellerReqDto.setSellerBusinessScopeReqDtoList(sellerBusinessScopeReqDtoList);
        sellerReqDto.setInstanceId(instanceId);
        sellerReqDto.setTenantId(tenantId);
        sellerReqDto.setExtension(JSON.toJSONString((Object)extension));
    }

    private List<SellerBusinessScopeReqDto> buildSellerBusinessScopeReqDtoList(Merchant merchant) {
        ArrayList<SellerBusinessScopeReqDto> retList = new ArrayList<SellerBusinessScopeReqDto>(10);
        List bizAreaList = merchant.getBizAreaList();
        List bizBrandList = merchant.getBizBrandList();
        List bizCategoryList = merchant.getBizCategoryList();
        this.appendBizScopeList(retList, bizAreaList);
        this.appendBizScopeList(retList, bizBrandList);
        this.appendBizScopeList(retList, bizCategoryList);
        return retList;
    }

    private void appendBizScopeList(List<SellerBusinessScopeReqDto> retList, List<MerchantBizScope> bizScopeList) {
        if (CollectionUtils.isNotEmpty(bizScopeList)) {
            SellerBusinessScopeReqDto target = null;
            for (MerchantBizScope merchantBizScope : bizScopeList) {
                target = new SellerBusinessScopeReqDto();
                CubeBeanUtils.copyProperties((Object)target, (Object)merchantBizScope, (String[])new String[0]);
                target.setTenantId(this.context.tenantId());
                target.setInstanceId(this.context.instanceId());
                retList.add(target);
            }
        }
    }
}

