/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.apiimpl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.biz.member.api.common.dto.loyalty.request.MemberLevelDefineCreateReqDto;
import com.dtyunxi.yundt.cube.center.member.api.common.dto.request.MemberReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.IShopApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.message.ShopChangeMessageDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.AddShopUserReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAreaDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopBusinessScopeDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopEsDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopMemberLevelDefineReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopMemberReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopWarehouseDto;
import com.dtyunxi.yundt.cube.center.shop.biz.mq.producer.ShopChangeProducer;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.impl.MemberModelProxy;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopAreaEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopBusinessScopeEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service(value="shopApi")
public class ShopApiImpl
implements IShopApi {
    @Resource
    private IShopService shopService;
    @Resource
    private MemberModelProxy memberModelProxy;
    @Resource
    private ShopChangeProducer shopChangeProducer;

    public RestResponse<Long> addShop(ShopDto shopDto, boolean needAudit) {
        return new RestResponse((Object)this.shopService.addShop(shopDto, needAudit));
    }

    public RestResponse<Void> addShops(List<ShopReqDto> shopDtos, boolean needAudit) {
        this.shopService.addBatchShop(shopDtos, needAudit);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyShop(ShopDto shopDto, boolean needAudit) {
        this.shopService.modifyShop(shopDto, shopDto.getId(), needAudit);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyShopOnly(Long id, ShopReqDto shopReqDto) {
        this.shopService.modifyShopOnly(id, shopReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeShop(Long id) {
        this.shopService.removeShop(id);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addShopArea(ShopAreaDto shopAreaDto) {
        ShopAreaEo shopAreaEo = (ShopAreaEo)BaseEo.newInstance(ShopAreaEo.class, (Map)shopAreaDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)shopAreaDto, (BaseEo)shopAreaEo);
        return new RestResponse((Object)this.shopService.addShopArea(shopAreaEo));
    }

    public RestResponse<Void> modifyShopArea(ShopAreaDto shopAreaDto) {
        ShopAreaEo shopAreaEo = (ShopAreaEo)BaseEo.newInstance(ShopAreaEo.class);
        DtoHelper.dto2Eo((BaseVo)shopAreaDto, (BaseEo)shopAreaEo);
        this.shopService.modifyShopArea(shopAreaDto.getId(), shopAreaEo);
        ShopChangeMessageDto shopChangeMessageDto = new ShopChangeMessageDto();
        shopChangeMessageDto.setShopId(shopAreaDto.getId().toString());
        shopChangeMessageDto.setTenantId(shopAreaDto.getTenantId());
        shopChangeMessageDto.setInstanceId(shopAreaDto.getInstanceId());
        this.shopChangeProducer.sendShopChangeMessage(shopChangeMessageDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeShopAreaById(Long areaId) {
        this.shopService.removeShopAreaById(areaId);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addShopBusinessScope(ShopBusinessScopeDto shopBusinessScopeDto) {
        ShopBusinessScopeEo shopBusinessScopeEo = (ShopBusinessScopeEo)BaseEo.newInstance(ShopBusinessScopeEo.class, (Map)shopBusinessScopeDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)shopBusinessScopeDto, (BaseEo)shopBusinessScopeEo);
        return new RestResponse((Object)this.shopService.addShopBusinessScope(shopBusinessScopeEo));
    }

    public RestResponse<Void> modifyShopBusinessScope(ShopBusinessScopeDto shopBusinessScopeDto) {
        ShopBusinessScopeEo shopBusinessScopeEo = (ShopBusinessScopeEo)BaseEo.newInstance(ShopBusinessScopeEo.class, (Map)shopBusinessScopeDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)shopBusinessScopeDto, (BaseEo)shopBusinessScopeEo);
        this.shopService.modifyShopBusinessScope(shopBusinessScopeEo, shopBusinessScopeDto.getId());
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeShopBusinessScopeById(Long shopId, Long businessId) {
        this.shopService.removeShopBusinessScopeById(shopId, businessId);
        return RestResponse.VOID;
    }

    public RestResponse<Long> addWarehouse(ShopWarehouseDto shopWarehouseDto) {
        return new RestResponse((Object)0L);
    }

    public RestResponse<Void> removeWarehouse(Long shopId, Long warehouseId) {
        return RestResponse.VOID;
    }

    public RestResponse<Long> addShopUser(AddShopUserReqDto addShopUserReqDto) {
        return new RestResponse((Object)this.shopService.addShopUser(addShopUserReqDto));
    }

    public RestResponse<Void> auditShop(long auditId, long tenantId, String status, String result, String auditPerson) {
        this.shopService.auditShop(auditId, tenantId, status, result, auditPerson);
        return RestResponse.VOID;
    }

    public RestResponse<Boolean> defineShopMemberLevel(long shopId, List<ShopMemberLevelDefineReqDto> dtos) {
        ArrayList<MemberLevelDefineCreateReqDto> list = new ArrayList<MemberLevelDefineCreateReqDto>(dtos.size());
        CubeBeanUtils.copyCollection(list, dtos, MemberLevelDefineCreateReqDto.class);
        this.memberModelProxy.createMemberLevels(shopId, list);
        return new RestResponse((Object)true);
    }

    public RestResponse<Boolean> addShopMember(long shopId, ShopMemberReqDto dto) {
        MemberReqDto reqDto = new MemberReqDto();
        CubeBeanUtils.copyProperties((Object)reqDto, (Object)dto, (String[])new String[0]);
        this.memberModelProxy.addShopMember(shopId, reqDto);
        return new RestResponse((Object)true);
    }

    public RestResponse<Boolean> delShopMember(long shopId, long memberId) {
        this.memberModelProxy.delShopMember(shopId, memberId);
        return new RestResponse((Object)true);
    }

    public RestResponse<Boolean> defineShopLevel(long tenantId, long instanceId, List<ShopMemberLevelDefineReqDto> dtos) {
        ArrayList<MemberLevelDefineCreateReqDto> list = new ArrayList<MemberLevelDefineCreateReqDto>(dtos.size());
        CubeBeanUtils.copyCollection(list, dtos, MemberLevelDefineCreateReqDto.class);
        this.memberModelProxy.createShopLevel(tenantId, instanceId, list);
        return new RestResponse((Object)true);
    }

    public RestResponse<Integer> isCheckAddress(String locationX, String locationY, String shopIds) {
        return new RestResponse((Object)this.shopService.isCheckAddress(locationX, locationY, shopIds));
    }

    public RestResponse<List<ShopEsDto>> queryRangeShopListByGeo(String lat, String lon, Boolean isValidRegion) {
        return new RestResponse(this.shopService.queryRangeShopListByGeo(lat, lon, isValidRegion));
    }

    public RestResponse<Boolean> checkShopName(String shopName) {
        return new RestResponse((Object)this.shopService.checkShopName(shopName));
    }

    public RestResponse<Boolean> checkShopCode(String shopCode) {
        return new RestResponse((Object)this.shopService.checkShopCode(shopCode));
    }

    @CacheEvict(value={"center_shop_shop_detail"}, key="#id")
    public RestResponse<Void> modifyShopById(Long id, ShopReqDto shopReqDto) {
        boolean flag = this.shopService.checkName(id, shopReqDto.getName());
        if (flag) {
            this.shopService.modifyShopOnly(id, shopReqDto);
        }
        return RestResponse.VOID;
    }
}

