/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaTreeRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.constant.RuleAreaType;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.AreaInfo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.CityAreaInfo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.freight.RuleAreaBase;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IFreightRuleAreaService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.FreightRuleAreaDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.FreightRuleAreaEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="freightRuleAreaService")
public class FreightRuleAreaServiceImpl
implements IFreightRuleAreaService {
    @Autowired
    private FreightRuleAreaDas freightRuleAreaDas;
    @Autowired
    private IContext context;

    @Override
    public void add(Long ruleId, String areaCode, RuleAreaType type) {
        if (ruleId != null && type != null) {
            this.delete(ruleId, type);
        }
        if (StringUtils.isBlank((CharSequence)areaCode)) {
            return;
        }
        ArrayList<String> areaCodeList = new ArrayList<String>();
        if (areaCode.contains(",")) {
            String[] codes = areaCode.split(",");
            for (int i = 0; i < codes.length; ++i) {
                if (StringUtils.isBlank((CharSequence)codes[i])) continue;
                areaCodeList.add(codes[i]);
            }
        } else {
            areaCodeList.add(areaCode);
        }
        this.add(ruleId, areaCodeList, type);
    }

    @Override
    public void add(Long ruleId, List<String> areaCodeList, RuleAreaType type) {
        if (areaCodeList == null || areaCodeList.isEmpty()) {
            return;
        }
        if (ruleId == null || ruleId < 0L) {
            return;
        }
        if (type == null) {
            return;
        }
        ArrayList eoList = new ArrayList();
        areaCodeList.forEach(code -> {
            FreightRuleAreaEo eo = this.getEo(ruleId, (String)code, type);
            eoList.add(eo);
        });
        this.freightRuleAreaDas.insertBatch(eoList);
    }

    @Override
    public List<FreightRuleAreaEo> getAreaList(List<Long> ruleIds, RuleAreaType type) {
        FreightRuleAreaEo areaEo = FreightRuleAreaEo.newInstance();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"freightRuleId", ruleIds));
        filters.add(SqlFilter.eq((String)"type", (Object)type.getCode()));
        areaEo.setSqlFilters((List)filters);
        return this.freightRuleAreaDas.select((BaseEo)areaEo);
    }

    private FreightRuleAreaEo getEo(Long ruleId, String areaCode, RuleAreaType type) {
        FreightRuleAreaEo eo = FreightRuleAreaEo.newInstance();
        eo.setAreaCode(areaCode);
        eo.setFreightRuleId(ruleId);
        eo.setType(type.getCode());
        return eo;
    }

    @Override
    public void delete(Long ruleId, RuleAreaType type) {
        FreightRuleAreaEo areaEo = FreightRuleAreaEo.newInstance();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.eq((String)"freightRuleId", (Object)ruleId));
        filters.add(SqlFilter.eq((String)"type", (Object)type.getCode()));
        areaEo.setSqlFilters((List)filters);
        this.freightRuleAreaDas.logicDelete((BaseEo)areaEo);
    }

    @Override
    public void delete(List<Long> ruleIds, RuleAreaType type) {
        FreightRuleAreaEo areaEo = FreightRuleAreaEo.newInstance();
        ArrayList filters = Lists.newArrayList();
        filters.add(SqlFilter.in((String)"freightRuleId", ruleIds));
        filters.add(SqlFilter.eq((String)"type", (Object)type.getCode()));
        areaEo.setSqlFilters((List)filters);
        this.freightRuleAreaDas.logicDelete((BaseEo)areaEo);
    }

    @Override
    public void setAreaMoreInfo(RuleAreaBase respDto, List<AreaTreeRespDto> areaTreeRespDtoList) {
        this.getAreaText(respDto.getAreaCodes(), areaTreeRespDtoList, respDto);
    }

    private void getAreaText(List<String> areaCodeList, List<AreaTreeRespDto> areaTreeRespDtoList, RuleAreaBase respDto) {
        StringBuilder text = new StringBuilder();
        HashMap areaCodeMap = new HashMap();
        areaCodeList.forEach(code -> areaCodeMap.put(code, code));
        ArrayList<String> copyCodeList = new ArrayList<String>();
        copyCodeList.addAll(areaCodeList);
        HashMap baseProvinceMap = new HashMap();
        areaTreeRespDtoList.forEach(areaTreeRespDto -> baseProvinceMap.put(areaTreeRespDto.getCode(), areaTreeRespDto));
        HashMap<String, AreaInfo> provinceMap = new HashMap<String, AreaInfo>();
        ArrayList<AreaInfo> areaInfoList = new ArrayList<AreaInfo>();
        for (int index = 0; index < areaCodeList.size(); ++index) {
            String areaCode = areaCodeList.get(index);
            if (!baseProvinceMap.containsKey(areaCode)) continue;
            AreaInfo areaInfo = new AreaInfo();
            areaInfo.setCode(areaCode);
            areaInfo.setName(((AreaTreeRespDto)baseProvinceMap.get(areaCode)).getName());
            areaInfo.setSubCodeList(new ArrayList());
            provinceMap.put(areaCode, areaInfo);
            areaInfoList.add(areaInfo);
        }
        HashMap cityMap = new HashMap();
        areaTreeRespDtoList.forEach(areaTreeRespDto -> {
            if (areaTreeRespDto.getCode().equals("110000000000") || areaTreeRespDto.getCode().equals("120000000000") || areaTreeRespDto.getCode().equals("310000000000") || areaTreeRespDto.getCode().equals("500000000000")) {
                List childList = areaTreeRespDto.getChildren();
                ArrayList _list = new ArrayList();
                if (childList != null && !childList.isEmpty()) {
                    for (AreaTreeRespDto child2 : childList) {
                        if (child2.getChildren() == null || child2.getChildren().isEmpty()) continue;
                        _list.addAll(child2.getChildren());
                        child2.setChildren(null);
                    }
                }
                if (_list.size() > 0 && childList != null) {
                    childList.addAll(_list);
                }
            }
            if (areaTreeRespDto.getChildren() != null) {
                areaTreeRespDto.getChildren().forEach(child -> {
                    if (areaCodeMap.containsKey(child.getCode())) {
                        AreaInfo areaInfo = null;
                        if (provinceMap.containsKey(areaTreeRespDto.getCode())) {
                            areaInfo = (AreaInfo)provinceMap.get(areaTreeRespDto.getCode());
                        }
                        if (areaInfo == null) {
                            areaInfo = new AreaInfo();
                            areaInfo.setCode(areaTreeRespDto.getCode());
                            areaInfo.setName(areaTreeRespDto.getName());
                            provinceMap.put(areaInfo.getCode(), areaInfo);
                            areaInfoList.add(areaInfo);
                        }
                        CityAreaInfo cityAreaInfo = new CityAreaInfo();
                        cityAreaInfo.setCode(child.getCode());
                        cityAreaInfo.setName(child.getName());
                        areaInfo.getSubCodeList().add(cityAreaInfo);
                        cityMap.put(child.getCode(), child);
                    }
                });
            }
        });
        StringBuilder areaText = new StringBuilder();
        provinceMap.keySet().forEach(code -> {
            AreaInfo areaInfo = (AreaInfo)provinceMap.get(code);
            AreaTreeRespDto areaTreeRespDto = (AreaTreeRespDto)baseProvinceMap.get(code);
            if (areaInfo.getSubCodeList() == null || areaInfo.getSubCodeList().isEmpty()) {
                areaText.append(areaTreeRespDto.getName());
                areaText.append("\u3001");
            } else if (areaInfo.getSubCodeList().size() == areaTreeRespDto.getChildren().size()) {
                areaText.append(areaTreeRespDto.getName());
                areaText.append("\u3001");
            } else {
                areaInfo.getSubCodeList().forEach(subCode -> {
                    if (cityMap.containsKey(subCode.getCode())) {
                        AreaTreeRespDto subArea = (AreaTreeRespDto)cityMap.get(subCode.getCode());
                        areaText.append(subArea.getName());
                        areaText.append("\u3001");
                    }
                });
            }
        });
        respDto.setAreaText(areaText.toString());
        respDto.setAreaInfoList(areaInfoList);
    }
}

