/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.shop.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopAddressReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopAddressRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.exception.ShopExceptionCode;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopAddressService;
import com.dtyunxi.yundt.cube.center.shop.biz.service.IShopCacheService;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopAddressDas;
import com.dtyunxi.yundt.cube.center.shop.dao.das.ShopDas;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopAddressEo;
import com.dtyunxi.yundt.cube.center.shop.dao.eo.ShopEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ShopAddressServiceImpl
implements IShopAddressService {
    @Resource
    private ShopAddressDas shopAddressDas;
    @Resource
    private ShopDas shopDas;
    @Resource
    private IShopCacheService shopCacheService;

    @Override
    public Long addShopAddress(ShopAddressReqDto shopAddressReqDto) {
        if (this.shopDas.selectByPrimaryKey(shopAddressReqDto.getShopId()) == null) {
            throw new BizException(ShopExceptionCode.EMPTY_PARAM_ERROR.getCode(), ShopExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "shopId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ShopAddressEo shopAddressEo = ShopAddressEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopAddressReqDto, (BaseEo)shopAddressEo);
        if (shopAddressReqDto.getStatus().equals("default")) {
            this.updateNotDefault(shopAddressEo, "add");
        }
        shopAddressEo.setId(null);
        this.shopAddressDas.insert((BaseEo)shopAddressEo);
        this.shopCacheService.removeByShopId(shopAddressReqDto.getShopId());
        return shopAddressEo.getId();
    }

    @Override
    public void modifyShopAddress(ShopAddressReqDto shopAddressReqDto) {
        if (shopAddressReqDto.getId() == null || shopAddressReqDto.getInstanceId() == null || shopAddressReqDto.getTenantId() == null) {
            throw new BizException(ShopExceptionCode.EMPTY_PARAM_ERROR.getCode(), ShopExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        ShopAddressEo shopAddressEo = (ShopAddressEo)this.shopAddressDas.selectByPrimaryKey(shopAddressReqDto.getId());
        if (shopAddressEo == null) {
            throw new BizException(ShopExceptionCode.EMPTY_PARAM_ERROR.getCode(), ShopExceptionCode.EMPTY_PARAM_ERROR.getMsg() + "shopAddressId\u5bf9\u5e94\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        ShopAddressEo updateEo = ShopAddressEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopAddressReqDto, (BaseEo)updateEo);
        if (shopAddressReqDto.getStatus().equals("default")) {
            this.updateNotDefault(updateEo, "modify");
            if (shopAddressReqDto.getType().equals("shop")) {
                ShopEo shopEo = ShopEo.newInstance();
                shopEo.setAddress(shopAddressReqDto.getAddress());
                shopEo.setCountyCode(shopAddressReqDto.getCountyCode());
                shopEo.setCityCode(shopAddressReqDto.getCityCode());
                shopEo.setGeo(shopAddressReqDto.getGeo());
                shopEo.setProvinceCode(shopAddressReqDto.getProvinceCode());
                shopEo.setStreetCode(shopAddressReqDto.getStreetCode());
                shopEo.setId(shopAddressReqDto.getShopId());
                this.shopDas.updateSelective((BaseEo)shopEo);
            }
        }
        this.shopAddressDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void removeShopAddress(Long id) {
        this.shopAddressDas.logicDeleteById(id);
    }

    @Override
    public ShopAddressRespDto queryAddressById(Long id) {
        ShopAddressEo shopAddressEo = (ShopAddressEo)this.shopAddressDas.selectByPrimaryKey(id);
        ShopAddressRespDto shopAddressRespDto = new ShopAddressRespDto();
        DtoHelper.eo2Dto((BaseEo)shopAddressEo, (BaseVo)shopAddressRespDto);
        return shopAddressRespDto;
    }

    @Override
    public PageInfo<ShopAddressRespDto> queryAddressByPage(ShopAddressReqDto shopAddressReqDto, Integer pageNum, Integer pageSize) {
        ShopAddressEo shopAddressEo = ShopAddressEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shopAddressReqDto, (BaseEo)shopAddressEo);
        PageInfo shopAddressEoPageInfo = this.shopAddressDas.selectPage((BaseEo)shopAddressEo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        PageInfo pageInfo = new PageInfo((List)list);
        DtoHelper.eoList2DtoList((Collection)shopAddressEoPageInfo.getList(), (Collection)list, ShopAddressRespDto.class);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)shopAddressEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        pageInfo.setList((List)list);
        return pageInfo;
    }

    @Override
    public List<ShopAddressRespDto> queryAddressByShopId(Long shopId) {
        ShopAddressEo shopAddressEo = ShopAddressEo.newInstance();
        shopAddressEo.setShopId(shopId);
        List shopAddressEos = this.shopAddressDas.select((BaseEo)shopAddressEo);
        ArrayList<ShopAddressRespDto> shopAddressRespDtos = new ArrayList<ShopAddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)shopAddressEos, shopAddressRespDtos, ShopAddressRespDto.class);
        return shopAddressRespDtos;
    }

    private void updateNotDefault(ShopAddressEo shopAddressEo, String operationType) {
        ShopAddressEo query = ShopAddressEo.newInstance();
        query.setShopId(shopAddressEo.getShopId());
        query.setType(shopAddressEo.getType());
        query.setStatus("default");
        query.setInstanceId(shopAddressEo.getInstanceId());
        query.setTenantId(shopAddressEo.getTenantId());
        if (this.shopAddressDas.count((BaseEo)query) == 1) {
            ShopAddressEo eo = (ShopAddressEo)this.shopAddressDas.selectOne((BaseEo)query);
            if (operationType.equals("add")) {
                eo.setStatus("notDefault");
                this.shopAddressDas.updateSelective((BaseEo)eo);
            }
            if (operationType.equals("modify") && !eo.getId().equals(shopAddressEo.getId())) {
                eo.setStatus("notDefault");
                this.shopAddressDas.updateSelective((BaseEo)eo);
            }
        }
    }
}

