/**
 * @(#)IDistributionQueryApi.java 1.0 2020/11/25
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.item.api.distribution.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DistributionSetReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DistributionSetRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

@Api(tags = {"商品中心：商品分销服务"})
@FeignClient(name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        contextId = "com-dtyunxi-yundt-cube-center-item-api-distribution-query-IDistributionQueryApi",
        path = "/v1/distribution",
        url = "${yundt.cube.center.item.api:}")
public interface IDistributionQueryApi {

    /**
     * 查询商品分销配置列表
     *
     * @param distributionSetReqDto
     * @return
     */
    @GetMapping(value = "/set/list")
    @ApiOperation(value = "查询商品分销配置列表")
    RestResponse<List<DistributionSetRespDto>> queryList(DistributionSetReqDto distributionSetReqDto);
}
