/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.lang.Assert;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AddressTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IAddressService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.AddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AddressServiceImpl
implements IAddressService {
    @Resource
    private AddressDas addressDas;
    @Resource
    private ICustomerExtService customerExtService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addAddress(AddressAddReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)addressEo);
        addressEo.setEndTime(reqDto.getEndTime());
        this.addressDas.insert((BaseEo)addressEo);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.addressDas.updateStatusByOrgInfoId(addressEo.getOrgInfoId(), addressEo.getAddressType(), addressEo.getId());
        }
        return addressEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyAddress(AddressModifyReqDto reqDto) {
        Assert.notNull((Object)reqDto.getOrgInfoId(), (String)"\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AddressEo addressEo = (AddressEo)((ExtQueryChainWrapper)this.addressDas.filter().eq((Object)"id", (Object)reqDto.getId())).one();
        AddressEo update = (AddressEo)BeanUtil.copyProperties((Object)addressEo, AddressEo.class, (String[])new String[0]);
        BeanUtil.copyProperties((Object)reqDto, (Object)update, (CopyOptions)CopyOptions.create().ignoreNullValue());
        update.setEndTime(reqDto.getEndTime());
        this.addressDas.update((BaseEo)update);
        if (null != reqDto.getStatus() && reqDto.getStatus() == 1) {
            this.addressDas.updateStatusByOrgInfoId(update.getOrgInfoId(), update.getAddressType(), update.getId());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAddress(Long id) {
        this.addressDas.deleteById(id);
    }

    @Override
    public AddressRespDto queryAddressById(Long id) {
        AddressEo addressEo = (AddressEo)this.addressDas.selectByPrimaryKey(id);
        if (addressEo == null) {
            return null;
        }
        AddressRespDto addressRespDto = new AddressRespDto();
        DtoHelper.eo2Dto((BaseEo)addressEo, (BaseVo)addressRespDto);
        return addressRespDto;
    }

    @Override
    public PageInfo<AddressRespDto> queryAddressByPage(AddressQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        AddressEo addressEo = new AddressEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)addressEo);
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isEmpty((CharSequence)addressEo.getAddressType())) {
            sqlFilters.add(SqlFilter.in((String)"address_type", (Object)Lists.newArrayList((Object[])new String[]{AddressTypeEnum.DELIVERY.getCode(), AddressTypeEnum.INVOICE.getCode()})));
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgInfoIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_info_id", (Object)reqDto.getOrgInfoIds()));
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            // empty if block
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getOrgInfoIds())) {
            sqlFilters.add(SqlFilter.in((String)"org_info_id", (Object)reqDto.getOrgInfoIds()));
        }
        if (CollectionUtils.isNotEmpty(sqlFilters)) {
            addressEo.setSqlFilters(sqlFilters);
        }
        addressEo.addSqlOrderBy("status", SortOrder.DESC);
        addressEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo eoPageInfo = this.addressDas.selectPage((BaseEo)addressEo, pageNum, pageSize);
        if (reqDto.isFilterTime()) {
            eoPageInfo.setList(eoPageInfo.getList().stream().filter(r -> !(!Objects.isNull(r.getStartTime()) && r.getStartTime().compareTo(new Date()) > 0 || !Objects.isNull(r.getEndTime()) && r.getEndTime().compareTo(new Date()) < 0)).collect(Collectors.toList()));
        }
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AddressRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<AddressRespDto> queryAddressListByOrgInfoId(Long orgInfoId) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public List<AddressRespDto> queryAddressListByOrgInfoIdAndType(Long orgInfoId, List<String> addressTypes) {
        AddressEo addressEo = new AddressEo();
        addressEo.setOrgInfoId(orgInfoId);
        if (CollectionUtils.isNotEmpty(addressTypes)) {
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"address_type", addressTypes));
            addressEo.setSqlFilters(sqlFilters);
        }
        List addressEoList = this.addressDas.select((BaseEo)addressEo);
        ArrayList<AddressRespDto> addressDtoList = new ArrayList<AddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEoList, addressDtoList, AddressRespDto.class);
        return addressDtoList;
    }

    @Override
    public void removeAddressByOrgInfoIdAndType(Long orgInfoId, String addressType) {
        this.addressDas.getMapper().delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_info_id", (Object)orgInfoId)).eq((Object)"address_type", (Object)addressType));
    }
}

