/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.util;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.ReflectionUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class AssertUtil {
    public static void isTrue(boolean expression, @NonNull String message) {
        AssertUtil.isTrue(expression, "3000", message);
    }

    public static void isTrue(boolean expression, @NonNull String message, @NonNull Consumer consumer) {
        if (!expression) {
            consumer.accept(message);
            throw new BizException(message);
        }
    }

    public static void isFalse(boolean expression, @NonNull String message) {
        AssertUtil.isTrue(!expression, "3000", message);
    }

    public static void isTrue(boolean expression, @NonNull String code, @NonNull String message) {
        if (!expression) {
            throw new BizException(code, message);
        }
    }

    public static <E extends BaseEo> void assertEoByPrimaryId(E eo) {
        AssertUtil.assertEoByPrimaryId(eo, "\u8be5id\u627e\u4e0d\u5230\u6570\u636e");
    }

    public static <E extends BaseEo> void assertEoByPrimaryId(E eo, String message) {
        AssertUtil.isFalse(null == eo || null == eo.getId(), message);
    }

    public static void emptyValidated(@NonNull Object obj, String ... fields) {
        Optional.of(obj).orElseThrow(() -> new NullPointerException("check object is null"));
        Optional.of(fields).orElseThrow(() -> new NullPointerException("check field is null"));
        Stream.of(fields).forEach(x -> {
            boolean expression;
            Object fieldValue = ReflectionUtils.getFieldValue((Object)obj, (String)x);
            boolean bl = expression = fieldValue != null;
            if (expression) {
                if (fieldValue instanceof String) {
                    expression = StringUtils.isNotBlank((CharSequence)((String)fieldValue));
                } else if (fieldValue instanceof Short) {
                    expression = (Short)fieldValue > 0;
                } else if (fieldValue instanceof Integer) {
                    expression = (Integer)fieldValue > 0;
                } else if (fieldValue instanceof Long) {
                    expression = (Long)fieldValue > 0L;
                } else if (fieldValue instanceof Float) {
                    expression = ((Float)fieldValue).floatValue() > 0.0f;
                } else if (fieldValue instanceof Double) {
                    expression = (Double)fieldValue > 0.0;
                } else if (fieldValue instanceof BigDecimal) {
                    expression = ((BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) > 0;
                } else if (fieldValue instanceof Collection) {
                    expression = !CollectionUtils.isEmpty((Collection)((Collection)fieldValue));
                } else if (fieldValue instanceof Map) {
                    expression = !CollectionUtils.isEmpty((Map)((Map)fieldValue));
                }
            }
            AssertUtil.isTrue(expression, "2000", x + " valid not pass");
        });
    }

    public static void assertNotBlank(@Nullable String s, @NonNull String errorMessage) {
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)s), errorMessage);
    }

    public static void assertMaxLength(@Nullable String s, int maxLength, @NonNull String errorMessage) {
        AssertUtil.isFalse(StringUtils.isBlank((CharSequence)s) || s.length() > maxLength, errorMessage);
    }

    @CheckReturnValue
    public static <N extends Number> Integer compareZero(@NonNull N n) {
        Objects.requireNonNull(n, "assertion number is null");
        double v = n.doubleValue();
        return v * 1.0 / 0.0 - 0.0 > 0.0 ? 1 : (v * -1.0 / 0.0 - 0.0 > 0.0 ? -1 : 0);
    }

    public static void assertNotNull(@Nullable Object o, @NonNull String errorMessage) {
        AssertUtil.isFalse(o == null, errorMessage);
    }

    public static void assertNotEmpty(@Nullable Collection<?> collection, @NonNull String errorMessage) {
        AssertUtil.isFalse(CollectionUtils.isEmpty(collection), errorMessage);
    }

    public static void assertNotEmpty(@NonNull Map<?, ?> map, @NonNull String errorMessage) {
        AssertUtil.isTrue(MapUtils.isNotEmpty(map), errorMessage);
    }

    public static void assertNotEmpty(@Nullable Object[] array, @NonNull String errorMessage) {
        AssertUtil.isFalse(ObjectUtils.isEmpty((Object[])array), errorMessage);
    }

    public static boolean assertEmpty(@NonNull Object obj, String ... fields) {
        try {
            AssertUtil.emptyValidated(obj, fields);
            return true;
        }
        catch (Exception var3) {
            return false;
        }
    }

    @SafeVarargs
    public static <O> void isNotAllNull(@NonNull String message, O ... o) {
        Objects.requireNonNull(o);
        boolean empty = CollectionUtils.isEmpty((Collection)Stream.of(o).filter(Objects::nonNull).collect(Collectors.toList()));
        if (empty) {
            throw new NullPointerException(message);
        }
    }

    static interface ExceptionCode {
        public static final String INVALID_PARAM = "2000";
        public static final String ASSERT_NOT = "3000";
        public static final String INVALID_MESSAGE = " valid not pass";
    }
}

