/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.api.dto.response;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.price.api.constants.DiscountTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;

@ApiModel(value="CalcPriceDescriptionRespDto", description="\u8ba1\u7b97\u4ef7\u683c\u63cf\u8ff0")
public class CalcPriceDescriptionRespDto {
    @ApiModelProperty(value="\u8ba1\u7b97\u516c\u5f0f")
    private String calculateFormula;
    @ApiModelProperty(value="\u8ba1\u7b97\u516c\u5f0f\u63cf\u8ff0")
    private String calculateFormulaDesc;

    public static CalcPriceDescriptionRespDto build(BigDecimal discountBasePrice, BigDecimal discountRate, BigDecimal addPrice, PriceTypeEnum priceTypeEnum) {
        CalcPriceDescriptionRespDto calcPriceDescriptionRespDto = new CalcPriceDescriptionRespDto();
        calcPriceDescriptionRespDto.setCalculateFormulaDesc(DiscountTypeEnum.FIXED_DISCOUNT.converCalculationFormula(priceTypeEnum != null ? priceTypeEnum.getDesc() : ""));
        calcPriceDescriptionRespDto.setCalculateFormula(CalcPriceDescriptionRespDto.convertFormulaStr(DiscountTypeEnum.FIXED_DISCOUNT, discountBasePrice, null, discountRate, addPrice));
        return calcPriceDescriptionRespDto;
    }

    public static CalcPriceDescriptionRespDto build(BigDecimal discountBasePrice, BigDecimal baseDiscountRate, BigDecimal discountRate, BigDecimal addPrice, PriceTypeEnum priceTypeEnum) {
        CalcPriceDescriptionRespDto calcPriceDescriptionRespDto = new CalcPriceDescriptionRespDto();
        calcPriceDescriptionRespDto.setCalculateFormulaDesc(DiscountTypeEnum.TEMPORARY_DISCOUNT.converCalculationFormula(priceTypeEnum != null ? priceTypeEnum.getDesc() : ""));
        calcPriceDescriptionRespDto.setCalculateFormula(CalcPriceDescriptionRespDto.convertFormulaStr(DiscountTypeEnum.TEMPORARY_DISCOUNT, discountBasePrice, baseDiscountRate, discountRate, addPrice));
        return calcPriceDescriptionRespDto;
    }

    private static String convertFormulaStr(DiscountTypeEnum discountTypeEnum, BigDecimal discountBasePrice, BigDecimal baseDiscountRate, BigDecimal discountRate, BigDecimal addPrice) {
        if (discountBasePrice == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(discountBasePrice).append("*");
        if (DiscountTypeEnum.FIXED_DISCOUNT.getType().equals(discountTypeEnum.getType())) {
            sb.append(discountRate).append("%").append("+").append(addPrice);
        } else {
            sb.append("(").append(baseDiscountRate).append("%").append("+").append(discountRate).append("%").append(")").append("+").append(addPrice);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString((Object)CalcPriceDescriptionRespDto.build(BigDecimal.TEN, BigDecimal.ONE, new BigDecimal("10"), PriceTypeEnum.DEALER_RETAIL_PRICE)));
        System.out.println(JSON.toJSONString((Object)CalcPriceDescriptionRespDto.build(BigDecimal.TEN, BigDecimal.ONE, BigDecimal.ONE, new BigDecimal("10"), PriceTypeEnum.RETAIL_PRICE)));
    }

    public String getCalculateFormula() {
        return this.calculateFormula;
    }

    public String getCalculateFormulaDesc() {
        return this.calculateFormulaDesc;
    }

    public void setCalculateFormula(String calculateFormula) {
        this.calculateFormula = calculateFormula;
    }

    public void setCalculateFormulaDesc(String calculateFormulaDesc) {
        this.calculateFormulaDesc = calculateFormulaDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalcPriceDescriptionRespDto)) {
            return false;
        }
        CalcPriceDescriptionRespDto other = (CalcPriceDescriptionRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$calculateFormula = this.getCalculateFormula();
        String other$calculateFormula = other.getCalculateFormula();
        if (this$calculateFormula == null ? other$calculateFormula != null : !this$calculateFormula.equals(other$calculateFormula)) {
            return false;
        }
        String this$calculateFormulaDesc = this.getCalculateFormulaDesc();
        String other$calculateFormulaDesc = other.getCalculateFormulaDesc();
        return !(this$calculateFormulaDesc == null ? other$calculateFormulaDesc != null : !this$calculateFormulaDesc.equals(other$calculateFormulaDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalcPriceDescriptionRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $calculateFormula = this.getCalculateFormula();
        result = result * 59 + ($calculateFormula == null ? 43 : $calculateFormula.hashCode());
        String $calculateFormulaDesc = this.getCalculateFormulaDesc();
        result = result * 59 + ($calculateFormulaDesc == null ? 43 : $calculateFormulaDesc.hashCode());
        return result;
    }

    public String toString() {
        return "CalcPriceDescriptionRespDto(calculateFormula=" + this.getCalculateFormula() + ", calculateFormulaDesc=" + this.getCalculateFormulaDesc() + ")";
    }
}

