/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CommonHelper {
    private static final Logger log = LoggerFactory.getLogger(CommonHelper.class);
    @Resource
    private ICacheService cacheService;

    public <R> R lock(String key, int seconds, Function<String, R> function) {
        R r;
        if (!this.cacheService.add(key, (Object)key, seconds)) {
            log.warn("[\u5206\u5e03\u5f0f\u9501] >>> \u952e\u503c[{}]\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\u4e86\uff0c\u8bf7\u91cd\u8bd5", (Object)key);
            return null;
        }
        TimeInterval timer = DateUtil.timer();
        try {
            r = function.apply(key);
        }
        catch (Exception e) {
            try {
                log.error("\u6267\u884c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                log.info("[\u5206\u5e03\u5f0f\u9501] >>> \u952e\u503c[{}]\u91ca\u653e\u9501\u5206\u5e03[{}]\uff0c\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{key, this.cacheService.delCache(key), timer.intervalMs()});
                throw throwable;
            }
        }
        log.info("[\u5206\u5e03\u5f0f\u9501] >>> \u952e\u503c[{}]\u91ca\u653e\u9501\u5206\u5e03[{}]\uff0c\u8017\u65f6[{}]\u6beb\u79d2", new Object[]{key, this.cacheService.delCache(key), timer.intervalMs()});
        return r;
    }

    public void lock(String key, int seconds, Consumer<String> function) {
        this.lock(key, seconds, (String s) -> {
            function.accept((String)s);
            return null;
        });
    }
}

