/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="PRICE_MODIFY_TAG")
public class PriceModifyProcessor
implements IMessageProcessor<MessageVo> {
    private static Logger logger = LoggerFactory.getLogger(PriceModifyProcessor.class);
    private static Set<String> SUPPORT_PRICE_STATUS = Sets.newHashSet();
    @Autowired
    private PriceDas priceDas;
    @Resource
    private IPricePolicyEsService pricePolicyEsService;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message));
        Long id = (Long)message.getData();
        PriceEo priceEo = (PriceEo)this.priceDas.selectByPrimaryKey(id);
        try {
            if (priceEo == null) {
                logger.info("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f],\u4ef7\u683c\u653f\u7b56\u4e0d\u5b58\u5728\uff0c\u653f\u7b56id\uff1a{}", (Object)id);
                return MessageResponse.SUCCESS;
            }
            String status = PriceStatusUtils.convertStatus(priceEo.getStatus(), priceEo.getEffectiveTime(), priceEo.getInvalidTime());
            if (!SUPPORT_PRICE_STATUS.contains(status)) {
                logger.info("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f],\u5f53\u524d\u653f\u7b56\u72b6\u6001\u4e0d\u5904\u7406\uff0c\u72b6\u6001\uff1a{}\uff0c\u653f\u7b56id\uff1a{}", (Object)status, (Object)id);
                return MessageResponse.SUCCESS;
            }
            logger.info("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f]\uff0c\u5220\u9664es\u6570\u636e\u91cd\u65b0\u540c\u6b65,\u4ef7\u683c\u653f\u7b56Id:{}", (Object)id);
            this.pricePolicyEsService.deletePricePolicy(id);
            logger.info("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f],\u91cd\u65b0\u540c\u6b65\u4ef7\u683c\u653f\u7b56\uff0c\u5199\u5165es\uff0c\u4ef7\u683c\u653f\u7b56Id:{}", (Object)id);
            this.pricePolicyEsService.updatePricePolicy(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("[\u4fee\u6539\u4ef7\u683c\u653f\u7b56mq\u6d88\u606f],\u62a5\u9519\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }

    static {
        SUPPORT_PRICE_STATUS.add(PriceStatusEnum.EFFECT.getCode());
    }
}

