/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.DiscountPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalDiscountQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuDiscountRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IDiscountService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IDiscountPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.DiscountItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.DiscountItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="discountPolicyEsService")
public class DiscountPolicyEsServiceImpl
implements IDiscountPolicyEsService {
    private static final Logger logger = LoggerFactory.getLogger(DiscountPolicyEsServiceImpl.class);
    @Autowired
    private ISearchIndexService searchIndexService;
    @Autowired
    private IOpenSearchService openSearchService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_PREFIX;
    @Autowired
    private IContext iContext;
    @Autowired
    private IDiscountService discountService;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private DiscountDas discountDas;
    @Resource
    private CustomerConditionDas customerConditionDas;
    @Resource
    private DiscountItemDas discountItemDas;
    private static String POLICY_INDEX_NAME = "price_discount_policy";
    private static String POLICY_TYPE_NAME = "discount_policy";

    @Override
    public void createPricePolicy(Long policyId) {
        DiscountEo discountEo = (DiscountEo)this.discountDas.selectByPrimaryKey(policyId);
        DiscountPolicyEsDto policyEsDto = new DiscountPolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, discountEo);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void updatePricePolicy(Long policyId) {
        DiscountEo discountEo = (DiscountEo)this.discountDas.selectByPrimaryKey(policyId);
        DiscountPolicyEsDto policyEsDto = new DiscountPolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, discountEo);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.updateData(documentVo);
        logger.info("\u4fdd\u5b58\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void deletePricePolicy(Long policyId) {
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(policyId.toString());
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.deleteData(documentVo);
        logger.info("\u5220\u9664\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public DiscountPolicyEsDto queryByIndexId(Long policyId) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName(POLICY_INDEX_NAME + this.globalProfile);
        osSearchVo.setTypeName(POLICY_TYPE_NAME);
        osSearchVo.addEqualFilter("id", String.valueOf(policyId));
        SearchResultVo searchResultVo = this.openSearchService.search(osSearchVo);
        if (searchResultVo != null) {
            List tagDtos = searchResultVo.getDocValues().stream().map(doc -> {
                DiscountPolicyEsDto policyEsDto = (DiscountPolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), DiscountPolicyEsDto.class);
                return policyEsDto;
            }).collect(Collectors.toList());
            return (DiscountPolicyEsDto)tagDtos.get(0);
        }
        return null;
    }

    @Override
    public List<ItemSkuDiscountRespDto> queryByCondition(CommunalDiscountQueryReqDto discountQueryReqDto) {
        try {
            OSSearchVo osSearchVo = new OSSearchVo();
            osSearchVo.setIndexName(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME);
            osSearchVo.setTypeName(POLICY_TYPE_NAME);
            osSearchVo.addRangeFilter("effectTime", null, com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)discountQueryReqDto.getPolicyDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            osSearchVo.addRangeFilter("failureTime", com.dtyunxi.cube.utils.DateUtil.getDateFormat((Date)discountQueryReqDto.getPolicyDate(), (String)"yyyy-MM-dd HH:mm:ss"), null);
            osSearchVo.addEqualFilter("status", "AUDIT_PASS");
            List skuIds = discountQueryReqDto.getSkuIds();
            FilterFieldVo customerCompFilter = this.buildCustCompFitler(osSearchVo, discountQueryReqDto.getCustId());
            osSearchVo.addFilters(new FilterFieldVo[]{customerCompFilter});
            if (skuIds != null && !skuIds.isEmpty()) {
                osSearchVo.addInFilter("itemList.skuId", skuIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]));
            }
            int page = 1;
            ArrayList<ItemSkuDiscountRespDto> skuResults = new ArrayList<ItemSkuDiscountRespDto>();
            ArrayList discountEsDtos = new ArrayList();
            SearchResultVo searchResultVo = null;
            osSearchVo.setPageSize(200);
            osSearchVo.setPage(page);
            do {
                if ((searchResultVo = this.openSearchService.search(osSearchVo)) == null) continue;
                List pageEsDtos = searchResultVo.getDocValues().stream().map(doc -> {
                    DiscountPolicyEsDto policyEsDto = (DiscountPolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), DiscountPolicyEsDto.class);
                    return policyEsDto;
                }).collect(Collectors.toList());
                discountEsDtos.addAll(pageEsDtos);
                osSearchVo.setPage(++page);
                if (searchResultVo.getDocValues().size() < osSearchVo.getPageSize()) break;
            } while (searchResultVo != null && !CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()));
            ArrayList esDocSkuList = new ArrayList();
            discountEsDtos.forEach(esDto -> esDto.getItemList().forEach(e -> {
                ItemSkuDiscountRespDto skuDiscountDto = new ItemSkuDiscountRespDto();
                CubeBeanUtils.copyProperties((Object)skuDiscountDto, (Object)e, (String[])new String[0]);
                CubeBeanUtils.copyProperties((Object)skuDiscountDto, (Object)esDto, (String[])new String[0]);
                boolean skuIdContain = true;
                if (skuIds != null && !skuIds.isEmpty()) {
                    skuIdContain = skuIds.contains(skuDiscountDto.getSkuId());
                }
                if (skuIdContain) {
                    esDocSkuList.add(skuDiscountDto);
                }
            }));
            Map<Long, List<ItemSkuDiscountRespDto>> groupBySku = esDocSkuList.stream().collect(Collectors.groupingBy(ItemSkuDiscountRespDto::getSkuId));
            for (Long skuKey : groupBySku.keySet()) {
                List<ItemSkuDiscountRespDto> skuDiscounts = groupBySku.get(skuKey);
                if (skuDiscounts.size() > 1) {
                    skuDiscounts.sort(new Comparator<ItemSkuDiscountRespDto>(){

                        @Override
                        public int compare(ItemSkuDiscountRespDto o1, ItemSkuDiscountRespDto o2) {
                            return 0 - o1.getEffectiveTime().compareTo(o2.getEffectiveTime());
                        }
                    });
                }
                skuResults.add(skuDiscounts.get(0));
            }
            logger.info("\u67e5\u8be2\u5546\u54c1\u7684\u6298\u6263 ={}", (Object)skuResults.size());
            return skuResults;
        }
        catch (Exception e) {
            logger.error("es\u67e5\u8be2\u9519\u8bef\uff1a={}", (Object)e.getMessage());
            return null;
        }
    }

    private FilterFieldVo buildCustCompFitler(OSSearchVo osSearchVo, Long custId) {
        FilterFieldVo customerCompFilter1 = osSearchVo.createCompoundFilter(LogicalSymbol.AND);
        FilterFieldVo specialCustomerFilter = FilterFieldVo.equal((String)"relationCustomerType", (String)String.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        FilterFieldVo custFilter = FilterFieldVo.equal((String)"customerIds", (String)String.valueOf(custId));
        customerCompFilter1.addSubFilterFieldVos(new FilterFieldVo[]{specialCustomerFilter, custFilter});
        return customerCompFilter1;
    }

    private void convert2PolicyEsDto(DiscountPolicyEsDto policyEsDto, DiscountEo discountEo) {
        String itemBrandIds;
        String itemTypeIds;
        List itemEoList;
        CustomerConditionEo customerConditionEo;
        policyEsDto.setPolicyId(discountEo.getId());
        CubeBeanUtils.copyProperties((Object)policyEsDto, (Object)discountEo, (String[])new String[0]);
        if (ObjectUtil.isNull((Object)discountEo.getInvalidTime())) {
            policyEsDto.setInvalidTime(DateUtil.setDateEnd(DateUtil.getDateAfter(new Date(), 18250)));
        }
        if (!StringUtils.isEmpty((Object)(customerConditionEo = this.customerConditionDas.findDiscountTypeByRelateId(discountEo.getId())).getCustomerIds())) {
            policyEsDto.setCustomerIds(Arrays.asList(customerConditionEo.getCustomerIds().split(",")));
        }
        if (!StringUtils.isEmpty((Object)customerConditionEo.getCustomerGroupIds())) {
            policyEsDto.setCustomerGroupIds(Arrays.asList(customerConditionEo.getCustomerGroupIds().split(",")));
        }
        if (!StringUtils.isEmpty((Object)customerConditionEo.getCustomerTypeIds())) {
            policyEsDto.setCustomerTypeIds(Arrays.asList(customerConditionEo.getCustomerTypeIds().split(",")));
        }
        if (!StringUtils.isEmpty((Object)customerConditionEo.getCustomerAreaCodes())) {
            policyEsDto.setCustomerAreaCodes(Arrays.asList(customerConditionEo.getCustomerAreaCodes().split(",")));
        }
        if (CollectionUtil.isNotEmpty((Collection)(itemEoList = this.discountItemDas.selectDiscountId(discountEo.getId())))) {
            ArrayList<DiscountPolicyEsDto.Item> items = new ArrayList<DiscountPolicyEsDto.Item>(itemEoList.size());
            for (DiscountItemEo itemEo : itemEoList) {
                DiscountPolicyEsDto.Item item = new DiscountPolicyEsDto.Item();
                item.setItemId(itemEo.getItemId());
                item.setSkuId(itemEo.getSkuId());
                items.add(item);
            }
            policyEsDto.setItemList(items);
        }
        if (!StringUtils.isEmpty((Object)(itemTypeIds = discountEo.getItemTypeIds()))) {
            ArrayList<Long> itemTypes = new ArrayList<Long>();
            for (DiscountItemEo itemTypeId : itemTypeIds.split(",")) {
                itemTypes.add(Long.valueOf((String)itemTypeId));
            }
            policyEsDto.setItemTypeIds(itemTypes);
        }
        if (!StringUtils.isEmpty((Object)(itemBrandIds = discountEo.getItemBrandIds()))) {
            ArrayList<Long> itemBrands = new ArrayList<Long>();
            for (String itemBrandId : itemBrandIds.split(",")) {
                itemBrands.add(Long.valueOf(itemBrandId));
            }
            policyEsDto.setItemGroupIds(itemBrands);
        }
    }
}

