/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.es.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchConditionVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchIndexDocVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.SubTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.DiscountTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceModelSetTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceAndNumLimitDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PricePolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CalcPriceDescriptionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemPolicyPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBrandRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceModelRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceTypeRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceModelService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceTypeService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPricePolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.impl.EsNativeApiService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.DateUtil;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcReqVo;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPolicyPriceCalcRespVo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceTypeEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PricePolicyEsServiceImpl
implements IPricePolicyEsService {
    private static final Logger logger = LoggerFactory.getLogger(PricePolicyEsServiceImpl.class);
    private static String POLICY_INDEX_NAME = "price_policy_aliase";
    private static String POLICY_TYPE_NAME = "price_policy";
    @Autowired
    private ISearchIndexService searchIndexService;
    @Autowired
    private IOpenSearchService openSearchService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_PREFIX;
    @Autowired
    private IContext context;
    @Autowired
    private IPriceService priceService;
    @Autowired
    private IPriceTypeService priceTypeService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private EsNativeApiService esNativeApiService;
    @Resource
    private IPriceModelService priceModelService;
    @Resource
    private IBasePriceItemService basePriceItemService;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;

    @Override
    public void createPricePolicy(Long policyId) {
        PriceRespDto priceRespDto = this.priceService.queryPriceById(policyId);
        PricePolicyEsDto policyEsDto = new PricePolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, priceRespDto);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void updatePricePolicy(Long policyId) {
        PriceRespDto priceRespDto = this.priceService.queryPriceById(policyId);
        PricePolicyEsDto policyEsDto = new PricePolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, priceRespDto);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.updateData(documentVo);
        logger.info("\u4fdd\u5b58\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void deletePricePolicy(Long policyId) {
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(policyId.toString());
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.deleteData(documentVo);
        logger.info("\u5220\u9664\u6298\u6263\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void updatePriceStatus(Long policyId, String status) {
        SearchConditionVo searchConditionVo = new SearchConditionVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        searchConditionVo.addEqualFilter("_id", String.valueOf(policyId));
        HashMap update = Maps.newHashMap();
        update.put("status", status);
        this.searchIndexService.updateDataByCondition(searchConditionVo, (Map)update);
    }

    @Override
    public boolean queryByIndexId(Long policyId) {
        SearchIndexDocVo searchIndexDocVo = new SearchIndexDocVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME, String.valueOf(policyId));
        List indexDocContent = this.searchIndexService.getIndexDocContent(searchIndexDocVo);
        return indexDocContent.size() > 0;
    }

    @Override
    public List<ItemPolicyPriceRespDto> queryByBusiness(CommunalPriceQueryReqDto priceReqDto) {
        if (StringUtils.isEmpty((CharSequence)priceReqDto.getPriceCategoryCode())) {
            priceReqDto.setPriceCategoryCode(CategoryCodeEnum.SUPPLY_CHANNEL.getCode());
        }
        ArrayList<Long> skuIds = new ArrayList<Long>(priceReqDto.getSkuList().size());
        ArrayList<Long> itemIds = new ArrayList<Long>(priceReqDto.getSkuList().size());
        HashMap<Long, CommunalPriceQueryReqDto.ItemSkuPriceReqDto> itemSkuPriceReqDtoMap = new HashMap<Long, CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto : priceReqDto.getSkuList()) {
            skuIds.add(itemSkuPriceReqDto.getSkuId());
            itemIds.add(itemSkuPriceReqDto.getItemId());
            itemSkuPriceReqDtoMap.put(itemSkuPriceReqDto.getSkuId(), itemSkuPriceReqDto);
        }
        Date policyDate = priceReqDto.getPolicyDate();
        if (priceReqDto.getCustomerIds() == null) {
            priceReqDto.setCustomerIds(new ArrayList());
        }
        if (priceReqDto.getCustId() != null) {
            priceReqDto.getCustomerIds().add(priceReqDto.getCustId());
        }
        ArrayList<ItemPolicyPriceRespDto> result = new ArrayList<ItemPolicyPriceRespDto>();
        for (Long custId : priceReqDto.getCustomerIds()) {
            List<PricePolicyEsDto> pricePolicyEsDtos = this.queryByCondition(itemIds, skuIds, custId, policyDate);
            ArrayList itemPolicyPriceRespDtos = new ArrayList();
            pricePolicyEsDtos.forEach(esDto -> esDto.getItemList().forEach(e -> {
                ItemPolicyPriceRespDto itemPolicyPriceRespDto = new ItemPolicyPriceRespDto();
                this.copyProperties(itemPolicyPriceRespDto, (PricePolicyEsDto.ItemList)e);
                CubeBeanUtils.copyProperties((Object)itemPolicyPriceRespDto, (Object)esDto, (String[])new String[0]);
                itemPolicyPriceRespDto.setCustId(String.valueOf(custId));
                boolean skuIdContain = true;
                if (skuIds != null && !skuIds.isEmpty()) {
                    skuIdContain = skuIds.contains(itemPolicyPriceRespDto.getSkuId());
                }
                if (skuIdContain) {
                    itemPolicyPriceRespDtos.add(itemPolicyPriceRespDto);
                }
            }));
            Map<Long, List<ItemPolicyPriceRespDto>> groupBySku = itemPolicyPriceRespDtos.stream().collect(Collectors.groupingBy(ItemPolicyPriceRespDto::getSkuId));
            for (Long skuKey : groupBySku.keySet()) {
                List<Object> skuDiscounts;
                if (skuIds.contains(skuKey)) {
                    skuIds.remove(skuKey);
                }
                if ((skuDiscounts = groupBySku.get(skuKey)).size() > 1) {
                    Integer minWeight = skuDiscounts.stream().filter(o -> o.getWeight() != null).map(ItemPolicyPriceRespDto::getWeight).distinct().min(Integer::compareTo).get();
                    if ((skuDiscounts = skuDiscounts.stream().filter(s -> s.getWeight().equals(minWeight)).collect(Collectors.toList())).size() > 1) {
                        skuDiscounts.sort((Comparator<Object>)new Comparator<ItemPolicyPriceRespDto>(){

                            @Override
                            public int compare(ItemPolicyPriceRespDto o1, ItemPolicyPriceRespDto o2) {
                                return 0 - o1.getEffectiveTime().compareTo(o2.getEffectiveTime());
                            }
                        });
                    }
                }
                result.add(skuDiscounts.get(0));
            }
            if (skuIds.size() <= 0) continue;
            for (Long skuid : skuIds) {
                ItemPolicyPriceRespDto itemPolicyPriceRespDto = new ItemPolicyPriceRespDto();
                itemPolicyPriceRespDto.setCustId(String.valueOf(custId));
                itemPolicyPriceRespDto.setSkuId(skuid);
                itemPolicyPriceRespDto.setItemId(((CommunalPriceQueryReqDto.ItemSkuPriceReqDto)itemSkuPriceReqDtoMap.get(skuid)).getItemId());
                itemPolicyPriceRespDto.setPricePolicyDate(policyDate);
                itemPolicyPriceRespDto.setHasLadderPrice(false);
                itemPolicyPriceRespDto.setPrice(((CommunalPriceQueryReqDto.ItemSkuPriceReqDto)itemSkuPriceReqDtoMap.get(skuid)).getSkuSellPrice());
                result.add(itemPolicyPriceRespDto);
            }
        }
        return result;
    }

    public List<PricePolicyEsDto> queryByCondition(List<Long> itemIds, List<Long> skuIds, Long custId, Date orderTime) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME);
        osSearchVo.setTypeName(POLICY_TYPE_NAME);
        osSearchVo.addRangeFilter("effectiveTime", null, DateUtil.getDateFormat(orderTime, DateUtil.DEFAULT_PATTERN));
        osSearchVo.addRangeFilter("invalidTime", DateUtil.getDateFormat(orderTime, DateUtil.DEFAULT_PATTERN), null);
        if (skuIds != null && !skuIds.isEmpty()) {
            osSearchVo.addInFilter("itemList.skuId", skuIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]));
        }
        osSearchVo.addEqualFilter("customerList.customerIds", String.valueOf(custId));
        int page = 1;
        ArrayList<PricePolicyEsDto> pricePolcyEsDtos = new ArrayList<PricePolicyEsDto>();
        SearchResultVo searchResultVo = null;
        osSearchVo.setPageSize(200);
        osSearchVo.setPage(page);
        do {
            if (null == (searchResultVo = this.openSearchService.search(osSearchVo))) continue;
            List pageEsDtos = searchResultVo.getDocValues().stream().map(doc -> {
                PricePolicyEsDto policyEsDto = (PricePolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PricePolicyEsDto.class);
                return policyEsDto;
            }).collect(Collectors.toList());
            pricePolcyEsDtos.addAll(pageEsDtos);
            osSearchVo.setPage(++page);
        } while (searchResultVo != null && !CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()));
        return pricePolcyEsDtos;
    }

    private void copyProperties(ItemPolicyPriceRespDto itemPolicyPriceRespDto, PricePolicyEsDto.ItemList itemList) {
        itemPolicyPriceRespDto.setSkuId(itemList.getSkuId());
        itemPolicyPriceRespDto.setItemId(itemList.getItemId());
        if (itemList.getItemLimit().size() > 0) {
            itemPolicyPriceRespDto.setHasLadderPrice(true);
            List itemLimits = itemList.getItemLimit();
            ArrayList<ItemPolicyPriceRespDto.LadderPrice> ladderPrices = new ArrayList<ItemPolicyPriceRespDto.LadderPrice>(itemLimits.size());
            for (PricePolicyEsDto.ItemLimit itemLimit : itemLimits) {
                ItemPolicyPriceRespDto.LadderPrice ladderPrice = new ItemPolicyPriceRespDto.LadderPrice();
                ladderPrice.setLower(itemLimit.getLowerLimit());
                ladderPrice.setUpper(itemLimit.getUpperLimit());
                ladderPrice.setPrice(itemLimit.getItemPrice());
                ladderPrices.add(ladderPrice);
            }
            itemPolicyPriceRespDto.setLadderPrices(ladderPrices);
        } else {
            itemPolicyPriceRespDto.setHasLadderPrice(false);
            itemPolicyPriceRespDto.setPrice(itemList.getItemPrice());
        }
    }

    private void convert2PolicyEsDto(PricePolicyEsDto policyEsDto, PriceRespDto priceRespDto) {
        policyEsDto.setPolicyId(priceRespDto.getId());
        policyEsDto.setOriginalPriceId(priceRespDto.getOriginalPriceId());
        policyEsDto.setFirstPriceId(priceRespDto.getFirstPriceId());
        policyEsDto.setPolicyCode(priceRespDto.getCode());
        policyEsDto.setInstanceId(priceRespDto.getInstanceId());
        policyEsDto.setTenantId(priceRespDto.getTenantId());
        policyEsDto.setCreatePerson(priceRespDto.getCreatePerson());
        policyEsDto.setReadStatus(priceRespDto.getReadStatus());
        policyEsDto.setExtension(priceRespDto.getExtension());
        policyEsDto.setCategoryCode(priceRespDto.getCategoryCode());
        policyEsDto.setName(priceRespDto.getName());
        policyEsDto.setOrganizationId(priceRespDto.getOrganizationId());
        policyEsDto.setAuditPassTime(priceRespDto.getAuditLog() == null ? null : priceRespDto.getAuditLog().getAuditTime());
        policyEsDto.setCreateTime(priceRespDto.getCreateTime());
        policyEsDto.setEffectiveTime(priceRespDto.getEffectiveTime());
        policyEsDto.setStatus(priceRespDto.getStatus());
        if (ObjectUtil.isNull((Object)priceRespDto.getInvalidTime())) {
            policyEsDto.setInvalidTime(DateUtil.setDateEnd(DateUtil.getDateAfter(new Date(), 36500)));
            policyEsDto.setLongTermValid(Integer.valueOf(1));
        } else {
            policyEsDto.setInvalidTime(priceRespDto.getInvalidTime());
            policyEsDto.setLongTermValid(Integer.valueOf(0));
        }
        policyEsDto.setPriceModeId(priceRespDto.getModelId());
        policyEsDto.setShopId(priceRespDto.getShopId());
        String shopName = this.shopHelper.getShopName(priceRespDto.getShopId());
        policyEsDto.setShopName(shopName);
        policyEsDto.setPriceTypeId(priceRespDto.getTypeId());
        policyEsDto.setPolicyDiscountRate(priceRespDto.getDiscountRate());
        policyEsDto.setDiscountType(priceRespDto.getDiscountType());
        policyEsDto.setGiftboxIncrPrice(priceRespDto.getGiftboxIncrPrice());
        policyEsDto.setItemDimension(priceRespDto.getRelationItemType());
        policyEsDto.setCustomerDimension(priceRespDto.getRelationCustomerType());
        if (priceRespDto.getTypeId() == null) {
            policyEsDto.setWeight(Integer.valueOf(0));
        } else {
            PriceTypeRespDto priceTypeRespDto = this.priceTypeService.queryPriceTypeById(priceRespDto.getTypeId());
            policyEsDto.setWeight(Integer.valueOf(priceTypeRespDto.getWeight() == null ? 0 : Integer.parseInt(priceTypeRespDto.getWeight())));
        }
        this.setEsDtoPriceCustCondition(policyEsDto, priceRespDto);
        this.setEsDtoPriceItemCondition(policyEsDto, priceRespDto);
        List priceItemRespDtos = priceRespDto.getPriceItemRespDtos();
        ArrayList<PricePolicyEsDto.ItemList> itemList = new ArrayList<PricePolicyEsDto.ItemList>();
        if (CollectionUtil.isNotEmpty((Collection)priceItemRespDtos)) {
            for (PriceItemRespDto priceItemRespDto : priceItemRespDtos) {
                List priceNumLimitList;
                PricePolicyEsDto.ItemList itemListData = new PricePolicyEsDto.ItemList();
                itemListData.setItemId(priceItemRespDto.getItemId());
                itemListData.setItemName(priceItemRespDto.getItemName());
                itemListData.setSkuId(priceItemRespDto.getSkuId());
                itemListData.setSkuDesc(priceItemRespDto.getSkuDesc());
                itemListData.setPriceModelSetType(priceItemRespDto.getPriceModelSetType());
                itemListData.setDiscountRate(priceItemRespDto.getDiscountRate());
                itemListData.setDiscountType(priceItemRespDto.getDiscountType());
                itemListData.setGiftboxIncrPrice(priceItemRespDto.getGiftboxIncrPrice());
                if (ObjectUtil.isNotNull((Object)priceItemRespDto.getItemPrice())) {
                    itemListData.setItemPrice(priceItemRespDto.getItemPrice());
                }
                if (CollectionUtil.isNotEmpty((Collection)(priceNumLimitList = priceItemRespDto.getPriceNumLimitList()))) {
                    ArrayList<PricePolicyEsDto.ItemLimit> itemLimitList = new ArrayList<PricePolicyEsDto.ItemLimit>();
                    for (PriceAndNumLimitDto priceAndNumLimitDto : priceNumLimitList) {
                        PricePolicyEsDto.ItemLimit itemLimitData = new PricePolicyEsDto.ItemLimit();
                        itemLimitData.setLowerLimit(priceAndNumLimitDto.getLowerLimit());
                        itemLimitData.setUpperLimit(priceAndNumLimitDto.getUpperLimit());
                        itemLimitData.setItemPrice(priceAndNumLimitDto.getItemPrice());
                        itemLimitList.add(itemLimitData);
                    }
                    itemListData.setItemLimit(itemLimitList);
                }
                itemList.add(itemListData);
            }
        }
        policyEsDto.setItemList(itemList);
        policyEsDto.setPriceBrandRespDtos(priceRespDto.getPriceBrandRespDtos());
    }

    private void setEsDtoPriceCustCondition(PricePolicyEsDto policyEsDto, PriceRespDto priceRespDto) {
        List customerIds = new ArrayList();
        ArrayList<Long> customerTypeIds = new ArrayList<Long>();
        List customerGroupIds = new ArrayList();
        ArrayList customerAreaCodes = new ArrayList();
        ArrayList<String> customerAreaCodesWithSub = new ArrayList<String>();
        if (priceRespDto.getRelationCustomerType() == Integer.valueOf(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType())) {
            customerGroupIds = priceRespDto.getCustomerConditionRespDto().getCustomerGroupIds();
            List policyCustomerAreaCodes = priceRespDto.getCustomerConditionRespDto().getCustomerAreaCodes();
            List policyCustomerAreaCodeExts = priceRespDto.getCustomerConditionRespDto().getCustomerAreaCodeExts();
            if (!CollectionUtils.isEmpty((Collection)policyCustomerAreaCodes)) {
                customerAreaCodes.addAll(policyCustomerAreaCodes);
                customerAreaCodesWithSub.addAll(policyCustomerAreaCodes);
                if (!CollectionUtils.isEmpty((Collection)policyCustomerAreaCodeExts)) {
                    customerAreaCodesWithSub.addAll(policyCustomerAreaCodeExts);
                }
            } else {
                customerAreaCodesWithSub.add("-1");
            }
            policyEsDto.setCustomerAreaCodes(customerAreaCodes);
            policyEsDto.setCustomerAreaCodesWithSub(customerAreaCodesWithSub);
            List policyCustomerTypeIds = priceRespDto.getCustomerConditionRespDto().getCustomerTypeIds();
            if (!CollectionUtils.isEmpty((Collection)policyCustomerTypeIds)) {
                customerTypeIds.addAll(policyCustomerTypeIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
            } else {
                customerTypeIds.add(-1L);
            }
            policyEsDto.setCustomerTypeIds(customerTypeIds);
            List excludeCustIds = null;
            if (!CollectionUtils.isEmpty((Collection)priceRespDto.getPriceRejectCustomerRespDtoList())) {
                excludeCustIds = priceRespDto.getPriceRejectCustomerRespDtoList().stream().map(e -> e.getCustomerId()).collect(Collectors.toList());
            }
            policyEsDto.setCustomerExcludeCustIds(excludeCustIds);
        } else if (priceRespDto.getRelationCustomerType() == Integer.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType())) {
            customerIds = priceRespDto.getCustomerConditionRespDto().getCustomerIds();
            List specialCustIds = customerIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            policyEsDto.setCustomerSpecialCustIds(specialCustIds);
        }
    }

    private void setEsDtoPriceItemCondition(PricePolicyEsDto policyEsDto, PriceRespDto priceRespDto) {
        PriceItemConditionRespDto priceItemConditionRespDto = priceRespDto.getPriceItemConditionRespDto();
        if (priceRespDto.getRelationItemType() == Integer.valueOf(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            List excludeSkuIds = null;
            List itemBackDirIds = null;
            ArrayList<Object> itemBackDirIdsWithSub = new ArrayList<Object>();
            List<Object> itemTypes = Lists.newArrayList();
            List<Object> itemBrandIds = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)priceRespDto.getPriceRejectItemRespDtoList())) {
                excludeSkuIds = priceRespDto.getPriceRejectItemRespDtoList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemBackDirIds())) {
                itemBackDirIds = priceItemConditionRespDto.getItemBackDirIds().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
                List itemBackDirIdExtList = Arrays.asList(priceItemConditionRespDto.getItemBackDirIdsExt().split(",")).stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
                itemBackDirIdsWithSub.addAll(itemBackDirIdExtList);
            } else {
                itemBackDirIdsWithSub.add(-1L);
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemBrandIds())) {
                itemBrandIds = priceItemConditionRespDto.getItemBrandIds().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            } else {
                itemBrandIds.add(-1L);
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemTypes())) {
                itemTypes = priceItemConditionRespDto.getItemTypes().stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList());
            } else {
                itemTypes.add(-1);
            }
            policyEsDto.setItemExcludeSkuIds(excludeSkuIds);
            policyEsDto.setItemBackDirs(itemBackDirIds);
            policyEsDto.setItemBackDirsWithSub(itemBackDirIdsWithSub);
            policyEsDto.setItemBrandIds((List)itemBrandIds);
            policyEsDto.setItemSubTypes((List)itemTypes);
            policyEsDto.setItemTypes((List)itemTypes);
        }
    }

    @Override
    public SkuPolicyPriceCalcRespVo calcSkuPolicyPrice(SkuPolicyPriceCalcReqVo reqVo) {
        PricePolicyEsDto pricePolicyEsDto = reqVo.getPricePolicyEsDto();
        SkuPolicyPriceCalcRespVo respVo = new SkuPolicyPriceCalcRespVo();
        respVo.setSkuId(reqVo.getSkuId());
        respVo.setCustomId(reqVo.getCustomerId());
        respVo.setShopId(reqVo.getShopId());
        respVo.setDiscountType(pricePolicyEsDto.getDiscountType());
        if (CollectionUtils.isEmpty((Collection)pricePolicyEsDto.getItemList())) {
            this.calcRatePrice(reqVo, respVo);
        } else {
            List<SkuPolicyPriceCalcRespVo.SkuLadderPrice> skuLadderPriceList = null;
            PricePolicyEsDto.ItemList skuItemList = reqVo.getPricePolicyEsDto().getItemList().stream().filter(item -> item.getSkuId().equals(reqVo.getSkuId())).findFirst().orElse(null);
            if (skuItemList != null) {
                if (Objects.equals(PriceModelSetTypeEnum.DIRECT_SET.getCode(), skuItemList.getPriceModelSetType()) && !CollectionUtils.isEmpty((Collection)skuItemList.getItemLimit())) {
                    skuLadderPriceList = skuItemList.getItemLimit().stream().map(limit -> {
                        SkuPolicyPriceCalcRespVo.SkuLadderPrice skuLadderPrice = new SkuPolicyPriceCalcRespVo.SkuLadderPrice();
                        skuLadderPrice.setLadderPrice(limit.getItemPrice());
                        skuLadderPrice.setLowerNum(limit.getLowerLimit());
                        skuLadderPrice.setUpperNum(limit.getUpperLimit());
                        return skuLadderPrice;
                    }).collect(Collectors.toList());
                    respVo.setHasLadderPrice(true);
                    respVo.setSkuLadderPrices(skuLadderPriceList);
                } else {
                    SkuPolicyPriceCalcReqVo copyPolicyPriceCalcReqVo = new SkuPolicyPriceCalcReqVo();
                    CubeBeanUtils.copyProperties((Object)copyPolicyPriceCalcReqVo, (Object)reqVo, (String[])new String[0]);
                    PricePolicyEsDto copyPricePolicyEsDto = copyPolicyPriceCalcReqVo.getPricePolicyEsDto();
                    copyPricePolicyEsDto.setDiscountType(skuItemList.getDiscountType());
                    copyPricePolicyEsDto.setPolicyDiscountRate(skuItemList.getDiscountRate());
                    copyPricePolicyEsDto.setGiftboxIncrPrice(skuItemList.getGiftboxIncrPrice());
                    this.calcRatePrice(copyPolicyPriceCalcReqVo, respVo);
                }
            }
        }
        return respVo;
    }

    private void calcRatePrice(SkuPolicyPriceCalcReqVo reqVo, SkuPolicyPriceCalcRespVo respVo) {
        BigDecimal policyGiftBoxInrePrice;
        PricePolicyEsDto pricePolicyEsDto = reqVo.getPricePolicyEsDto();
        BasePriceItemEo dealerSkuBasePriceEo = reqVo.getDealerSkuBasePriceEo();
        BasePriceItemEo brandSkuRetailPriceEo = reqVo.getBrandSkuRetailPriceEo();
        BigDecimal baseDiscountRate = reqVo.getPrBaseDiscountReate();
        BigDecimal curSkuDiscountPrice = null;
        BigDecimal discountBasePrice = null;
        Integer useBasePriceType = null;
        Integer discountType = pricePolicyEsDto.getDiscountType();
        BigDecimal discountRate = Optional.ofNullable(pricePolicyEsDto.getPolicyDiscountRate()).orElse(BigDecimal.ZERO);
        BigDecimal bigDecimal = policyGiftBoxInrePrice = pricePolicyEsDto.getGiftboxIncrPrice() == null ? BigDecimal.ZERO : pricePolicyEsDto.getGiftboxIncrPrice();
        if (CollectionUtil.isNotEmpty((Collection)pricePolicyEsDto.getPriceBrandRespDtos())) {
            for (PriceBrandRespDto priceBrandRespDto : pricePolicyEsDto.getPriceBrandRespDtos()) {
                if (!Objects.equals(reqVo.getBrandId(), priceBrandRespDto.getBrandId())) continue;
                discountRate = priceBrandRespDto.getDiscountRate();
                policyGiftBoxInrePrice = priceBrandRespDto.getIncrPrice();
                discountType = priceBrandRespDto.getDiscountType();
            }
        }
        PriceTypeEnum priceTypeEnum = null;
        PriceModelRespDto priceModelRespDto = reqVo.getPriceModelRespDto();
        if (priceModelRespDto != null && !CollectionUtils.isEmpty((Collection)priceModelRespDto.getReference())) {
            if (priceModelRespDto.getReference().stream().anyMatch(e -> Objects.equals(3L, e.getTypeId()))) {
                discountBasePrice = dealerSkuBasePriceEo == null ? null : dealerSkuBasePriceEo.getItemPrice();
                useBasePriceType = discountBasePrice == null ? null : Integer.valueOf(2);
                priceTypeEnum = PriceTypeEnum.DEALER_RETAIL_PRICE;
            }
            if (discountBasePrice == null && priceModelRespDto.getReference().stream().anyMatch(e -> Objects.equals(1L, e.getTypeId()))) {
                discountBasePrice = brandSkuRetailPriceEo == null ? null : brandSkuRetailPriceEo.getItemPrice();
                useBasePriceType = discountBasePrice == null ? null : Integer.valueOf(1);
                priceTypeEnum = PriceTypeEnum.RETAIL_PRICE;
            }
        }
        logger.info("[\u8ba1\u7b97\u6263\u7387\u4ef7\u683c\u57fa\u51c6\u4ef7]\uff1a{}", discountBasePrice);
        CalcPriceDescriptionRespDto calcPriceDescriptionRespDto = null;
        if (Objects.equals(DiscountTypeEnum.FIXED_DISCOUNT.getType(), discountType)) {
            logger.info("[\u6700\u7ec8\u57fa\u7840\u6263\u7387]\uff1a{}", (Object)discountRate);
            curSkuDiscountPrice = discountBasePrice == null ? null : discountBasePrice.multiply(discountRate.divide(new BigDecimal(100.0))).add(policyGiftBoxInrePrice).setScale(2, RoundingMode.HALF_UP);
            calcPriceDescriptionRespDto = CalcPriceDescriptionRespDto.build((BigDecimal)discountBasePrice, (BigDecimal)discountRate, (BigDecimal)policyGiftBoxInrePrice, (PriceTypeEnum)priceTypeEnum);
        } else if (baseDiscountRate != null) {
            BigDecimal addRate = discountRate.add(baseDiscountRate);
            addRate = addRate.compareTo(BigDecimal.ZERO) >= 0 ? addRate : new BigDecimal("100.00");
            logger.info("[\u6700\u7ec8\u57fa\u7840\u6263\u7387]\uff1a{}", (Object)addRate);
            curSkuDiscountPrice = discountBasePrice == null ? null : discountBasePrice.multiply(addRate.divide(new BigDecimal(100.0))).add(policyGiftBoxInrePrice).setScale(2, RoundingMode.HALF_UP);
            calcPriceDescriptionRespDto = CalcPriceDescriptionRespDto.build((BigDecimal)discountBasePrice, (BigDecimal)baseDiscountRate, (BigDecimal)discountRate, (BigDecimal)policyGiftBoxInrePrice, (PriceTypeEnum)priceTypeEnum);
        }
        logger.info("[\u653f\u7b56\u4ef7\u8ba1\u7b97\u516c\u5f0f]\uff1a", (Object)JSON.toJSONString(calcPriceDescriptionRespDto));
        respVo.setHasDiscountPrice(curSkuDiscountPrice != null && curSkuDiscountPrice.compareTo(BigDecimal.ZERO) >= 0);
        respVo.setSkuPolcyDiscountPrice(curSkuDiscountPrice);
        respVo.setDiscountRate(discountRate);
        respVo.setDiscountBasePriceType(discountType);
        respVo.setUseBasePriceType(useBasePriceType);
        respVo.setCalcPriceDescriptionRespDto(calcPriceDescriptionRespDto);
    }

    @Override
    public Comparator getPricePolicyComp(final Map<Long, PriceTypeEo> priceTypeEoMap) {
        return new Comparator<PricePolicyEsDto>(){

            @Override
            public int compare(PricePolicyEsDto o1, PricePolicyEsDto o2) {
                Integer itemDimesion2;
                Integer custDimesion2;
                Integer priceTypeLevel2;
                Integer priceTypeLevel1;
                logger.info("[\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u672b\u7aef\u8282\u70b9\u4f18\u5148\u7ea7\u6bd4\u8f83]\uff0c\u653f\u7b56\uff1a{},\u672b\u7aef\u8282\u70b9\uff1a{},\u653f\u7b56\uff1a{},\u672b\u7aef\u8282\u70b9\uff1a{}", new Object[]{o1.getPolicyCode(), o1.getParentAreaCodeList(), o2.getPolicyCode(), o2.getParentAreaCodeList()});
                PriceTypeEo typeEo1 = (PriceTypeEo)priceTypeEoMap.get(o1.getPriceTypeId());
                PriceTypeEo typeEo2 = (PriceTypeEo)priceTypeEoMap.get(o2.getPriceTypeId());
                if (typeEo1 != null && typeEo2 != null && (priceTypeLevel1 = Integer.valueOf(StringUtils.isEmpty((CharSequence)typeEo1.getWeight()) ? 100 : Integer.valueOf(typeEo1.getWeight()))) != (priceTypeLevel2 = Integer.valueOf(StringUtils.isEmpty((CharSequence)typeEo2.getWeight()) ? 100 : Integer.valueOf(typeEo2.getWeight())))) {
                    return priceTypeLevel1 - priceTypeLevel2;
                }
                Integer custDimesion1 = o1.getCustomerDimension();
                if (custDimesion1 != (custDimesion2 = o2.getCustomerDimension())) {
                    return custDimesion1 - custDimesion2;
                }
                if (Objects.equals(custDimesion1, 1) && CollectionUtil.isNotEmpty((Collection)o1.getParentAreaCodeList()) && CollectionUtil.isNotEmpty((Collection)o2.getParentAreaCodeList()) && o1.getParentAreaCodeList().size() != o2.getParentAreaCodeList().size()) {
                    return o2.getParentAreaCodeList().size() - o1.getParentAreaCodeList().size();
                }
                Integer itemDimesion1 = o1.getItemDimension();
                if (itemDimesion1 != (itemDimesion2 = o2.getItemDimension())) {
                    return custDimesion1 - custDimesion2;
                }
                Date effTime1 = o1.getEffectiveTime();
                Date effTime2 = o2.getEffectiveTime();
                return 0 - effTime1.compareTo(effTime2);
            }
        };
    }

    @Override
    public Map<String, List<PricePolicyEsDto>> queryDistributionPricePolicyList(CommunalPriceQueryReqDto queryPriceReqDto) {
        List custIds = queryPriceReqDto.getQueryCustIds();
        Assert.notEmpty((Collection)custIds, (String)"\u67e5\u4ef7\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        HashMap<String, List<PricePolicyEsDto>> result = new HashMap<String, List<PricePolicyEsDto>>();
        List<Long> skuIds = queryPriceReqDto.getSkuList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
        List<Long> shopIdList = queryPriceReqDto.getSkuList().stream().filter(e -> e.getShopId() != null).map(e -> e.getShopId()).distinct().collect(Collectors.toList());
        Date policyDate = queryPriceReqDto.getPolicyDate();
        Long policyOrgId = queryPriceReqDto.getOrganizationId();
        String policyCode = queryPriceReqDto.getPolicyCode();
        List priceTypeIdList = queryPriceReqDto.getPriceTypeIdList();
        String priceCategoryCode = queryPriceReqDto.getPriceCategoryCode() == null ? CategoryCodeEnum.CHANNEL_DISTRIBUTION.getCode() : queryPriceReqDto.getPriceCategoryCode();
        List itemSkuListRespDto = (List)this.itemSkuQueryApi.querySkuExtBySkuId(skuIds).getData();
        Map<Long, ItemSkuExtRespDto> skuMap = itemSkuListRespDto.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
        Map<String, ItemAuthRespDto> skuShopAuthMap = this.shopHelper.checkShopSkuRange(shopIdList, skuIds);
        Map<Long, SellerRespDto> shopSellerMap = this.shopHelper.getShopSeller(shopIdList);
        List customerRespDtoList = (List)this.customerExtQueryApi.queryListOnPostByCustomerIds(custIds).getData();
        for (CustomerRespDto customerRespDto : customerRespDtoList) {
            List<PricePolicyEsDto> skuPricePolicyEsDtos = this.queryPricePolicyEsDtoNative(policyDate, shopIdList, itemSkuListRespDto, customerRespDto, policyOrgId, priceTypeIdList, policyCode, priceCategoryCode);
            for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto : queryPriceReqDto.getSkuList()) {
                ItemSkuExtRespDto skuExtRespDto = skuMap.get(itemSkuPriceReqDto.getSkuId());
                Long curShopId = itemSkuPriceReqDto.getShopId();
                skuExtRespDto.setShopId(curShopId);
                SellerRespDto shopSeller = shopSellerMap.get(curShopId);
                String curSkuIdStr = String.valueOf(itemSkuPriceReqDto.getSkuId());
                String curShopIdStr = String.valueOf(curShopId);
                String custIdStr = String.valueOf(customerRespDto.getId());
                String curResultkey = custIdStr + "-" + curShopIdStr + "-" + curSkuIdStr;
                String tmpSkuShopIdKey = curSkuIdStr + "-" + curShopIdStr;
                if (skuShopAuthMap.get(tmpSkuShopIdKey) == null) {
                    logger.info("skuId={},can'not sell in shopId={}\uff0cno auth info", (Object)itemSkuPriceReqDto.getSkuId(), (Object)curShopId);
                    result.put(curResultkey, null);
                    continue;
                }
                if (shopSeller == null || !customerRespDto.getMerchantId().equals(shopSeller.getOrganizationId())) {
                    logger.info("custId={}, not bolong shopId={}", (Object)customerRespDto.getId(), (Object)curShopId);
                    result.put(curResultkey, null);
                    continue;
                }
                List<PricePolicyEsDto> curSkuPricePolicyEsDtos = this.getSkuMatchPricePolicy(skuExtRespDto, skuPricePolicyEsDtos);
                if (queryPriceReqDto.getOnlyBestMatch() == 1 && !CollectionUtils.isEmpty(curSkuPricePolicyEsDtos)) {
                    PricePolicyEsDto bestMatchPolicyEsDto = this.getBestMatchPolicy(curSkuPricePolicyEsDtos);
                    curSkuPricePolicyEsDtos = Arrays.asList(bestMatchPolicyEsDto);
                }
                result.put(curResultkey, curSkuPricePolicyEsDtos);
            }
        }
        return result;
    }

    @Override
    public PricePolicyEsDto getBestMatchPolicy(List<PricePolicyEsDto> pricePolicyEsDtoList) {
        if (!CollectionUtils.isEmpty(pricePolicyEsDtoList)) {
            List<Long> priceTypeIdList = pricePolicyEsDtoList.stream().map(e -> e.getPriceTypeId()).distinct().collect(Collectors.toList());
            List<PriceTypeEo> priceTypeList = this.priceTypeService.queryPriceTypeByIds(priceTypeIdList);
            final Map<Long, PriceTypeEo> typeEoMap = priceTypeList.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
            pricePolicyEsDtoList.sort(new Comparator<PricePolicyEsDto>(){

                @Override
                public int compare(PricePolicyEsDto o1, PricePolicyEsDto o2) {
                    Integer itemDimesion2;
                    Integer custDimesion2;
                    Integer priceTypeLevel2;
                    Integer priceTypeLevel1;
                    logger.info("[\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u672b\u7aef\u8282\u70b9\u4f18\u5148\u7ea7\u6bd4\u8f83]\uff0c\u653f\u7b56\uff1a{},\u672b\u7aef\u8282\u70b9\uff1a{},\u653f\u7b56\uff1a{},\u672b\u7aef\u8282\u70b9\uff1a{}", new Object[]{o1.getPolicyCode(), o1.getParentAreaCodeList(), o2.getPolicyCode(), o2.getParentAreaCodeList()});
                    PriceTypeEo typeEo1 = (PriceTypeEo)typeEoMap.get(o1.getPriceTypeId());
                    PriceTypeEo typeEo2 = (PriceTypeEo)typeEoMap.get(o2.getPriceTypeId());
                    if (typeEo1 != null && typeEo2 != null && !(priceTypeLevel1 = Integer.valueOf(StringUtils.isEmpty((CharSequence)typeEo1.getWeight()) ? 100 : Integer.valueOf(typeEo1.getWeight()))).equals(priceTypeLevel2 = Integer.valueOf(StringUtils.isEmpty((CharSequence)typeEo2.getWeight()) ? 100 : Integer.valueOf(typeEo2.getWeight())))) {
                        return priceTypeLevel1 - priceTypeLevel2;
                    }
                    Integer custDimesion1 = o1.getCustomerDimension();
                    if (!custDimesion1.equals(custDimesion2 = o2.getCustomerDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    if (Objects.equals(custDimesion1, 1) && CollectionUtil.isNotEmpty((Collection)o1.getParentAreaCodeList()) && CollectionUtil.isNotEmpty((Collection)o2.getParentAreaCodeList()) && o1.getParentAreaCodeList().size() != o2.getParentAreaCodeList().size()) {
                        return o2.getParentAreaCodeList().size() - o1.getParentAreaCodeList().size();
                    }
                    Integer itemDimesion1 = o1.getItemDimension();
                    if (!itemDimesion1.equals(itemDimesion2 = o2.getItemDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    Date effTime1 = o1.getEffectiveTime();
                    Date effTime2 = o2.getEffectiveTime();
                    return 0 - effTime1.compareTo(effTime2);
                }
            });
            return pricePolicyEsDtoList.get(0);
        }
        return null;
    }

    private List<PricePolicyEsDto> getSkuMatchPricePolicy(ItemSkuExtRespDto skuExtRespDto, List<PricePolicyEsDto> skuPricePolicyEsDtos) {
        ArrayList<PricePolicyEsDto> res = new ArrayList<PricePolicyEsDto>();
        for (PricePolicyEsDto pricePolicyEsDto : skuPricePolicyEsDtos) {
            Long policyShopId = pricePolicyEsDto.getShopId();
            if (!policyShopId.equals(skuExtRespDto.getShopId())) continue;
            String itemDimensionStr = String.valueOf(pricePolicyEsDto.getItemDimension());
            ItemDimensionEnum itemDimension = ItemDimensionEnum.getByType((String)itemDimensionStr);
            if (ItemDimensionEnum.ITEM_ALL_ENUM.getType().equals(itemDimension.getType()) && !SubTypeEnum.PRODUCT.getType().equals(skuExtRespDto.getSubType())) continue;
            switch (itemDimension) {
                case ITEM_SPECIAL_ENUM: {
                    List skuIdList = pricePolicyEsDto.getItemList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
                    if (!skuIdList.contains(skuExtRespDto.getSkuId())) break;
                    res.add(pricePolicyEsDto);
                    break;
                }
                case ITEM_RANGE_ENUM: {
                    List subTypeList = pricePolicyEsDto.getItemSubTypes();
                    List brandIdList = pricePolicyEsDto.getItemBrandIds();
                    List dirIdList = pricePolicyEsDto.getItemBackDirs();
                    List itemBackDirsWithSub = pricePolicyEsDto.getItemBackDirsWithSub();
                    List excludeSkuIdList = pricePolicyEsDto.getItemExcludeSkuIds();
                    boolean rangeMatch = true;
                    Integer skuSubType = skuExtRespDto.getSubType();
                    Long backDirId = skuExtRespDto.getDirId();
                    Long brandId = skuExtRespDto.getBrandId();
                    Long skuId = skuExtRespDto.getSkuId();
                    if (!(CollectionUtils.isEmpty((Collection)subTypeList) || subTypeList.contains(skuSubType) || subTypeList.contains(-1))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!(CollectionUtils.isEmpty((Collection)itemBackDirsWithSub) || itemBackDirsWithSub.contains(backDirId) || itemBackDirsWithSub.contains(-1L))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!(CollectionUtils.isEmpty((Collection)brandIdList) || brandIdList.contains(brandId) || brandIdList.contains(-1L))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!CollectionUtils.isEmpty((Collection)excludeSkuIdList) && excludeSkuIdList.contains(skuId) && !excludeSkuIdList.contains(-1L)) {
                        rangeMatch = false;
                        break;
                    }
                    if (!rangeMatch) break;
                    res.add(pricePolicyEsDto);
                    break;
                }
                case ITEM_ALL_ENUM: {
                    res.add(pricePolicyEsDto);
                    break;
                }
            }
        }
        return res;
    }

    private List<PricePolicyEsDto> queryPricePolicyEsDtoNative(Date policyDate, List<Long> shopIdList, List<ItemSkuExtRespDto> itemSkuListRespDto, CustomerRespDto customerRespDto, Long policyOrgId, List<Long> priceTypeIdList, String policyCode, String priceCategoryCode) {
        ArrayList<PricePolicyEsDto> result = new ArrayList<PricePolicyEsDto>();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder itemBoolQuery = QueryBuilders.boolQuery();
        this.buildMutilItemBoolQuery(itemBoolQuery, itemSkuListRespDto);
        BoolQueryBuilder custBoolQuery = QueryBuilders.boolQuery();
        this.buildCustBoolQuery(custBoolQuery, customerRespDto);
        policyOrgId = policyOrgId != null ? policyOrgId : customerRespDto.getMerchantId();
        policyDate = policyDate == null ? new Date() : policyDate;
        String policyDateStr = DateUtil.getDateFormat(policyDate, DateUtil.DEFAULT_PATTERN);
        boolQuery.must().add(QueryBuilders.termQuery((String)"organizationId", (Object)policyOrgId));
        if (!CollectionUtils.isEmpty(priceTypeIdList)) {
            boolQuery.must().add(QueryBuilders.termsQuery((String)"priceTypeId", priceTypeIdList));
        }
        if (!StringUtils.isEmpty((CharSequence)policyCode)) {
            boolQuery.must().add(QueryBuilders.termsQuery((String)"policyCode", (String[])new String[]{policyCode}));
        }
        if (!StringUtils.isEmpty((CharSequence)priceCategoryCode)) {
            boolQuery.must().add(QueryBuilders.termQuery((String)"categoryCode", (String)priceCategoryCode));
        }
        if (!CollectionUtils.isEmpty(shopIdList)) {
            boolQuery.must().add(QueryBuilders.termsQuery((String)"shopId", shopIdList));
        }
        boolQuery.must().add(QueryBuilders.termsQuery((String)"status", (String[])new String[]{PriceStatusEnum.AUDIT_PASS.getCode()}));
        BoolQueryBuilder policyDateBoolQuery = QueryBuilders.boolQuery();
        this.buildPolicyDataBoolQuery(policyDateBoolQuery, policyDateStr);
        boolQuery.must().add(policyDateBoolQuery);
        boolQuery.must().add(custBoolQuery);
        boolQuery.must().add(itemBoolQuery);
        logger.info("\u67e5\u8be2sku\u96c6\u5408 custId={}\uff0c\u7684es\u8bed\u53e5", (Object)customerRespDto.getId());
        logger.info("boolQuery={}", (Object)boolQuery.toString(false));
        int page = 1;
        int pageSize = 100;
        int startIndex = page > 0 ? (page - 1) * pageSize : 0;
        SearchResultVo searchResultVo = null;
        do {
            searchSourceBuilder.sort("createTime", SortOrder.DESC).from(startIndex).size(pageSize).fetchSource(true).query((QueryBuilder)boolQuery);
            searchResultVo = this.esNativeApiService.wrapNativeSearch(searchSourceBuilder, searchRequest);
            if (null == searchResultVo) continue;
            List pageEsDtos = searchResultVo.getDocValues().stream().map(doc -> {
                PricePolicyEsDto policyEsDto = (PricePolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PricePolicyEsDto.class);
                if (Objects.equals(policyEsDto.getCustomerDimension(), 1) && CollectionUtil.isNotEmpty((Collection)policyEsDto.getCustomerAreaCodes())) {
                    List areaCodes = policyEsDto.getCustomerAreaCodes().stream().distinct().collect(Collectors.toList());
                    Collections.reverse(areaCodes);
                    logger.info("[\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u672b\u7aef\u8282\u70b9\u4f18\u5148\u7ea7]\uff0c\u653f\u7b56\uff1a{},\u6307\u5b9a\u533a\u57df,\u67e5\u8be2\u7236\u8282\u70b9\u5165\u53c2\uff1a{}", (Object)policyEsDto.getPolicyCode(), areaCodes);
                    List parentAreaCodeList = (List)RestResponseHelper.extractData((RestResponse)this.customerAreaQueryApi.queryLongestNodeByCodes(areaCodes));
                    parentAreaCodeList = parentAreaCodeList.stream().distinct().collect(Collectors.toList());
                    logger.info("[\u6307\u5b9a\u5ba2\u6237\u533a\u57df\u672b\u7aef\u8282\u70b9\u4f18\u5148\u7ea7]\uff0c\u6240\u6709\u7236\u8282\u70b9\uff08\u5305\u542b\u81ea\u8eab\uff09\uff1a{}", parentAreaCodeList);
                    policyEsDto.setParentAreaCodeList(parentAreaCodeList);
                }
                return policyEsDto;
            }).collect(Collectors.toList());
            result.addAll(pageEsDtos);
            int n = startIndex = ++page > 0 ? (page - 1) * pageSize : 0;
        } while (searchResultVo != null && !CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()) && searchResultVo.getDocValues().size() == pageSize);
        return result;
    }

    private void buildPolicyDataBoolQuery(BoolQueryBuilder policyDateBoolQuery, String policyDateStr) {
        policyDateBoolQuery.should().add(QueryBuilders.termQuery((String)"longTermValid", (int)1));
        BoolQueryBuilder dateRangeBoolQuery = QueryBuilders.boolQuery();
        dateRangeBoolQuery.must().add(QueryBuilders.rangeQuery((String)"effectiveTime").to((Object)policyDateStr, true));
        dateRangeBoolQuery.must().add(QueryBuilders.rangeQuery((String)"invalidTime").from((Object)policyDateStr, true));
        policyDateBoolQuery.should().add(dateRangeBoolQuery);
    }

    private void buildMutilItemBoolQuery(BoolQueryBuilder itemBoolQuery, List<ItemSkuExtRespDto> itemSkuListRespDto) {
        List skuIdList = itemSkuListRespDto.stream().map(e -> e.getId()).distinct().collect(Collectors.toList());
        List subTypeList = itemSkuListRespDto.stream().map(e -> e.getSubType()).distinct().collect(Collectors.toList());
        List brandIdList = itemSkuListRespDto.stream().map(e -> e.getBrandId()).distinct().collect(Collectors.toList());
        List dirIdList = itemSkuListRespDto.stream().map(e -> e.getDirId()).distinct().collect(Collectors.toList());
        subTypeList.add(-1);
        brandIdList.add(-1L);
        dirIdList.add(-1L);
        itemBoolQuery.should().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_ALL_ENUM.getType()));
        BoolQueryBuilder itemRangeBoolQuery = QueryBuilders.boolQuery();
        itemRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_RANGE_ENUM.getType()));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemSubTypes", subTypeList));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBackDirsWithSub", dirIdList));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBrandIds", brandIdList));
        itemBoolQuery.should().add(itemRangeBoolQuery);
        BoolQueryBuilder itemSpecialBoolQuery = QueryBuilders.boolQuery();
        itemSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()));
        NestedQueryBuilder skuIdNestQuery = QueryBuilders.nestedQuery((String)"itemList", (QueryBuilder)QueryBuilders.termsQuery((String)"itemList.skuId", skuIdList), (ScoreMode)ScoreMode.None);
        itemSpecialBoolQuery.must().add(skuIdNestQuery);
        itemBoolQuery.should().add(itemSpecialBoolQuery);
    }

    private void buildItemBoolQuery(BoolQueryBuilder itemBoolQuery, ItemSkuExtRespDto itemSkuListRespDto) {
        String skuId = String.valueOf(itemSkuListRespDto.getId());
        String subType = String.valueOf(itemSkuListRespDto.getSubType());
        String brandId = String.valueOf(itemSkuListRespDto.getBrandId());
        String dirId = String.valueOf(itemSkuListRespDto.getDirId());
        itemBoolQuery.should().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_ALL_ENUM.getType()));
        BoolQueryBuilder itemRangeBoolQuery = QueryBuilders.boolQuery();
        itemRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_RANGE_ENUM.getType()));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemSubTypes", (String[])new String[]{subType, "-1"}));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBackDirs", (String[])new String[]{dirId, "-1"}));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBrandIds", (String[])new String[]{brandId, "-1"}));
        itemRangeBoolQuery.mustNot().add(QueryBuilders.termsQuery((String)"itemExcludeSkuIds", (String[])new String[]{skuId}));
        itemBoolQuery.should().add(itemRangeBoolQuery);
        BoolQueryBuilder itemSpecialBoolQuery = QueryBuilders.boolQuery();
        itemSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()));
        NestedQueryBuilder skuIdNestQuery = QueryBuilders.nestedQuery((String)"itemList", (QueryBuilder)QueryBuilders.termsQuery((String)"itemList.skuId", (String[])new String[]{skuId}), (ScoreMode)ScoreMode.None);
        itemSpecialBoolQuery.must().add(skuIdNestQuery);
        itemBoolQuery.should().add(itemSpecialBoolQuery);
    }

    private void buildCustBoolQuery(BoolQueryBuilder custBoolQuery, CustomerRespDto customerRespDto) {
        String customerTypeId = String.valueOf(customerRespDto.getCustomerTypeId());
        List<Object> custAearcodes = customerRespDto.getRegionCodeList();
        custAearcodes = CollectionUtils.isEmpty((Collection)custAearcodes) ? Lists.newArrayList() : custAearcodes.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e)).collect(Collectors.toList());
        custAearcodes.add("-1");
        String customerId = String.valueOf(customerRespDto.getId());
        custBoolQuery.should().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()));
        BoolQueryBuilder custRangeBoolQuery = QueryBuilders.boolQuery();
        custRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerTypeIds", (String[])new String[]{customerTypeId, "-1"}));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerAreaCodesWithSub", custAearcodes));
        custRangeBoolQuery.mustNot().add(QueryBuilders.termsQuery((String)"customerExcludeCustIds", (String[])new String[]{customerId}));
        custBoolQuery.should().add(custRangeBoolQuery);
        BoolQueryBuilder custSpecialBoolQuery = QueryBuilders.boolQuery();
        custSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        custSpecialBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerSpecialCustIds", (String[])new String[]{customerId}));
        custBoolQuery.should().add(custSpecialBoolQuery);
    }

    @Override
    public BigDecimal getDefaultMatchPrice(ItemPolicyPriceRespDto policyDto, Integer num) {
        if (num == null) {
            num = 1;
        }
        BigDecimal acutualPrice = null;
        if (policyDto.getHasLadderPrice() && policyDto.getLadderPrices() != null && !policyDto.getLadderPrices().isEmpty()) {
            for (ItemPolicyPriceRespDto.LadderPrice ladderPrice : policyDto.getLadderPrices()) {
                Integer lower = ladderPrice.getLower() == null ? -1 : ladderPrice.getLower();
                Integer upper = ladderPrice.getUpper() == null ? Integer.MAX_VALUE : ladderPrice.getUpper();
                if (num < lower || num > upper) continue;
                acutualPrice = ladderPrice.getPrice();
                break;
            }
        }
        if (acutualPrice == null && policyDto.getHasDiscountPrice()) {
            acutualPrice = policyDto.getDiscountPrice();
        }
        if (acutualPrice == null) {
            acutualPrice = policyDto.getPrice();
        }
        return acutualPrice;
    }
}

