/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BaseExcelDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ExcelImportDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IImportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseImportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.RetailPriceImportVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class RetailPriceImportImpl
extends BaseImportImpl
implements IImportSevice<RetailPriceImportVo> {
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private CustomerHelper customerHelper;

    @Override
    public boolean needVerfiy() {
        return Boolean.TRUE;
    }

    @Override
    public ImportParams importParams() {
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerfiy(this.needVerfiy());
        return importParams;
    }

    @Override
    public Class<RetailPriceImportVo> pojoClass() {
        return RetailPriceImportVo.class;
    }

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.IMPORT_RETAIL_PRICE;
    }

    @Override
    public void importData(ExcelImportDto excelImportDto, BaseExcelDto baseExcelDto, List<RetailPriceImportVo> successList, List<RetailPriceImportVo> failList) {
        if (CollUtil.isNotEmpty(failList)) {
            baseExcelDto.setErrorMsgList(this.getErrorList(failList));
            return;
        }
        Long userOrgInfoId = this.customerHelper.getOrgId();
        Map<String, List<RetailPriceImportVo>> itemMap = successList.stream().collect(Collectors.groupingBy(RetailPriceImportVo::getItemCode));
        itemMap.forEach((itemCode, itemList) -> {
            if (itemList.size() > 1) {
                String err = itemList.stream().map(item -> this.serialNumberStr(item.getSerialNumber())).collect(Collectors.joining(",")) + "\u5546\u54c1\u7f16\u7801[" + itemCode + "]\u51fa\u73b0\u91cd\u590d";
                baseExcelDto.addErrorMsg(err);
            }
        });
        ArrayList itemCodeList = ListUtil.toList(itemMap.keySet());
        Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMapByItemCodeListAndShopId(itemCodeList, null, userOrgInfoId);
        if (CollUtil.isEmpty(skuQueryRespDtoMap)) {
            return;
        }
        for (RetailPriceImportVo importVo : successList) {
            this.buildSkuInfo(baseExcelDto, skuQueryRespDtoMap, importVo);
        }
        if (baseExcelDto.isImportStatus()) {
            baseExcelDto.setSuccessDataList(successList);
        }
    }

    private void buildSkuInfo(BaseExcelDto baseExcelDto, Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap, RetailPriceImportVo importVo) {
        String itemCode = importVo.getItemCode();
        ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(itemCode);
        if (itemSkuQueryRespDto == null || !Objects.equals(itemSkuQueryRespDto.getItemCode(), itemCode)) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "]\u4e0d\u5b58\u5728");
            return;
        }
        importVo.setGiftBox(Objects.isNull(itemSkuQueryRespDto.getGiftBox()) ? null : String.valueOf(itemSkuQueryRespDto.getGiftBox()));
        importVo.setBrandName(itemSkuQueryRespDto.getBrandName());
        importVo.setDirName(itemSkuQueryRespDto.getDirName());
        importVo.setItemName(itemSkuQueryRespDto.getItemName());
        importVo.setSkuAttr(itemSkuQueryRespDto.getSkuAttr());
        importVo.setShopId(itemSkuQueryRespDto.getShopId());
        importVo.setSubType(itemSkuQueryRespDto.getSubType());
        importVo.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
        importVo.setSkuId(itemSkuQueryRespDto.getSkuId());
        importVo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
        importVo.setExchangePrice(Objects.equals(importVo.getGiftBox(), "0") ? importVo.getExchangePrice() : null);
    }
}

