/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi;

import cn.afterturn.easypoi.excel.annotation.ExcelTarget;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.export.ExcelExportServer;
import cn.afterturn.easypoi.excel.export.styler.IExcelExportStyler;
import cn.afterturn.easypoi.exception.excel.ExcelExportException;
import cn.afterturn.easypoi.exception.excel.enums.ExcelExportEnum;
import cn.afterturn.easypoi.util.PoiExcelGraphDataUtil;
import cn.afterturn.easypoi.util.PoiPublicUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchExportServer
extends ExcelExportServer {
    private static final Logger log = LoggerFactory.getLogger(BatchExportServer.class);
    private Workbook workbook;
    private Sheet sheet;
    private List<ExcelExportEntity> excelParams;
    private ExportParams entity;
    private int titleHeight;
    private Drawing patriarch;
    private short rowHeight;
    private int index;

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void init(Workbook workbook, ExportParams entity, List<ExcelExportEntity> excelParams) {
        log.debug("ExcelBatchExportServer only support SXSSFWorkbook");
        entity.setType(ExcelType.XSSF);
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        this.entity = entity;
        this.type = entity.getType();
        this.createSheet(workbook, entity, excelParams);
        if (entity.getMaxNum() == 0) {
            entity.setMaxNum(1000000);
        }
        this.insertDataToSheet(workbook, entity, excelParams, null, this.sheet);
    }

    public void init(Workbook workbook, ExportParams entity, Class<?> pojoClass) {
        log.debug("ExcelBatchExportServer only support SXSSFWorkbook");
        entity.setType(ExcelType.XSSF);
        workbook = workbook == null ? new SXSSFWorkbook() : workbook;
        this.entity = entity;
        this.type = entity.getType();
        this.createSheet(workbook, entity, pojoClass);
        if (entity.getMaxNum() == 0) {
            entity.setMaxNum(1000000);
        }
        this.insertDataToSheet(workbook, entity, this.excelParams, null, this.sheet);
    }

    public void createSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> excelParams) {
        if (log.isDebugEnabled()) {
            log.debug("Excel export start ,class is {}", excelParams);
            log.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook == null || entity == null || excelParams == null) {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
        try {
            this.excelParams = excelParams;
            this.sortAllParams(excelParams);
            try {
                this.sheet = workbook.createSheet(entity.getSheetName());
            }
            catch (Exception e) {
                this.sheet = workbook.createSheet();
            }
        }
        catch (Exception e) {
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
        }
    }

    public void createSheet(Workbook workbook, ExportParams entity, Class<?> pojoClass) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Excel export start ,class is {}", pojoClass);
            LOGGER.debug("Excel version is {}", (Object)(entity.getType().equals((Object)ExcelType.HSSF) ? "03" : "07"));
        }
        if (workbook != null && entity != null && pojoClass != null) {
            try {
                this.excelParams = new ArrayList<ExcelExportEntity>();
                if (entity.isAddIndex()) {
                    this.excelParams.add(this.indexExcelEntity(entity));
                }
                Field[] fileds = PoiPublicUtil.getClassFields(pojoClass);
                ExcelTarget etarget = pojoClass.getAnnotation(ExcelTarget.class);
                String targetId = etarget == null ? null : etarget.value();
                this.getAllExcelField(entity.getExclusions(), targetId, fileds, this.excelParams, pojoClass, null, null);
                this.sortAllParams(this.excelParams);
                try {
                    this.sheet = workbook.createSheet(entity.getSheetName());
                }
                catch (Exception var8) {
                    this.sheet = workbook.createSheet();
                }
            }
            catch (Exception var9) {
                throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)var9);
            }
        } else {
            throw new ExcelExportException(ExcelExportEnum.PARAMETER_ERROR);
        }
    }

    public Workbook appendData(Collection<?> dataSet) {
        if (this.sheet.getLastRowNum() + dataSet.size() > this.entity.getMaxNum()) {
            this.sheet = this.workbook.createSheet();
            this.index = 0;
        }
        for (Object t : dataSet) {
            try {
                this.index += this.createCells(this.patriarch, this.index, t, this.excelParams, this.sheet, this.workbook, this.rowHeight);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, (Throwable)e);
            }
        }
        return this.workbook;
    }

    protected void insertDataToSheet(Workbook workbook, ExportParams entity, List<ExcelExportEntity> entityList, Collection<?> dataSet, Sheet sheet) {
        try {
            this.dataHanlder = entity.getDataHanlder();
            if (this.dataHanlder != null && this.dataHanlder.getNeedHandlerFields() != null) {
                this.needHanlderList = Arrays.asList(this.dataHanlder.getNeedHandlerFields());
            }
            this.setExcelExportStyler((IExcelExportStyler)entity.getStyle().getConstructor(Workbook.class).newInstance(workbook));
            this.patriarch = PoiExcelGraphDataUtil.getDrawingPatriarch((Sheet)sheet);
            ArrayList<ExcelExportEntity> excelParams = new ArrayList<ExcelExportEntity>();
            if (entity.isAddIndex()) {
                excelParams.add(this.indexExcelEntity(entity));
            }
            excelParams.addAll(entityList);
            this.sortAllParams(excelParams);
            this.titleHeight = this.index = entity.isCreateHeadRows() ? this.createHeaderAndTitle(entity, sheet, workbook, excelParams) : 0;
            this.setCellWith(excelParams, sheet);
            this.rowHeight = this.getRowHeight(excelParams);
            this.setCurrentIndex(1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ExcelExportException(ExcelExportEnum.EXPORT_ERROR, e.getCause());
        }
    }

    public static BatchExportServer getExcelBatchExportServer(Workbook workbook, ExportParams entity, List<ExcelExportEntity> excelParams) {
        BatchExportServer batchServer = new BatchExportServer();
        batchServer.init(workbook, entity, excelParams);
        return batchServer;
    }

    public static BatchExportServer getExcelBatchExportServer(Workbook workbook, ExportParams entity, Class<?> pojoClass) {
        BatchExportServer batchServer = new BatchExportServer();
        batchServer.init(workbook, entity, pojoClass);
        return batchServer;
    }

    public void closeExportBigExcel() {
        if (this.entity.getFreezeCol() != 0) {
            this.sheet.createFreezePane(this.entity.getFreezeCol(), 0, this.entity.getFreezeCol(), 0);
        }
        this.mergeCells(this.sheet, this.excelParams, this.titleHeight);
        this.addStatisticsRow(this.getExcelExportStyler().getStyles(null, 1, null, null, null), this.sheet);
    }
}

