/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.api.exception.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.service.ValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.dao.das.GuidingPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceTypeDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.GuidingPriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BasePriceValidateStrategy
implements ValidateStrategy {
    @Override
    public PriceAddOrModifyRespDto validate(PriceBeanReqDto priceBeanReqDto, Long id) {
        PriceAddOrModifyRespDto priceAddOrModifyRespDto = new PriceAddOrModifyRespDto();
        if (CollectionUtils.isNotEmpty((Collection)priceBeanReqDto.getPriceItemReqDtos())) {
            for (PriceItemModifyReqDto priceItemReqDto : priceBeanReqDto.getPriceItemReqDtos()) {
                if (!CollectionUtils.isEmpty((Collection)priceItemReqDto.getPriceTypeList())) continue;
                throw new BizException(PriceExceptionCode.PRICE_TYPE_LIST_IS_NULL.getCode(), PriceExceptionCode.PRICE_TYPE_LIST_IS_NULL.getMsg());
            }
        }
        this.validateBegin(priceBeanReqDto, id);
        return priceAddOrModifyRespDto;
    }

    @Override
    public List<PriceEo> getBasePriceEos(PriceBeanReqDto priceBeanReqDto) {
        PriceDas priceDas = (PriceDas)SpringBeanUtil.getBean(PriceDas.class);
        PriceEo queryPriceEo = new PriceEo();
        queryPriceEo.setCategoryCode(priceBeanReqDto.getCategoryCode());
        ArrayList querySqlFilter = Lists.newArrayList();
        querySqlFilter.add(SqlFilter.in((String)"status", (Object)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.WAIT_AUDIT.getCode(), PriceStatusEnum.WAIT_TAKE_EFFECT.getCode(), PriceStatusEnum.AUDIT_PASS.getCode()})));
        queryPriceEo.setSqlFilters((List)querySqlFilter);
        return priceDas.select((BaseEo)queryPriceEo);
    }

    @Override
    public void validateCustomer(List<PriceEo> priceEos, PriceBeanReqDto reqDto) {
        if (CollectionUtils.isNotEmpty(priceEos)) {
            this.validateItems(priceEos, reqDto);
        }
    }

    @Override
    public void validateItems(List<PriceEo> priceEos, PriceBeanReqDto reqDto) {
        List priceItemReqDtos = reqDto.getPriceItemReqDtos();
        if (CollectionUtils.isNotEmpty((Collection)priceItemReqDtos)) {
            List skuIds = priceItemReqDtos.stream().map(PriceItemModifyReqDto::getSkuId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(skuIds)) {
                priceEos.stream().forEach(bean -> {
                    PriceItemDas priceItemDas = (PriceItemDas)SpringBeanUtil.getBean(PriceItemDas.class);
                    PriceItemEo priceItemEo = new PriceItemEo();
                    priceItemEo.setPriceId(bean.getId());
                    List priceItemEos = priceItemDas.select((BaseEo)priceItemEo);
                    if (CollectionUtils.isNotEmpty((Collection)priceItemEos)) {
                        List tempSkuIds = priceItemEos.stream().map(StdPriceItemEo::getSkuId).collect(Collectors.toList());
                        List<Long> priceItemIds = priceItemEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                        if (!Collections.disjoint(skuIds, tempSkuIds)) {
                            this.validateType(priceItemIds, reqDto, bean.getName());
                        }
                    }
                });
            }
            IContext context = (IContext)SpringBeanUtil.getBean(IContext.class);
            PriceTypeDas priceTypeDas = (PriceTypeDas)SpringBeanUtil.getBean(PriceTypeDas.class);
            List basePriceTypeDtoList = priceTypeDas.queryPriceTypeByCategoryCode(CategoryCodeEnum.BASE.getCode(), context.tenantId(), context.instanceId());
            if (!basePriceTypeDtoList.isEmpty()) {
                List needPriceTypeIdList = basePriceTypeDtoList.stream().map(PriceTypeDto::getTypeId).collect(Collectors.toList());
                priceItemReqDtos.forEach(priceItemModifyReqDto -> {
                    if (priceItemModifyReqDto.getPriceTypeList().size() != basePriceTypeDtoList.size()) {
                        throw new BizException("\u8bf7\u8865\u5145\u5b8c\u6574\u5546\u54c1\u7684\u6240\u6709\u57fa\u7840\u4ef7\u683c~");
                    }
                    List priceTypeIdList = priceItemModifyReqDto.getPriceTypeList().stream().map(PriceTypeDto::getTypeId).collect(Collectors.toList());
                    if (!priceTypeIdList.containsAll(needPriceTypeIdList)) {
                        throw new BizException("\u8bf7\u8865\u5145\u5b8c\u6574\u5546\u54c1\u7684\u6240\u6709\u57fa\u7840\u4ef7\u683c~");
                    }
                });
            }
        }
    }

    private void validateType(List<Long> priceItemIds, PriceBeanReqDto reqDto, String priceName) {
        List priceTypeList;
        List typeIds;
        List priceItemReqDtos = reqDto.getPriceItemReqDtos();
        if (CollectionUtils.isNotEmpty((Collection)priceItemReqDtos) && CollectionUtils.isNotEmpty(typeIds = (priceTypeList = ((PriceItemModifyReqDto)priceItemReqDtos.get(0)).getPriceTypeList()).stream().map(PriceTypeDto::getTypeId).collect(Collectors.toList()))) {
            GuidingPriceDas guidingPriceDas = (GuidingPriceDas)SpringBeanUtil.getBean(GuidingPriceDas.class);
            GuidingPriceEo guidingPriceEo = new GuidingPriceEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"price_item_id", priceItemIds));
            sqlFilters.add(SqlFilter.in((String)"price_type_id", typeIds));
            guidingPriceEo.setSqlFilters(sqlFilters);
            List guidingPriceEos = guidingPriceDas.select((BaseEo)guidingPriceEo);
            if (CollectionUtils.isNotEmpty((Collection)guidingPriceEos)) {
                throw new BizException(this.getExceptionMsg(priceName));
            }
        }
    }

    @Override
    public String getExceptionMsg(String priceName) {
        if (StringUtils.isNotEmpty((CharSequence)priceName)) {
            return "\u540c\u4e00\u65f6\u95f4\u3001\u540c\u4e00\u5546\u54c1\u3001\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u5f85\u5ba1\u6838/\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\uff08\u57fa\u7840\u4ef7\uff09\u4ef7\u683c\uff0c\u51b2\u7a81\u4ef7\u683c\u653f\u7b56\u3010" + priceName + "\u3011";
        }
        return "\u540c\u4e00\u65f6\u95f4\u3001\u540c\u4e00\u5546\u54c1\u3001\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u5f85\u5ba1\u6838/\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\uff08\u57fa\u7840\u4ef7\uff09\u4ef7\u683c";
    }
}

