/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBeanReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceAddOrModifyRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.ValidateStrategy;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InternalSettlementPriceValidateStrategy
implements ValidateStrategy {
    @Override
    public PriceAddOrModifyRespDto validate(PriceBeanReqDto priceBeanReqDto, Long id) {
        PriceAddOrModifyRespDto priceAddOrModifyRespDto = new PriceAddOrModifyRespDto();
        List<Object> priceEos = this.getBasePriceEos(priceBeanReqDto);
        if (CollectionUtils.isNotEmpty(priceEos)) {
            Date effectiveTime = priceBeanReqDto.getEffectiveTime();
            Date invalidTime = priceBeanReqDto.getInvalidTime();
            if (null == invalidTime) {
                invalidTime = END_OF_TIME.toDate();
            }
            priceEos = this.filterSameCodePrice(priceEos, priceBeanReqDto);
            if (null == id) {
                if (CollectionUtils.isNotEmpty(priceEos = this.dealWithPrices(priceEos, effectiveTime, invalidTime))) {
                    this.validatePriceName(priceEos, priceBeanReqDto);
                    this.validateItems(priceEos, priceBeanReqDto);
                }
            } else if (CollectionUtils.isNotEmpty(priceEos = priceEos.stream().filter(bean -> !bean.getId().equals(id)).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(priceEos = this.dealWithPrices(priceEos, effectiveTime, invalidTime))) {
                this.validatePriceName(priceEos, priceBeanReqDto);
                this.validateItems(priceEos, priceBeanReqDto);
            }
        }
        return priceAddOrModifyRespDto;
    }

    @Override
    public List<PriceEo> getBasePriceEos(PriceBeanReqDto priceBeanReqDto) {
        PriceDas priceDas = (PriceDas)SpringBeanUtil.getBean(PriceDas.class);
        PriceEo queryPriceEo = new PriceEo();
        queryPriceEo.setTypeId(priceBeanReqDto.getTypeId());
        queryPriceEo.setCategoryCode(priceBeanReqDto.getCategoryCode());
        queryPriceEo.setBuyerId(priceBeanReqDto.getBuyerId());
        queryPriceEo.setSellerId(priceBeanReqDto.getSellerId());
        ArrayList querySqlFilter = Lists.newArrayList();
        querySqlFilter.add(SqlFilter.in((String)"status", (Object)Lists.newArrayList((Object[])new String[]{PriceStatusEnum.WAIT_AUDIT.getCode(), PriceStatusEnum.WAIT_TAKE_EFFECT.getCode(), PriceStatusEnum.AUDIT_PASS.getCode()})));
        queryPriceEo.setSqlFilters((List)querySqlFilter);
        return priceDas.select((BaseEo)queryPriceEo);
    }

    @Override
    public String getExceptionMsg(String priceName) {
        if (StringUtils.isNotEmpty((CharSequence)priceName)) {
            return "\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u3001\u540c\u4e00\u65f6\u95f4\u3001\u540c\u4e00\u5546\u54c1\u3001\u540c\u4e00\u4e70\u65b9&\u5356\u65b9\u3001\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u5f85\u5ba1\u6838/\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\uff08\u5185\u90e8\u7ed3\u7b97\u4ef7\uff09\u4ef7\u683c\uff0c\u51b2\u7a81\u4ef7\u683c\u653f\u7b56\u3010" + priceName + "\u3011";
        }
        return "\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u3001\u540c\u4e00\u65f6\u95f4\u3001\u540c\u4e00\u5546\u54c1\u3001\u540c\u4e00\u4e70\u65b9&\u5356\u65b9\u3001\u540c\u4e00\u4ef7\u683c\u7c7b\u578b\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u5f85\u5ba1\u6838/\u751f\u6548\u4e2d/\u5f85\u751f\u6548\u7684\uff08\u5185\u90e8\u7ed3\u7b97\u4ef7\uff09\u4ef7\u683c";
    }
}

