/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemConditionModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceItemConditionService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceItemConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceItemConditionEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceItemConditionServiceImpl
implements IPriceItemConditionService {
    private static final Logger logger = LoggerFactory.getLogger(PriceItemConditionServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private PriceItemConditionDas priceItemConditionDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceItemCondition(PriceItemConditionAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceItemConditionEo);
        priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(priceItemConditionEo.getInstanceId())) {
            priceItemConditionEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(priceItemConditionEo.getTenantId())) {
            priceItemConditionEo.setTenantId(this.context.tenantId());
        }
        this.priceItemConditionDas.insert((BaseEo)priceItemConditionEo);
        return priceItemConditionEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchPriceItemCondition(List<PriceItemConditionAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList priceItemConditionEoList = ListUtil.toList((Object[])new PriceItemConditionEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)priceItemConditionEoList, PriceItemConditionEo.class);
        if (CollUtil.isEmpty((Collection)priceItemConditionEoList)) {
            return ListUtil.empty();
        }
        for (PriceItemConditionEo priceItemConditionEo : priceItemConditionEoList) {
            priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(priceItemConditionEo.getInstanceId())) {
                priceItemConditionEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(priceItemConditionEo.getTenantId())) continue;
            priceItemConditionEo.setTenantId(this.context.tenantId());
        }
        this.priceItemConditionDas.insertBatch((List)priceItemConditionEoList);
        return priceItemConditionEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceItemCondition(PriceItemConditionModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        PriceItemConditionEo priceItemConditionEo = (PriceItemConditionEo)this.priceItemConditionDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceItemConditionEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceItemConditionEo);
        this.priceItemConditionDas.update((BaseEo)priceItemConditionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceItemConditionById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        PriceItemConditionEo priceItemConditionEo = (PriceItemConditionEo)this.priceItemConditionDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceItemConditionEo)) {
            return;
        }
        this.priceItemConditionDas.logicDeleteById(priceItemConditionEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceItemConditionByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.priceItemConditionDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<PriceItemConditionRespDto> queryByPage(PriceItemConditionQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<PriceItemConditionEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.priceItemConditionDas, queryWrapper, PriceItemConditionRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<PriceItemConditionEo> getQueryWrapper(PriceItemConditionQueryReqDto reqDto) {
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceItemConditionEo);
        priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceItemConditionEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSkuIdsList())) {
            queryWrapper.in(StdPriceItemConditionEo::getSkuIds, (Collection)reqDto.getSkuIdsList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemIdsList())) {
            queryWrapper.in(StdPriceItemConditionEo::getItemIds, (Collection)reqDto.getItemIdsList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateTypeList())) {
            queryWrapper.in(StdPriceItemConditionEo::getRelateType, (Collection)reqDto.getRelateTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getRelateIdList())) {
            queryWrapper.in(StdPriceItemConditionEo::getRelateId, (Collection)reqDto.getRelateIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdPriceItemConditionEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        return queryWrapper;
    }

    @Override
    public List<PriceItemConditionRespDto> queryByList(PriceItemConditionQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        return this.priceItemConditionDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (PriceItemConditionRespDto)item.toDto(PriceItemConditionRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceItemConditionRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        PriceItemConditionEo priceItemConditionEo = (PriceItemConditionEo)this.priceItemConditionDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceItemConditionEo)) {
            return null;
        }
        PriceItemConditionRespDto priceItemConditionRespDto = (PriceItemConditionRespDto)priceItemConditionEo.toDto(PriceItemConditionRespDto.class);
        return priceItemConditionRespDto;
    }

    @Override
    public List<PriceItemConditionRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return null;
        }
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceItemConditionEo).in(BaseEo::getId, idList);
        List priceItemConditionEoList = this.priceItemConditionDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceItemConditionEoList.stream().map(item -> (PriceItemConditionRespDto)item.toDto(PriceItemConditionRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceItemConditionRespDto queryByRelateIdAndType(Long relateId, String relateType) {
        if (relateId == null) {
            return null;
        }
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        priceItemConditionEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        priceItemConditionEo.setRelateId(relateId);
        priceItemConditionEo.setRelateType(relateType);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceItemConditionEo);
        PriceItemConditionEo result = (PriceItemConditionEo)this.priceItemConditionDas.getMapper().selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(result)) {
            return null;
        }
        PriceItemConditionRespDto priceItemConditionRespDto = (PriceItemConditionRespDto)result.toDto(PriceItemConditionRespDto.class);
        priceItemConditionRespDto.setItemTypes((List)(StringUtils.isNotBlank((CharSequence)result.getItemTypes()) ? Arrays.asList(result.getItemTypes().split(",")) : Lists.newArrayList()));
        priceItemConditionRespDto.setItemBackDirIds((List)(StringUtils.isNotBlank((CharSequence)result.getItemBackDirIds()) ? Arrays.asList(result.getItemBackDirIds().split(",")) : Lists.newArrayList()));
        priceItemConditionRespDto.setItemBrandIds((List)(StringUtils.isNotBlank((CharSequence)result.getItemBrandIds()) ? Arrays.asList(result.getItemBrandIds().split(",")) : Lists.newArrayList()));
        return priceItemConditionRespDto;
    }

    @Override
    public Map<Long, PriceItemConditionRespDto> getPriceItemConditionMap(RelateTypeEnum relateTypeEnum, List<Long> relateIdList) {
        if (Objects.isNull(relateTypeEnum) || CollUtil.isEmpty(relateIdList)) {
            return MapUtil.empty();
        }
        PriceItemConditionEo priceItemConditionEo = new PriceItemConditionEo();
        priceItemConditionEo.setRelateType(relateTypeEnum.getType());
        LambdaQueryWrapper<PriceItemConditionEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(priceItemConditionEo);
        queryWrapper.in(StdPriceItemConditionEo::getRelateId, relateIdList);
        List customerConditionEos = this.priceItemConditionDas.getMapper().selectList(queryWrapper);
        return customerConditionEos.stream().map(item -> {
            PriceItemConditionRespDto respDto = new PriceItemConditionRespDto();
            respDto.setSkuIds(StrUtil.isBlank((CharSequence)item.getSkuIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getSkuIds().split(",")));
            respDto.setSkuIdNum(Integer.valueOf(respDto.getSkuIds().size()));
            respDto.setItemBrandIds(StrUtil.isBlank((CharSequence)item.getItemBrandIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getItemBrandIds().split(",")));
            respDto.setItemBackDirIdNum(Integer.valueOf(respDto.getItemBrandIds().size()));
            respDto.setItemTypes(StrUtil.isBlank((CharSequence)item.getItemTypes()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getItemTypes().split(",")));
            respDto.setItemTypeNum(Integer.valueOf(respDto.getItemTypes().size()));
            respDto.setItemBackDirIds(StrUtil.isBlank((CharSequence)item.getItemBackDirIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getItemBackDirIds().split(",")));
            respDto.setItemBackDirIdNum(Integer.valueOf(respDto.getItemBackDirIds().size()));
            return respDto;
        }).collect(Collectors.toMap(PriceItemConditionRespDto::getRelateId, Function.identity(), (o1, o2) -> o2));
    }
}

