/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.SyncPriceDataReqDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CommonHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.ISellerSkuPriceService;
import com.dtyunxi.yundt.cube.center.price.dao.das.SellerSkuPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.SellerSkuPriceEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerSkuPriceServiceImpl
implements ISellerSkuPriceService {
    private static final Logger log = LoggerFactory.getLogger(SellerSkuPriceServiceImpl.class);
    private static final int INDEX = 0;
    private static final int SECONDS = 120;
    private static final String SYNC_DATA_KEY = "SYNC_DATA";
    @Resource
    private CommonHelper commonHelper;
    @Resource
    private SellerSkuPriceDas sellerSkuPriceDas;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSellerSkuPrice(SyncPriceDataReqDto syncPriceDataReqDto) {
        if (Objects.isNull(syncPriceDataReqDto)) {
            log.warn("[\u540c\u6b65\u6570\u636e] >>> \u65e0\u6548\u7684\u540c\u6b65\u6570\u636e\uff0c\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        String supplierId = syncPriceDataReqDto.getSupplierId();
        String applierId = syncPriceDataReqDto.getApplierId();
        String easNo = syncPriceDataReqDto.getEasNo();
        BigDecimal basePrice = syncPriceDataReqDto.getBasePrice();
        BigDecimal resultPrice = syncPriceDataReqDto.getResultPrice();
        if (StrUtil.isBlank((CharSequence)supplierId) || StrUtil.isBlank((CharSequence)applierId) || StrUtil.isBlank((CharSequence)easNo) || Objects.isNull(basePrice) || Objects.isNull(resultPrice)) {
            log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0c\u51fa\u73b0\u7a7a\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff1a{}", (Object)JSON.toJSONString((Object)syncPriceDataReqDto));
            return;
        }
        String key = "SYNC_DATA:" + supplierId + ":" + applierId + ":" + easNo;
        this.commonHelper.lock(key, 120, k -> {
            SellerSkuPriceEo sellerSkuPriceEo = new SellerSkuPriceEo();
            sellerSkuPriceEo.setEasNo(easNo);
            sellerSkuPriceEo.setSupplierId(supplierId);
            sellerSkuPriceEo.setThirdPartyId(applierId);
            sellerSkuPriceEo = (SellerSkuPriceEo)this.sellerSkuPriceDas.selectOne((BaseEo)sellerSkuPriceEo);
            if (Objects.nonNull(sellerSkuPriceEo)) {
                sellerSkuPriceEo.setSyncNumber(Integer.valueOf(sellerSkuPriceEo.getSyncNumber() + 1));
                sellerSkuPriceEo.setSupplyPrice(resultPrice);
                sellerSkuPriceEo.setRetailPrice(basePrice);
                this.sellerSkuPriceDas.update((BaseEo)sellerSkuPriceEo);
                return;
            }
            List orgList = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.queryInfoByCodeList((List)ListUtil.toList((Object[])new String[]{supplierId})));
            if (CollUtil.isEmpty((Collection)orgList)) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0csupplierId[{}]\u65e0\u6cd5\u627e\u5230\u7ec4\u7ec7\u4fe1\u606f", (Object)supplierId);
                return;
            }
            Long orgId = ((OrganizationDto)orgList.get(0)).getId();
            List customerList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds((List)ListUtil.toList((Object[])new String[]{applierId})));
            if (CollUtil.isEmpty((Collection)customerList)) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0capplierId[{}]\u65e0\u6cd5\u627e\u5230\u5ba2\u6237\u4fe1\u606f", (Object)applierId);
                return;
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerList.get(0);
            List shopLit = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId));
            if (CollUtil.isEmpty((Collection)shopLit)) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0corgId[{}]\u65e0\u6cd5\u627e\u5230\u5e97\u94fa\u4fe1\u606f", (Object)orgId);
                return;
            }
            ShopBaseDto shopBaseDto = (ShopBaseDto)shopLit.get(0);
            CustomerRespDto dealerCustomerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByOrgInfoId(orgId));
            if (Objects.isNull(dealerCustomerRespDto)) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0corgId[{}]\u65e0\u6cd5\u627e\u5230\u5927B\u5ba2\u6237\u4fe1\u606f", (Object)orgId);
                return;
            }
            ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
            itemSkuQueryReqDto.setItemLongCode(easNo);
            PageInfo skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(1)));
            List skuLit = skuPage.getList();
            if (CollUtil.isEmpty((Collection)skuLit)) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u672c\u6b21\u540c\u6b65\u6570\u636e\u6709\u95ee\u9898\uff0ceasNo[{}]\u65e0\u6cd5\u627e\u5230sku\u4fe1\u606f", (Object)easNo);
                return;
            }
            ItemSkuQueryRespDto itemSkuQueryRespDto = (ItemSkuQueryRespDto)skuLit.get(0);
            sellerSkuPriceEo = new SellerSkuPriceEo();
            sellerSkuPriceEo.setRetailPrice(basePrice);
            sellerSkuPriceEo.setSkuId(itemSkuQueryRespDto.getSkuId());
            sellerSkuPriceEo.setSupplyPrice(resultPrice);
            sellerSkuPriceEo.setCustomerId(customerRespDto.getId());
            sellerSkuPriceEo.setCustomerName(customerRespDto.getName());
            sellerSkuPriceEo.setItemId(itemSkuQueryRespDto.getItemId());
            sellerSkuPriceEo.setItemOrgId(itemSkuQueryRespDto.getItemOrgId());
            sellerSkuPriceEo.setEasNo(easNo);
            sellerSkuPriceEo.setShopId(shopBaseDto.getId());
            sellerSkuPriceEo.setShopName(shopBaseDto.getName());
            sellerSkuPriceEo.setDealerCustomerId(dealerCustomerRespDto.getId());
            sellerSkuPriceEo.setDealerOrgId(dealerCustomerRespDto.getOrgInfoId());
            sellerSkuPriceEo.setSupplierId(supplierId);
            sellerSkuPriceEo.setThirdPartyId(applierId);
            sellerSkuPriceEo.setSyncNumber(Integer.valueOf(1));
            this.sellerSkuPriceDas.insert((BaseEo)sellerSkuPriceEo);
        });
    }
}

