/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.task;

import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditHandler;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.TaskInfoDto;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="prototype")
@Component(value="priceTaskService")
public class PriceTaskService
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(PriceTaskService.class);
    @Resource
    private AuditHandler auditHandler;

    public void before(TaskMsg taskMsg) {
        log.info("[\u6267\u884c\u4efb\u52a1] >>> \u5f00\u59cb\u6267\u884c\u4efb\u52a1[{}]\uff0c\u53c2\u6570\uff1a{}", (Object)taskMsg.getScheduleInstName(), (Object)taskMsg.getContent());
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            String content = taskMsg.getContent();
            TaskInfoDto taskInfoDto = (TaskInfoDto)JSON.parseObject((String)content, TaskInfoDto.class);
            this.auditHandler.syncData(taskInfoDto.getRelateType(), taskInfoDto.getRelateId(), taskMsg.getTaskId());
        }
        catch (Exception e) {
            log.error("[\u6267\u884c\u4efb\u52a1] >>> \u6267\u884c\u4efb\u52a1\u5931\u8d25\uff0ctaskMsg\uff1a{}", (Object)JSON.toJsonString((Object)taskMsg), (Object)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void after(TaskMsg taskMsg) {
        log.info("[\u6267\u884c\u4efb\u52a1] >>> \u7ed3\u675f\u6267\u884c\u4efb\u52a1[{}]", (Object)taskMsg.getScheduleInstName());
    }
}

