/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SyncStatusEnum;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditHandler;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.SyncTaskInfoDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.TaskInfoDto;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Service;

@Service
public class SyncPriceTaskService {
    private static final Logger log = LoggerFactory.getLogger(SyncPriceTaskService.class);
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;
    @Resource
    private AuditHandler auditHandler;
    @Resource
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code:CENTER_PRICE}")
    private String appCode;
    @Value(value="${price.task.rule:LOCAL}")
    private String rule;
    private final Map<Long, SyncTaskInfoDto<BasePriceApplyEo>> taskMap = MapUtil.newConcurrentHashMap();

    public List<BasePriceApplyEo> findNotSyncApplyList() {
        BasePriceApplyEo basePriceApplyEo = BasePriceApplyEo.newInstance();
        basePriceApplyEo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        basePriceApplyEo.setSyncStatus(SyncStatusEnum.NOT_SYNC.getCode());
        LambdaQueryWrapper<BasePriceApplyEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(basePriceApplyEo);
        queryWrapper.gt(StdBasePriceApplyEo::getEffectTime, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        queryWrapper.orderByAsc(StdBasePriceApplyEo::getEffectTime);
        return this.basePriceApplyDas.getMapper().selectList(queryWrapper);
    }

    public boolean isLocal() {
        if (Objects.equals("SCHEDULER", this.rule)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void newTask(BasePriceApplyEo basePriceApplyEo) {
        Long applyId = basePriceApplyEo.getId();
        Date effectTime = basePriceApplyEo.getEffectTime();
        if (Objects.isNull(effectTime)) {
            return;
        }
        if (effectTime.getTime() <= System.currentTimeMillis()) {
            this.auditHandler.syncData(RelateTypeEnum.BASE_PRICE_APPLY.getType(), applyId, null);
            return;
        }
        if (!this.isLocal()) {
            log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u901a\u8fc7\u4efb\u52a1\u8c03\u5ea6\u4e2d\u5fc3\u521b\u5efa\u4efb\u52a1");
            this.scheduler(basePriceApplyEo);
            return;
        }
        log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u901a\u8fc7\u672c\u5730\u4efb\u52a1\u521b\u5efa\u4efb\u52a1");
        String taskTime = DateUtil.format((Date)effectTime, (String)"yyyy-MM-dd HH:mm:ss");
        if (this.taskMap.containsKey(applyId)) {
            SyncTaskInfoDto<BasePriceApplyEo> taskInfoDto = this.taskMap.get(applyId);
            if (Objects.equals(taskTime, taskInfoDto.getSyncTime())) {
                return;
            }
            taskInfoDto.getScheduledFuture().cancel(Boolean.TRUE);
        }
        log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u7533\u8bf7\u5355[{}]\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\uff0c\u6267\u884c\u65f6\u95f4[{}]", (Object)applyId, (Object)taskTime);
        ScheduledFuture schedule = this.threadPoolTaskScheduler.schedule(() -> this.runTask(applyId), effectTime);
        SyncTaskInfoDto<BasePriceApplyEo> taskInfo = new SyncTaskInfoDto<BasePriceApplyEo>();
        taskInfo.setData(basePriceApplyEo);
        taskInfo.setSyncTime(taskTime);
        taskInfo.setScheduledFuture(schedule);
        this.taskMap.put(applyId, taskInfo);
    }

    public void scheduler(BasePriceApplyEo basePriceApplyEo) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode("priceTaskService");
        dto.setBizName("\u7533\u8bf7\u5355\u81ea\u52a8\u540c\u6b65\u4efb\u52a1");
        TaskInfoDto taskInfoDto = new TaskInfoDto();
        taskInfoDto.setRelateId(basePriceApplyEo.getId());
        taskInfoDto.setRelateType(RelateTypeEnum.BASE_PRICE_APPLY.getType());
        dto.setParams(JSON.toJsonString((Object)taskInfoDto));
        dto.setScheduleExpression(DateUtil.format((Date)basePriceApplyEo.getEffectTime(), (String)"ss mm HH dd MM ? yyyy"));
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc(basePriceApplyEo.getApplyName() + "-" + basePriceApplyEo.getApplyCode());
        dto.setTaskName("\u7533\u8bf7\u5355\uff1a" + basePriceApplyEo.getApplyName() + ",\u7533\u8bf7\u5355ID:" + basePriceApplyEo.getId());
        dto.setInstanceId(basePriceApplyEo.getInstanceId());
        dto.setTenantId(basePriceApplyEo.getTenantId());
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        log.info("[\u4e1a\u52a1\u5ba1\u6838] >>> \u7533\u8bf7\u5355[{}]\u5ba1\u6838\u901a\u8fc7\uff0c\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1[{}]\u6267\u884c\u6570\u636e\u540c\u6b65\uff0c\u6267\u884c\u65f6\u95f4[{}]\uff0c\u4efb\u52a1id[{}]", new Object[]{basePriceApplyEo.getApplyCode(), basePriceApplyEo.getApplyName(), dto.getScheduleExpression(), addResult.getData()});
        taskInfoDto.setNote("\u7b49\u5f85\u5b9a\u65f6\u4efb\u52a1\u6267\u884c");
        taskInfoDto.setCount(0);
        taskInfoDto.setTaskId((Long)addResult.getData());
        basePriceApplyEo.setExtension(JSON.toJsonString((Object)taskInfoDto));
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
    }

    public void runTask(Long applyId) {
        log.info("[\u5b9a\u65f6\u4efb\u52a1] >>> \u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u7533\u8bf7\u5355[{}]", (Object)applyId);
        this.auditHandler.syncData(RelateTypeEnum.BASE_PRICE_APPLY.getType(), applyId, null);
        if (!this.taskMap.containsKey(applyId)) {
            return;
        }
        this.taskMap.get(applyId).getScheduledFuture().cancel(Boolean.TRUE);
        this.taskMap.remove(applyId);
    }
}

