/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class AssertUtils {
    private AssertUtils() {
    }

    public static <E extends RuntimeException> void exception(E runtimeException) {
        throw runtimeException;
    }

    public static void exception(String errorMsgTemplate, Object ... params) {
        throw new IllegalArgumentException(StrUtil.format((CharSequence)errorMsgTemplate, (Object[])params));
    }

    public static void exception(IExceptionCode exp) {
        BizExceptionHelper.throwBizException((IExceptionCode)exp);
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) {
        if (!expression) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isTrue(boolean expression, IExceptionCode exp) {
        if (!expression) {
            AssertUtils.exception(exp);
        }
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) {
        if (expression) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isFalse(boolean expression, IExceptionCode exp) {
        if (expression) {
            AssertUtils.exception(exp);
        }
    }

    public static void isNull(Object o, String errorMsgTemplate, Object ... params) {
        if (Objects.nonNull(o)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isNull(Object o, IExceptionCode exp) {
        if (Objects.nonNull(o)) {
            AssertUtils.exception(exp);
        }
    }

    public static <R> R isNull(Object o, IExceptionCode exp, Function<Object, R> function) {
        AssertUtils.isNull(o, exp);
        return function.apply(o);
    }

    public static void isNonNull(Object o, String errorMsgTemplate, Object ... params) {
        if (Objects.isNull(o)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isNonNull(Object o, IExceptionCode exp) {
        if (Objects.isNull(o)) {
            AssertUtils.exception(exp);
        }
    }

    public static <R> R isNonNull(Object o, IExceptionCode exp, Function<Object, R> function) {
        AssertUtils.isNonNull(o, exp);
        return function.apply(o);
    }

    public static void isNotBlank(String str, String errorMsgTemplate, Object ... params) {
        if (StrUtil.isBlank((CharSequence)str)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isNotBlank(String str, IExceptionCode exp) {
        if (StrUtil.isBlank((CharSequence)str)) {
            AssertUtils.exception(exp);
        }
    }

    public static <R> R isNotBlank(String str, IExceptionCode exp, Function<String, R> function) {
        AssertUtils.isNotBlank(str, exp);
        return function.apply(str);
    }

    public static void isBlank(String str, String errorMsgTemplate, Object ... params) {
        if (StrUtil.isNotBlank((CharSequence)str)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static void isBlank(String str, IExceptionCode exp) {
        if (StrUtil.isNotBlank((CharSequence)str)) {
            AssertUtils.exception(exp);
        }
    }

    public static <R> R isBlank(String str, IExceptionCode exp, Function<String, R> function) {
        AssertUtils.isBlank(str, exp);
        return function.apply(str);
    }

    public static <E, T extends Iterable<E>> void isNotEmpty(T collection, String errorMsgTemplate, Object ... params) {
        if (CollUtil.isEmpty(collection)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static <E, T extends Iterable<E>> void isNotEmpty(T collection, IExceptionCode exp) {
        if (CollUtil.isEmpty(collection)) {
            AssertUtils.exception(exp);
        }
    }

    public static <E, T extends Iterable<E>, R> R isNotEmpty(T collection, IExceptionCode exp, Function<T, R> function) {
        AssertUtils.isNotEmpty(collection, exp);
        return function.apply(collection);
    }

    public static <K, V, T extends Map<K, V>> void isNotEmpty(T map, String errorMsgTemplate, Object ... params) {
        if (CollUtil.isEmpty(map)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static <K, V, T extends Map<K, V>> void isNotEmpty(T map, IExceptionCode exp) {
        if (CollUtil.isEmpty(map)) {
            AssertUtils.exception(exp);
        }
    }

    public static <K, V, T extends Map<K, V>, R> R isNotEmpty(T map, IExceptionCode exp, Function<T, R> function) {
        AssertUtils.isNotEmpty(map, exp);
        return function.apply(map);
    }

    public static <T> void isNotEmpty(T[] array, String errorMsgTemplate, Object ... params) {
        if (ArrayUtil.isEmpty((Object[])array)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static <T> void isNotEmpty(T[] array, IExceptionCode exp) {
        if (ArrayUtil.isEmpty((Object[])array)) {
            AssertUtils.exception(exp);
        }
    }

    public static <T, R> R isNotEmpty(T[] array, IExceptionCode exp, Function<T[], R> function) {
        AssertUtils.isNotEmpty(array, exp);
        return function.apply((T[][])array);
    }

    public static <E, T extends Iterable<E>> void isEmpty(T collection, String errorMsgTemplate, Object ... params) {
        if (CollUtil.isNotEmpty(collection)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static <E, T extends Iterable<E>> void isEmpty(T collection, IExceptionCode exp) {
        if (CollUtil.isNotEmpty(collection)) {
            AssertUtils.exception(exp);
        }
    }

    public static <E, T extends Iterable<E>, R> R isEmpty(T collection, IExceptionCode exp, Function<T, R> function) {
        AssertUtils.isEmpty(collection, exp);
        return function.apply(collection);
    }

    public static <K, V, T extends Map<K, V>> void isEmpty(T map, String errorMsgTemplate, Object ... params) {
        if (CollUtil.isNotEmpty(map)) {
            AssertUtils.exception(errorMsgTemplate, params);
        }
    }

    public static <K, V, T extends Map<K, V>> void isEmpty(T map, IExceptionCode exp) {
        if (CollUtil.isNotEmpty(map)) {
            AssertUtils.exception(exp);
        }
    }

    public static <K, V, T extends Map<K, V>, R> R isEmpty(T map, IExceptionCode exp, Function<T, R> function) {
        AssertUtils.isEmpty(map, exp);
        return function.apply(map);
    }
}

