/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.vo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SkuPriceVo {
    private Map<String, Map<Long, BigDecimal>> skuPriceMap = MapUtil.newHashMap();
    private Map<String, Date> skuUpdateTimeMap = MapUtil.newHashMap();
    private List<Long> skuIdList;
    private List<Long> shopIdList;

    public Map<String, Map<Long, BigDecimal>> getSkuPriceMap() {
        return this.skuPriceMap;
    }

    public void setSkuPriceMap(Map<String, Map<Long, BigDecimal>> skuPriceMap) {
        this.skuPriceMap = skuPriceMap;
    }

    public List<Long> getSkuIdList() {
        return this.skuIdList;
    }

    public void setSkuIdList(List<Long> skuIdList) {
        this.skuIdList = skuIdList;
    }

    public List<Long> getShopIdList() {
        return CollUtil.isEmpty(this.shopIdList) ? this.shopIdList : this.shopIdList.stream().distinct().collect(Collectors.toList());
    }

    public void setShopIdList(List<Long> shopIdList) {
        this.shopIdList = shopIdList;
    }

    public void addInfo(Long shopId, Long skuId, Map<Long, BigDecimal> skuMap) {
        if (Objects.nonNull(shopId)) {
            if (Objects.isNull(this.shopIdList)) {
                this.setShopIdList(ListUtil.toList((Object[])new Long[0]));
            }
            this.getShopIdList().add(shopId);
        }
        if (Objects.nonNull(skuId)) {
            if (Objects.isNull(this.skuIdList)) {
                this.setSkuIdList(ListUtil.toList((Object[])new Long[0]));
            }
            this.getSkuIdList().add(skuId);
        }
        String key = String.valueOf(skuId);
        if (Objects.nonNull(shopId)) {
            key = shopId + key;
        }
        if (this.skuPriceMap.containsKey(key)) {
            this.skuPriceMap.get(key).putAll(skuMap);
        } else {
            this.skuPriceMap.put(key, skuMap);
        }
    }

    public Map<Long, BigDecimal> findSkuPrice(Long shopId, Long skuId) {
        String key = String.valueOf(skuId);
        if (Objects.nonNull(shopId)) {
            key = shopId + key;
        }
        return this.skuPriceMap.getOrDefault(key, MapUtil.empty());
    }

    public void addUpdateTime(Long shopId, Long skuId, Date updateTime) {
        String key = String.valueOf(skuId);
        if (Objects.nonNull(shopId)) {
            key = shopId + key;
        }
        this.skuUpdateTimeMap.put(key, updateTime);
    }

    public Date findSkuUpdateTime(Long shopId, Long skuId) {
        String key = String.valueOf(skuId);
        if (Objects.nonNull(shopId)) {
            key = shopId + key;
        }
        return this.skuUpdateTimeMap.get(key);
    }
}

