/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ItemAuthEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.query.IItemAuthQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBBaseRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShopHelper {
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Resource
    private IItemAuthQueryApi itemAuthQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;
    @Autowired
    private IShopQueryApi shopQueryApi;

    public Map<Long, String> getShopNameMap(List<Long> shopIdList) {
        if (CollUtil.isEmpty(shopIdList)) {
            return MapUtil.empty();
        }
        return ((List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryBaseByIdList(shopIdList.stream().distinct().collect(Collectors.toList())))).stream().collect(Collectors.toMap(ShopToBBaseRespDto::getId, ShopToBBaseRespDto::getName));
    }

    public String getShopName(Long shopId) {
        if (Objects.isNull(shopId)) {
            return null;
        }
        return ((ShopDto)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryBaseById(shopId))).getName();
    }

    public Map<String, ItemAuthRespDto> checkShopSkuRange(List<Long> shopIds, List<Long> skuIds) {
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
        itemAuthReqDto.setTargetIdList(shopIds);
        itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
        itemAuthReqDto.setBusinessIdList(skuIds);
        List itemAuthRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.listByPost(itemAuthReqDto));
        Map<String, ItemAuthRespDto> res = new HashMap<String, ItemAuthRespDto>();
        if (CollUtil.isNotEmpty((Collection)itemAuthRespDtos)) {
            res = itemAuthRespDtos.stream().collect(Collectors.toMap(e -> e.getBusinessId() + "-" + e.getTargetId(), e -> e, (e1, e2) -> e1));
        }
        return res;
    }

    public List<ItemAuthRespDto> queryShopSkuList(List<Long> shopIdList) {
        ItemAuthReqDto itemAuthReqDto = new ItemAuthReqDto();
        itemAuthReqDto.setTargetType(ItemAuthEnum.TargetType.SHOP.getCode());
        itemAuthReqDto.setTargetIdList(shopIdList);
        itemAuthReqDto.setStatus(ItemAuthEnum.Status.ENABLE.getCode());
        ArrayList<ItemAuthRespDto> itemAuthRespDtos = (ArrayList<ItemAuthRespDto>)RestResponseHelper.extractData((RestResponse)this.itemAuthQueryApi.listByPost(itemAuthReqDto));
        if (CollUtil.isNotEmpty((Collection)itemAuthRespDtos)) {
            TreeSet<ItemAuthRespDto> itemAuthSet = new TreeSet<ItemAuthRespDto>(Comparator.comparing(o -> o.getBusinessId() + "" + o.getTargetId()));
            itemAuthSet.addAll((Collection<ItemAuthRespDto>)itemAuthRespDtos);
            itemAuthRespDtos = new ArrayList<ItemAuthRespDto>(itemAuthSet);
        }
        return itemAuthRespDtos;
    }

    public List<Long> getShopIdListByOrgIdList(List<Long> orgIdList) {
        ShopToBQueryReqDto shopToBQueryReqDto = new ShopToBQueryReqDto();
        shopToBQueryReqDto.setOrganizationIdList(orgIdList);
        shopToBQueryReqDto.setPageNum(1);
        shopToBQueryReqDto.setPageSize(10000);
        shopToBQueryReqDto.setStatus("NORMAL");
        shopToBQueryReqDto.setSellerStatus("NORMAL");
        PageInfo shopList = (PageInfo)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryPage(shopToBQueryReqDto));
        if (Objects.isNull(shopList) || CollUtil.isEmpty((Collection)shopList.getList())) {
            return ListUtil.empty();
        }
        return shopList.getList().stream().map(ShopToBListRespDto::getId).collect(Collectors.toList());
    }

    public Map<Long, SellerRespDto> getShopSeller(List<Long> shopIds) {
        HashMap<Long, SellerRespDto> shopIdSellerMap = new HashMap<Long, SellerRespDto>();
        if (CollectionUtil.isEmpty(shopIds)) {
            return shopIdSellerMap;
        }
        List shopDtos = (List)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)).getData();
        List sellerIds = shopDtos.stream().filter(e -> e.getSellerId() != null).map(e -> e.getSellerId()).collect(Collectors.toList());
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setIdList(sellerIds);
        List sellerRespDtos = (List)this.sellerQueryApi.queryList(sellerQueryReqDto).getData();
        Map<Long, SellerRespDto> sellerIdMap = sellerRespDtos.stream().collect(Collectors.toMap(SellerRespDto::getId, e -> e, (e1, e2) -> e1));
        for (ShopDto shopDto : shopDtos) {
            Long shopId = shopDto.getId();
            SellerRespDto val = sellerIdMap.get(shopDto.getSellerId());
            shopIdSellerMap.put(shopId, val);
        }
        return shopIdSellerMap;
    }

    public Map<Long, Long> getOrgIdByShopId(List<Long> shopIds) {
        HashMap<Long, Long> shopIdSellerMap = new HashMap<Long, Long>();
        if (CollectionUtil.isEmpty(shopIds)) {
            return shopIdSellerMap;
        }
        List shopDtos = (List)this.shopQueryApi.queryByIds(new HashSet<Long>(shopIds)).getData();
        return shopDtos.stream().collect(Collectors.toMap(ShopDto::getId, ShopDto::getOrganizationId));
    }
}

