/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.audit.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.AuditResultEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SyncStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CommonHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IAuditService;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.AuditInfo;
import com.dtyunxi.yundt.cube.center.price.biz.service.audit.IAudit;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.SyncPriceTaskService;
import com.dtyunxi.yundt.cube.center.price.biz.service.task.TaskInfoDto;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.utils.PriceStatusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceApplyItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.ModifyPriceLogDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.AuditEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceApplyItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.ModifyPriceLogEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceApplyItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceItemEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplyAuditServiceImpl
implements IAudit {
    private static final Logger log = LoggerFactory.getLogger(ApplyAuditServiceImpl.class);
    @Resource
    private BasePriceApplyDas basePriceApplyDas;
    @Resource
    private BasePriceApplyItemDas basePriceApplyItemDas;
    @Resource
    private BasePriceItemDas basePriceItemDas;
    @Value(value="${scheduler.client.app_code:CENTER_PRICE}")
    private String appCode;
    @Resource
    private IAuditService auditService;
    @Resource
    private ModifyPriceLogDas modifyPriceLogDas;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private SyncPriceTaskService syncPriceTaskService;
    @Resource
    private CommonHelper commonHelper;
    private static Map<Integer, List<PriceEo>> map = Maps.newHashMap();

    @Override
    public RelateTypeEnum relateType() {
        return RelateTypeEnum.BASE_PRICE_APPLY;
    }

    public static void main(String[] args) {
        List<PriceEo> priceEos = map.get(1);
        priceEos.removeIf(priceEo -> priceEo.getId().equals(1L));
        System.out.println(JSON.toJsonString(priceEos));
        System.out.println(JSON.toJsonString(map));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncData(Long relateId, Long taskId) {
        MDC.put((String)"yes.req.requestId", (String)String.valueOf(relateId));
        String key = this.appCode + ":" + relateId;
        this.commonHelper.lock(key, 60, k -> {
            log.info("[\u540c\u6b65\u6570\u636e] >>> \u7533\u8bf7\u5355[{}]\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff0c\u5f00\u59cb\u540c\u6b65\u7533\u8bf7\u5355\u6570\u636e", (Object)relateId);
            this.syncApplyItemData(relateId, taskId);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void syncApplyItemData(Long relateId, Long taskId) {
        TimeInterval timer = DateUtil.timer();
        BasePriceApplyEo basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(relateId);
        if (!this.isEffectiveBasePriceApply(relateId, basePriceApplyEo)) {
            return;
        }
        BasePriceApplyItemEo basePriceApplyItemEo = new BasePriceApplyItemEo();
        basePriceApplyItemEo.setApplyId(relateId);
        List basePriceApplyItemList = this.basePriceApplyItemDas.select((BaseEo)basePriceApplyItemEo);
        if (CollUtil.isEmpty((Collection)basePriceApplyItemList)) {
            return;
        }
        AuditRespDto auditLastOne = this.auditService.getAuditLastOne(this.relateType(), relateId);
        Long organizationId = basePriceApplyEo.getOrganizationId();
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        basePriceItemEo.setOrganizationId(organizationId);
        basePriceItemEo.setShopId(basePriceApplyEo.getShopId());
        LambdaQueryWrapper<BasePriceItemEo> itemQueryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(basePriceItemEo);
        List<Long> skuIdList = basePriceApplyItemList.stream().map(StdBasePriceApplyItemEo::getSkuId).collect(Collectors.toList());
        itemQueryWrapper.in(StdBasePriceItemEo::getSkuId, skuIdList);
        List skuPriceList = this.basePriceItemDas.getMapper().selectList(itemQueryWrapper);
        Map<String, BasePriceItemEo> skuPriceMap = skuPriceList.stream().collect(Collectors.toMap(item -> item.getSkuId() + "-" + item.getTypeId(), Function.identity(), (o1, o2) -> o2));
        Map<Long, ItemSkuQueryRespDto> skuMap = this.skuHelper.querySkuMap(skuIdList);
        for (BasePriceApplyItemEo priceApplyItem : basePriceApplyItemList) {
            String key = priceApplyItem.getSkuId() + "-" + priceApplyItem.getTypeId();
            if (!skuMap.containsKey(priceApplyItem.getSkuId())) {
                log.warn("[\u540c\u6b65\u6570\u636e] >>> \u7533\u8bf7\u5355[{}]\u5728\u5546\u54c1\u4e2d\u5fc3\u6ca1\u6709\u627e\u5230skuId[{}][{}]\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", new Object[]{relateId, priceApplyItem.getSkuId(), priceApplyItem.getItemName()});
                continue;
            }
            ItemSkuQueryRespDto basePriceApplyItem = skuMap.get(priceApplyItem.getSkuId());
            BasePriceItemEo oldBasePriceItem = this.getBasePriceItemEo(skuPriceMap, key);
            ModifyPriceLogEo modifyPriceLogEo = new ModifyPriceLogEo();
            modifyPriceLogEo.setPriceItemId(basePriceApplyItem.getItemId());
            modifyPriceLogEo.setPriceTypeId(priceApplyItem.getTypeId());
            modifyPriceLogEo.setItemId(basePriceApplyItem.getItemId());
            modifyPriceLogEo.setItemName(basePriceApplyItem.getItemName());
            modifyPriceLogEo.setSkuId(basePriceApplyItem.getSkuId());
            modifyPriceLogEo.setSkuDesc(basePriceApplyItem.getSkuAttr());
            modifyPriceLogEo.setApplicant(basePriceApplyEo.getCreatePerson());
            modifyPriceLogEo.setReviewer(Objects.isNull(auditLastOne) ? null : auditLastOne.getAuditPerson());
            modifyPriceLogEo.setApprovedTime(basePriceApplyEo.getEffectTime());
            modifyPriceLogEo.setStatus("1");
            modifyPriceLogEo.setOriginalPrice(Objects.isNull(oldBasePriceItem) ? null : oldBasePriceItem.getItemPrice());
            modifyPriceLogEo.setPrice(priceApplyItem.getItemPrice());
            modifyPriceLogEo.setTenantId(priceApplyItem.getTenantId());
            modifyPriceLogEo.setInstanceId(priceApplyItem.getInstanceId());
            modifyPriceLogEo.setBusinessId(basePriceApplyEo.getId());
            modifyPriceLogEo.setBusinessCode(basePriceApplyEo.getApplyCode());
            modifyPriceLogEo.setOrganizationId(organizationId);
            this.modifyPriceLogDas.insert((BaseEo)modifyPriceLogEo);
            if (Objects.isNull(oldBasePriceItem)) {
                BasePriceItemEo newBasePriceItem = new BasePriceItemEo();
                newBasePriceItem.setShopId(basePriceApplyEo.getShopId());
                newBasePriceItem.setItemId(basePriceApplyItem.getItemId());
                newBasePriceItem.setItemName(basePriceApplyItem.getItemName());
                newBasePriceItem.setItemCode(basePriceApplyItem.getItemCode());
                newBasePriceItem.setItemType(String.valueOf(basePriceApplyItem.getSubType()));
                newBasePriceItem.setItemDirName(null);
                newBasePriceItem.setGiftBox(basePriceApplyItem.getGiftBox());
                newBasePriceItem.setSkuId(basePriceApplyItem.getSkuId());
                newBasePriceItem.setSkuCode(basePriceApplyItem.getSkuCode());
                newBasePriceItem.setSkuSpec(basePriceApplyItem.getSkuAttr());
                newBasePriceItem.setItemOrgId(basePriceApplyItem.getItemOrgId());
                newBasePriceItem.setItemBrand(basePriceApplyItem.getBrandName());
                newBasePriceItem.setTypeId(priceApplyItem.getTypeId());
                newBasePriceItem.setItemPrice(priceApplyItem.getItemPrice());
                newBasePriceItem.setRenewTime(basePriceApplyEo.getEffectTime());
                newBasePriceItem.setOrganizationId(organizationId);
                newBasePriceItem.setTenantId(priceApplyItem.getTenantId());
                newBasePriceItem.setInstanceId(priceApplyItem.getInstanceId());
                newBasePriceItem.setBusinessCode(basePriceApplyEo.getApplyCode());
                newBasePriceItem.setBusinessId(basePriceApplyEo.getId());
                this.basePriceItemDas.insert((BaseEo)newBasePriceItem);
                continue;
            }
            oldBasePriceItem.setShopId(basePriceApplyEo.getShopId());
            oldBasePriceItem.setItemId(basePriceApplyItem.getItemId());
            oldBasePriceItem.setItemName(basePriceApplyItem.getItemName());
            oldBasePriceItem.setItemCode(basePriceApplyItem.getItemCode());
            oldBasePriceItem.setItemType(String.valueOf(basePriceApplyItem.getSubType()));
            oldBasePriceItem.setItemDirName(null);
            oldBasePriceItem.setGiftBox(basePriceApplyItem.getGiftBox());
            oldBasePriceItem.setSkuId(basePriceApplyItem.getSkuId());
            oldBasePriceItem.setSkuCode(basePriceApplyItem.getSkuCode());
            oldBasePriceItem.setSkuSpec(basePriceApplyItem.getSkuAttr());
            oldBasePriceItem.setItemOrgId(basePriceApplyItem.getItemOrgId());
            oldBasePriceItem.setItemBrand(basePriceApplyItem.getBrandName());
            oldBasePriceItem.setTypeId(priceApplyItem.getTypeId());
            oldBasePriceItem.setItemPrice(priceApplyItem.getItemPrice());
            oldBasePriceItem.setRenewTime(basePriceApplyEo.getEffectTime());
            oldBasePriceItem.setOrganizationId(organizationId);
            oldBasePriceItem.setTenantId(priceApplyItem.getTenantId());
            oldBasePriceItem.setInstanceId(priceApplyItem.getInstanceId());
            oldBasePriceItem.setBusinessCode(basePriceApplyEo.getApplyCode());
            oldBasePriceItem.setBusinessId(basePriceApplyEo.getId());
            this.basePriceItemDas.update((BaseEo)oldBasePriceItem);
        }
        String extension = basePriceApplyEo.getExtension();
        TaskInfoDto taskInfoDto = null;
        if (StrUtil.isBlank((CharSequence)extension)) {
            taskInfoDto = new TaskInfoDto();
            taskInfoDto.setRelateId(relateId);
            taskInfoDto.setRelateType(this.relateType().getType());
            taskInfoDto.setNote("\u6267\u884c\u4efb\u52a1\u6210\u529f");
            taskInfoDto.setTime(timer.intervalMs());
            taskInfoDto.setCount(1);
            taskInfoDto.setTaskId(taskId);
        } else {
            taskInfoDto = (TaskInfoDto)JSON.parseObject((String)extension, TaskInfoDto.class);
            taskInfoDto.setCount(taskInfoDto.getCount() + 1);
            taskInfoDto.setTime(timer.intervalMs());
            taskInfoDto.setNote("\u6267\u884c\u4efb\u52a1\u6210\u529f");
            taskInfoDto.setTaskId(taskId);
        }
        basePriceApplyEo.setSyncStatus(SyncStatusEnum.SYNC.getCode());
        basePriceApplyEo.setExtension(JSON.toJsonString((Object)taskInfoDto));
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
    }

    private BasePriceItemEo getBasePriceItemEo(Map<String, BasePriceItemEo> skuPriceMap, String key) {
        BasePriceItemEo oldBasePriceItem = null;
        if (skuPriceMap.containsKey(key)) {
            oldBasePriceItem = skuPriceMap.get(key);
        }
        return oldBasePriceItem;
    }

    private boolean isEffectiveBasePriceApply(Long relateId, BasePriceApplyEo basePriceApplyEo) {
        if (Objects.isNull(basePriceApplyEo)) {
            return false;
        }
        String status = basePriceApplyEo.getStatus();
        if (!Objects.equals(status, PriceStatusEnum.AUDIT_PASS.getCode()) || !Objects.equals(SyncStatusEnum.NOT_SYNC.getCode(), basePriceApplyEo.getSyncStatus()) || basePriceApplyEo.getEffectTime().getTime() > System.currentTimeMillis()) {
            log.info("[\u540c\u6b65\u6570\u636e] >>> \u7533\u8bf7\u5355[{}]\u4e0d\u662f\u5ba1\u6838\u901a\u8fc7\u72b6\u6001[{}]\uff0c\u5e76\u4e14\u751f\u6548\u65f6\u95f4\u6ca1\u6709\u6bd4\u5f53\u524d\u65f6\u95f4\u5927", (Object)relateId, (Object)status);
            return false;
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(Long relateId, AuditInfo auditInfo) {
        BasePriceApplyEo basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(relateId);
        if (Objects.isNull(basePriceApplyEo)) {
            return;
        }
        if (Objects.isNull(auditInfo)) {
            return;
        }
        PriceStatusEnum oldPriceStatusEnum = auditInfo.getOldStatus();
        PriceStatusEnum newPriceStatusEnum = auditInfo.getNewStatus();
        log.info("[\u4e1a\u52a1\u5ba1\u6838] >>> \u7533\u8bf7\u5355[{}]\u72b6\u6001\u53d8\u66f4\uff0c\u4ece[{}]\u53d8\u66f4\u4e3a[{}]", new Object[]{relateId, oldPriceStatusEnum, newPriceStatusEnum});
        if (Objects.equals(newPriceStatusEnum, PriceStatusEnum.AUDIT_PASS) && Objects.equals(oldPriceStatusEnum, PriceStatusEnum.WAIT_AUDIT)) {
            if (System.currentTimeMillis() >= basePriceApplyEo.getEffectTime().getTime()) {
                log.info("[\u4e1a\u52a1\u5ba1\u6838] >>> \u7533\u8bf7\u5355[{}]\u5ba1\u6838\u901a\u8fc7\uff0c\u751f\u6548\u65f6\u95f4[{}]\u6bd4\u5f53\u524d\u65f6\u95f4\u65e9\uff0c\u76f4\u63a5\u751f\u6548\uff0c\u8fc1\u79fb\u6570\u636e\u5230\u5b9e\u65f6\u8868", (Object)basePriceApplyEo.getApplyCode(), (Object)DateUtil.format((Date)basePriceApplyEo.getEffectTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.syncData(relateId, null);
                return;
            }
            this.syncPriceTaskService.newTask(basePriceApplyEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AuditInfo modifyStatus(AuditEo auditEo, AuditResultEnum auditResultEnum) {
        Long relateId = auditEo.getRelateId();
        BasePriceApplyEo basePriceApplyEo = (BasePriceApplyEo)this.basePriceApplyDas.selectByPrimaryKey(relateId);
        if (Objects.isNull(basePriceApplyEo)) {
            return null;
        }
        PriceStatusUtils.checkStatus(PriceStatusEnum.getByCode((String)basePriceApplyEo.getStatus()), relateId, PriceStatusEnum.WAIT_AUDIT);
        AuditInfo auditInfo = new AuditInfo();
        auditInfo.setOldStatus(PriceStatusEnum.getByCode((String)basePriceApplyEo.getStatus()));
        if (Objects.equals(auditResultEnum, AuditResultEnum.PASS)) {
            auditInfo.setNewStatus(PriceStatusEnum.AUDIT_PASS);
            basePriceApplyEo.setStatus(PriceStatusEnum.AUDIT_PASS.getCode());
        } else {
            auditInfo.setNewStatus(PriceStatusEnum.AUDIT_REJECT);
            basePriceApplyEo.setStatus(PriceStatusEnum.AUDIT_REJECT.getCode());
        }
        this.basePriceApplyDas.update((BaseEo)basePriceApplyEo);
        return auditInfo;
    }

    static {
        PriceEo priceEo = new PriceEo();
        priceEo.setId(Long.valueOf(1L));
        priceEo.setName("hhh");
        PriceEo priceEo2 = new PriceEo();
        priceEo2.setId(Long.valueOf(2L));
        priceEo2.setName("hhh2");
        map.put(1, Lists.newArrayList((Object[])new PriceEo[]{priceEo, priceEo2}));
    }
}

