/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.es.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.opensearch.api.IOpenSearchService;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.huieryun.opensearch.utils.CustomBeanUtils;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocContentVo;
import com.dtyunxi.huieryun.opensearch.vo.IndexDocumentVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchIndexDocVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerGroupQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerGroupRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerAreaQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerGroupQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.data.api.dto.response.AreaGroupDetailRespDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IAreaGroupQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuExtRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.CustomerDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.ItemDimensionEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceLimitControlEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CommunalPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.AuditRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.LimitCustomerRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.LimitItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceLimitControlRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceLimitService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.impl.EsNativeApiService;
import com.dtyunxi.yundt.cube.center.price.biz.utils.DateUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PriceLimitPolicyEsServiceImpl
implements IPriceLimitPolicyEsService {
    private static final Logger logger = LoggerFactory.getLogger(PriceLimitPolicyEsServiceImpl.class);
    @Autowired
    private ISearchIndexService searchIndexService;
    @Autowired
    private IOpenSearchService openSearchService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${huieryun.searchindexbuilder.indexname.prefix}")
    private String INDEX_PREFIX;
    @Autowired
    private IContext context;
    @Autowired
    private IPriceLimitService priceLimitService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerTypeQueryApi customerTypeQueryApi;
    @Resource
    private ICustomerGroupQueryApi customerGroupQueryApi;
    @Resource
    private IAreaGroupQueryApi areaGroupQueryApi;
    @Resource
    private ICustomerAreaQueryApi customerAreaQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private EsNativeApiService esNativeApiService;
    private static String POLICY_INDEX_NAME = "price_limit_policy";
    private static String POLICY_TYPE_NAME = "price_limit_policy";
    public static Comparator<PriceLimitPolicyEsDto> limitPriorityComp = null;

    @Override
    public void createPriceLimitPolicy(Long policyId) {
        PriceLimitRespDto priceLimitRespDto = this.priceLimitService.queryPriceLimitById(policyId);
        PriceLimitPolicyEsDto policyEsDto = new PriceLimitPolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, priceLimitRespDto);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.addData(documentVo);
        logger.info("\u4fdd\u5b58\u4ef7\u76d8\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void updatePriceLimitPolicy(Long policyId) {
        PriceLimitRespDto priceLimitRespDto = this.priceLimitService.queryPriceLimitById(policyId);
        PriceLimitPolicyEsDto policyEsDto = new PriceLimitPolicyEsDto();
        this.convert2PolicyEsDto(policyEsDto, priceLimitRespDto);
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(String.valueOf(policyId));
        Map docValueMap = CustomBeanUtils.describe((Object)policyEsDto);
        docContentVo.setDocValueMap(docValueMap);
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.updateData(documentVo);
        logger.info("\u4fdd\u5b58\u4ef7\u76d8\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public void deletePriceLimitPolicy(Long policyId) {
        IndexDocumentVo documentVo = new IndexDocumentVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME);
        ArrayList contents = Lists.newArrayList();
        IndexDocContentVo docContentVo = new IndexDocContentVo();
        docContentVo.setIndexId(policyId.toString());
        contents.add(docContentVo);
        documentVo.setContents((List)contents);
        this.searchIndexService.deleteData(documentVo);
        logger.info("\u5220\u9664\u4ef7\u76d8\u7d22\u5f15\u6210\u529f");
    }

    @Override
    public boolean queryByIndexId(Long policyId) {
        SearchIndexDocVo searchIndexDocVo = new SearchIndexDocVo(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME, POLICY_TYPE_NAME, String.valueOf(policyId));
        List indexDocContent = this.searchIndexService.getIndexDocContent(searchIndexDocVo);
        return indexDocContent.size() > 0;
    }

    @Override
    public List<PriceLimitControlRespDto> queryByCondition(CommunalPriceQueryReqDto priceReqDto) {
        OSSearchVo osSearchVo = new OSSearchVo();
        osSearchVo.setIndexName(this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME);
        osSearchVo.setTypeName("price_limit_policy");
        Date policyDate = priceReqDto.getPolicyDate();
        Long custId = priceReqDto.getCustId();
        ArrayList<Long> skuIds = new ArrayList<Long>(priceReqDto.getSkuList().size());
        ArrayList<Long> itemIds = new ArrayList<Long>(priceReqDto.getSkuList().size());
        HashMap<Long, CommunalPriceQueryReqDto.ItemSkuPriceReqDto> itemSkuPriceReqDtoMap = new HashMap<Long, CommunalPriceQueryReqDto.ItemSkuPriceReqDto>();
        for (CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto : priceReqDto.getSkuList()) {
            skuIds.add(itemSkuPriceReqDto.getSkuId());
            itemIds.add(itemSkuPriceReqDto.getItemId());
            itemSkuPriceReqDtoMap.put(itemSkuPriceReqDto.getSkuId(), itemSkuPriceReqDto);
        }
        osSearchVo.addRangeFilter("effectiveTime", null, DateUtil.getDateFormat(policyDate, DateUtil.DEFAULT_PATTERN));
        osSearchVo.addRangeFilter("invalidTime", DateUtil.getDateFormat(policyDate, DateUtil.DEFAULT_PATTERN), null);
        if (skuIds != null && !skuIds.isEmpty()) {
            osSearchVo.addInFilter("itemList.skuId", skuIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]));
        }
        CustomerRespDto customerRespDto = (CustomerRespDto)this.customerQueryApi.queryById(custId).getData();
        ArrayList<PriceLimitControlRespDto> result = new ArrayList<PriceLimitControlRespDto>();
        CustomerTypeRespDto customerTypeRespDto = (CustomerTypeRespDto)this.customerTypeQueryApi.queryByCustomerId(custId).getData();
        if (ObjectUtil.isNotNull((Object)customerTypeRespDto)) {
            String[] customerTypeIdArray = new String[]{customerTypeRespDto.getId().toString()};
            osSearchVo.addInFilter("customerList.customerTypeIds", customerTypeIdArray);
            result.addAll(this.queryPriceLimitByESResult(osSearchVo, skuIds, itemSkuPriceReqDtoMap));
            osSearchVo.removeQuery("customerList.customerTypeIds");
            osSearchVo.removeQuery("itemList.skuId");
            if (skuIds.size() > 0) {
                osSearchVo.addInFilter("itemList.skuId", skuIds.stream().map(String::valueOf).collect(Collectors.toList()).toArray(new String[0]));
                List<Long> groupIds = this.getParentGCustomerGroupIds(customerRespDto.getCustomerGroupId());
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(groupIds)) {
                    for (Long groupId : groupIds) {
                        String[] customerGroupIdArray = new String[]{groupId.toString()};
                        osSearchVo.addInFilter("customerList.customerGroupIds", customerGroupIdArray);
                        result.addAll(this.queryPriceLimitByESResult(osSearchVo, skuIds, itemSkuPriceReqDtoMap));
                        osSearchVo.removeQuery("customerList.customerGroupIds");
                        osSearchVo.removeQuery("itemList.skuId");
                    }
                }
                if (skuIds.size() > 0) {
                    ArrayList<String> areaCodes = new ArrayList<String>();
                    for (String s : customerRespDto.getRegionCodeList()) {
                        this.getParentAreaCodes(areaCodes, s);
                    }
                    for (String areaCode : areaCodes) {
                        String[] customerAreaCodeArray = new String[]{areaCode};
                        osSearchVo.addInFilter("customerList.customerAreaIds", customerAreaCodeArray);
                        result.addAll(this.queryPriceLimitByESResult(osSearchVo, skuIds, itemSkuPriceReqDtoMap));
                    }
                }
            }
        }
        return result;
    }

    private List<Long> getParentGCustomerGroupIds(Long groupId) {
        ArrayList groupIds = Lists.newArrayList();
        if (groupId == null) {
            return groupIds;
        }
        CustomerGroupQueryReqDto customerGroupQueryReqDto = new CustomerGroupQueryReqDto();
        customerGroupQueryReqDto.setTenantId(this.context.tenantId());
        customerGroupQueryReqDto.setInstanceId(this.context.instanceId());
        PageInfo pageInfoRestResponse = (PageInfo)this.customerGroupQueryApi.queryByPage(customerGroupQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)).getData();
        if (null != pageInfoRestResponse && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfoRestResponse.getList())) {
            HashMap<Long, CustomerGroupRespDto> customerGroupMap = new HashMap<Long, CustomerGroupRespDto>();
            pageInfoRestResponse.getList().forEach(customerGroupRespDto -> customerGroupMap.put(null == customerGroupRespDto.getParentGroupId() ? 0L : customerGroupRespDto.getParentGroupId(), (CustomerGroupRespDto)customerGroupRespDto));
            groupIds.add(groupId);
            CustomerGroupRespDto customerGroupRespDto2 = (CustomerGroupRespDto)this.customerGroupQueryApi.queryById(groupId).getData();
            if (null == customerGroupRespDto2) {
                throw new BizException("\u5ba2\u6237\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            this.assembleParentGCustomerGroupIds(groupIds, customerGroupMap, customerGroupRespDto2.getParentGroupId());
        }
        return groupIds;
    }

    private void assembleParentGCustomerGroupIds(List<Long> ids, Map<Long, CustomerGroupRespDto> customerGroupMap, Long parentId) {
        if (parentId == null || parentId == 0L) {
            return;
        }
        CustomerGroupRespDto groupRespDto = customerGroupMap.get(parentId);
        if (null != groupRespDto) {
            ids.add(groupRespDto.getId());
            this.assembleParentGCustomerGroupIds(ids, customerGroupMap, groupRespDto.getParentGroupId());
        }
    }

    private void getParentAreaCodes(List<String> areaCodes, String areaCode) {
        if (areaCodes.contains(areaCode)) {
            return;
        }
        RestResponse areaResponse = this.areaGroupQueryApi.queryByCode(areaCode);
        if (null != areaResponse && null != areaResponse.getData()) {
            AreaGroupDetailRespDto detailRespDto = (AreaGroupDetailRespDto)areaResponse.getData();
            areaCodes.add(detailRespDto.getCode());
            if (detailRespDto.getParentCode() != null && !"0".equals(detailRespDto.getParentCode())) {
                this.getParentAreaCodes(areaCodes, detailRespDto.getParentCode());
            }
        }
    }

    private void convert2PolicyEsDto(PriceLimitPolicyEsDto priceLimitEsDto, PriceLimitRespDto priceLimitRespDto) {
        priceLimitEsDto.setPolicyId(priceLimitRespDto.getId());
        priceLimitEsDto.setPolicyCode(priceLimitRespDto.getCode());
        priceLimitEsDto.setInstanceId(priceLimitRespDto.getInstanceId());
        priceLimitEsDto.setTenantId(priceLimitRespDto.getTenantId());
        priceLimitEsDto.setCategoryCode(priceLimitRespDto.getCategoryCode());
        priceLimitEsDto.setName(priceLimitRespDto.getName());
        priceLimitEsDto.setCreateTime(priceLimitRespDto.getCreateTime());
        AuditRespDto auditRespDto = priceLimitRespDto.getAuditRespDto();
        Date auditPassTime = auditRespDto == null ? null : auditRespDto.getAuditTime();
        priceLimitEsDto.setAuditPassTime(auditPassTime);
        priceLimitEsDto.setEffectiveTime(priceLimitRespDto.getEffectiveTime());
        if (ObjectUtil.isNull((Object)priceLimitRespDto.getEffectiveTime())) {
            priceLimitEsDto.setEffectiveTime(new Date());
        }
        if (ObjectUtil.isNull((Object)priceLimitRespDto.getInvalidTime())) {
            priceLimitEsDto.setInvalidTime(DateUtil.setDateEnd(DateUtil.getDateAfter(new Date(), 36500)));
            priceLimitEsDto.setLongTermValid(Integer.valueOf(1));
        } else {
            priceLimitEsDto.setInvalidTime(priceLimitRespDto.getInvalidTime());
            priceLimitEsDto.setLongTermValid(Integer.valueOf(0));
        }
        priceLimitEsDto.setOrganizationId(priceLimitRespDto.getOrganizationId());
        priceLimitEsDto.setUpperLimit(priceLimitRespDto.getUpperLimit());
        priceLimitEsDto.setLowerLimit(priceLimitRespDto.getLowerLimit());
        priceLimitEsDto.setStatus(priceLimitRespDto.getStatus());
        priceLimitEsDto.setItemDimension(priceLimitRespDto.getRelationItemType());
        priceLimitEsDto.setCustomerDimension(priceLimitRespDto.getRelationCustomerType());
        this.setEsDtoPriceCustCondition(priceLimitRespDto, priceLimitEsDto);
        this.setEsDtoPriceItemCondition(priceLimitRespDto, priceLimitEsDto);
        List priceItemRespDtos = priceLimitRespDto.getPriceItemRespDtos();
        ArrayList<PriceLimitPolicyEsDto.Item> items = new ArrayList<PriceLimitPolicyEsDto.Item>();
        for (LimitItemRespDto limitItemRespDto : priceItemRespDtos) {
            PriceLimitPolicyEsDto.Item item = new PriceLimitPolicyEsDto.Item();
            item.setItemId(limitItemRespDto.getItemId());
            item.setItemName(limitItemRespDto.getItemName());
            item.setUpperPrice(limitItemRespDto.getUpperLimit());
            item.setLowerPrice(limitItemRespDto.getLowerLimit());
            item.setSkuId(limitItemRespDto.getSkuId());
            item.setSkuDesc(limitItemRespDto.getSkuDesc());
            items.add(item);
        }
        priceLimitEsDto.setItemList(items);
    }

    private void setEsDtoPriceCustCondition(PriceLimitRespDto priceLimitRespDto, PriceLimitPolicyEsDto priceLimitEsDto) {
        List<Object> customerIds = new ArrayList();
        ArrayList<Long> customerTypeIds = new ArrayList<Long>();
        ArrayList customerGroupIds = new ArrayList();
        ArrayList customerAreaCodes = new ArrayList();
        ArrayList<String> customerAreaCodesWithSub = new ArrayList<String>();
        if (priceLimitRespDto.getRelationCustomerType() == Integer.valueOf(CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType())) {
            if (ObjectUtil.isEmpty((Object)priceLimitRespDto.getCustomerConditionRespDto())) {
                customerAreaCodesWithSub.add("-1");
            } else {
                List policyCustomerAreaCodes = priceLimitRespDto.getCustomerConditionRespDto().getCustomerAreaCodes();
                List policyCustomerAreaCodeExts = priceLimitRespDto.getCustomerConditionRespDto().getCustomerAreaCodeExts();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)policyCustomerAreaCodes)) {
                    customerAreaCodes.addAll(policyCustomerAreaCodes);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)policyCustomerAreaCodeExts)) {
                        customerAreaCodesWithSub.addAll(policyCustomerAreaCodeExts);
                    }
                } else {
                    customerAreaCodesWithSub.add("-1");
                }
            }
            priceLimitEsDto.setCustomerAreaCodes(customerAreaCodes);
            priceLimitEsDto.setCustomerAreaCodesWithSub(customerAreaCodesWithSub);
            if (ObjectUtil.isEmpty((Object)priceLimitRespDto.getCustomerConditionRespDto())) {
                customerTypeIds.add(-1L);
            } else {
                List policyCustomerTypeIds = priceLimitRespDto.getCustomerConditionRespDto().getCustomerTypeIds();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)policyCustomerTypeIds)) {
                    customerTypeIds.addAll(policyCustomerTypeIds.stream().map(e -> Long.valueOf(e)).collect(Collectors.toList()));
                } else {
                    customerTypeIds.add(-1L);
                }
            }
            priceLimitEsDto.setCustomerTypeIds(customerTypeIds);
            List excludeCustIds = null;
            if (!CollectionUtils.isEmpty((Collection)priceLimitRespDto.getPriceRejectCustomerRespDtoList())) {
                excludeCustIds = priceLimitRespDto.getPriceRejectCustomerRespDtoList().stream().map(e -> e.getCustomerId()).collect(Collectors.toList());
            }
            priceLimitEsDto.setCustomerExcludeCustIds(excludeCustIds);
        } else if (priceLimitRespDto.getRelationCustomerType() == Integer.valueOf(CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType())) {
            customerIds = priceLimitRespDto.getCustomerRespDtos().stream().map(LimitCustomerRespDto::getCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            priceLimitEsDto.setCustomerSpecialCustIds(customerIds);
        }
    }

    private void setEsDtoPriceItemCondition(PriceLimitRespDto priceLimitRespDto, PriceLimitPolicyEsDto priceLimitEsDto) {
        PriceItemConditionRespDto priceItemConditionRespDto = priceLimitRespDto.getPriceItemConditionRespDto();
        if (priceLimitRespDto.getRelationItemType() == Integer.valueOf(ItemDimensionEnum.ITEM_RANGE_ENUM.getType())) {
            List excludeSkuIds = null;
            ArrayList itemBackDirIds = new ArrayList();
            ArrayList<Object> itemBackDirIdsWithSub = new ArrayList<Object>();
            List<Integer> itemTypes = new ArrayList<Integer>();
            List<Long> itemBrandIds = new ArrayList<Long>();
            if (CollUtil.isNotEmpty((Collection)priceLimitRespDto.getPriceRejectItemRespDtoList())) {
                excludeSkuIds = priceLimitRespDto.getPriceRejectItemRespDtoList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemBackDirIds())) {
                List itemBackDirIdConditon = priceItemConditionRespDto.getItemBackDirIds().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
                itemBackDirIds.addAll(itemBackDirIdConditon);
                List itemBackDirIdExtList = Arrays.asList(priceItemConditionRespDto.getItemBackDirIdsExt().split(",")).stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
                itemBackDirIdsWithSub.addAll(itemBackDirIdExtList);
            } else {
                itemBackDirIdsWithSub.add(-1L);
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemBrandIds())) {
                itemBrandIds = priceItemConditionRespDto.getItemBrandIds().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            } else {
                itemBrandIds.add(-1L);
            }
            if (CollUtil.isNotEmpty((Collection)priceItemConditionRespDto.getItemTypes())) {
                itemTypes = priceItemConditionRespDto.getItemTypes().stream().map(e -> Integer.valueOf(e)).collect(Collectors.toList());
            } else {
                itemTypes.add(-1);
            }
            priceLimitEsDto.setItemExcludeSkuIds(excludeSkuIds);
            priceLimitEsDto.setItemBackDirs(itemBackDirIds);
            priceLimitEsDto.setItemBackDirsWithSub(itemBackDirIdsWithSub);
            priceLimitEsDto.setItemBrandIds(itemBrandIds);
            priceLimitEsDto.setItemSubTypes(itemTypes);
            priceLimitEsDto.setItemTypes(itemTypes);
        }
    }

    private List<PriceLimitControlRespDto> queryPriceLimitByESResult(OSSearchVo osSearchVo, List<Long> skuIds, Map<Long, CommunalPriceQueryReqDto.ItemSkuPriceReqDto> itemSkuPriceReqDtoMap) {
        ArrayList<PriceLimitControlRespDto> result = new ArrayList<PriceLimitControlRespDto>();
        int page = 1;
        osSearchVo.setPageSize(200);
        osSearchVo.setPage(page);
        ArrayList discountEsDtos = new ArrayList();
        ArrayList<PriceLimitControlRespDto> skuResults = new ArrayList<PriceLimitControlRespDto>();
        SearchResultVo searchResultVo = null;
        do {
            if ((searchResultVo = this.openSearchService.search(osSearchVo)) == null) continue;
            List pageEsDtos = searchResultVo.getDocValues().stream().map(doc -> {
                PriceLimitPolicyEsDto policyEsDto = (PriceLimitPolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PriceLimitPolicyEsDto.class);
                return policyEsDto;
            }).collect(Collectors.toList());
            discountEsDtos.addAll(pageEsDtos);
            osSearchVo.setPage(++page);
            if (searchResultVo.getDocValues().size() < osSearchVo.getPageSize()) break;
        } while (searchResultVo != null && !CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()));
        ArrayList esDocSkuList = new ArrayList();
        discountEsDtos.forEach(esDto -> esDto.getItemList().forEach(e -> {
            PriceLimitControlRespDto skuDiscountDto = new PriceLimitControlRespDto();
            CubeBeanUtils.copyProperties((Object)skuDiscountDto, (Object)e, (String[])new String[0]);
            CubeBeanUtils.copyProperties((Object)skuDiscountDto, (Object)esDto, (String[])new String[0]);
            boolean skuIdContain = true;
            if (skuIds != null && !skuIds.isEmpty()) {
                skuIdContain = skuIds.contains(skuDiscountDto.getSkuId());
            }
            if (skuIdContain) {
                esDocSkuList.add(skuDiscountDto);
            }
        }));
        Map<Long, List<PriceLimitControlRespDto>> groupBySku = esDocSkuList.stream().collect(Collectors.groupingBy(PriceLimitControlRespDto::getSkuId));
        for (Long skuKey : groupBySku.keySet()) {
            List<PriceLimitControlRespDto> skuDiscounts = groupBySku.get(skuKey);
            if (skuDiscounts.size() > 1) {
                skuDiscounts.sort(new Comparator<PriceLimitControlRespDto>(){

                    @Override
                    public int compare(PriceLimitControlRespDto o1, PriceLimitControlRespDto o2) {
                        return 0 - o1.getEffectiveTime().compareTo(o2.getEffectiveTime());
                    }
                });
            }
            skuResults.add(skuDiscounts.get(0));
        }
        if (CollectionUtil.isNotEmpty(skuResults)) {
            for (PriceLimitControlRespDto limitControlRespDto : skuResults) {
                CommunalPriceQueryReqDto.ItemSkuPriceReqDto itemSkuPriceReqDto = itemSkuPriceReqDtoMap.get(limitControlRespDto.getSkuId());
                if (!ObjectUtil.isNotNull((Object)itemSkuPriceReqDto)) continue;
                PriceLimitControlRespDto priceLimitControlRespDto = new PriceLimitControlRespDto();
                priceLimitControlRespDto.setUpperPrice(limitControlRespDto.getLowerPrice());
                priceLimitControlRespDto.setLowerPrice(limitControlRespDto.getLowerPrice());
                priceLimitControlRespDto.setSkuId(limitControlRespDto.getSkuId());
                priceLimitControlRespDto.setItemId(limitControlRespDto.getItemId());
                priceLimitControlRespDto.setItemName(limitControlRespDto.getItemName());
                int lower = itemSkuPriceReqDto.getSkuSellPrice().compareTo(limitControlRespDto.getLowerPrice());
                int upper = itemSkuPriceReqDto.getSkuSellPrice().compareTo(limitControlRespDto.getUpperPrice());
                if (lower < 0 || upper > 0) {
                    priceLimitControlRespDto.setHasControl(Boolean.valueOf(true));
                    if (PriceLimitControlEnum.STRONG.getCode().equals(limitControlRespDto.getControlType())) {
                        priceLimitControlRespDto.setHasStrongControl(Boolean.valueOf(true));
                    } else if (PriceLimitControlEnum.WEAK.getCode().equals(limitControlRespDto.getControlType())) {
                        priceLimitControlRespDto.setHasWeakControl(Boolean.valueOf(true));
                    }
                }
                skuIds.remove(limitControlRespDto.getSkuId());
                result.add(priceLimitControlRespDto);
            }
        }
        return result;
    }

    @Override
    public Map<String, List<PriceLimitPolicyEsDto>> queryPriceLimitPolicy(PriceLimitEsQueryReqDto reqDto) {
        Assert.noNullElements((Collection)reqDto.getCustomerIdList(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.noNullElements((Collection)reqDto.getSkuIdList(), (String)"\u5546\u54c1skuId\u4e0d\u80fd\u4e3a\u7a7a");
        List itemSkuListRespDto = (List)this.itemSkuQueryApi.querySkuExtBySkuId(reqDto.getSkuIdList()).getData();
        Map<Long, ItemSkuExtRespDto> skuExtRespDtoMap = itemSkuListRespDto.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, e -> e, (e1, e2) -> e1));
        List customerRespDtoList = (List)this.customerExtQueryApi.queryListOnPostByCustomerIds(reqDto.getCustomerIdList()).getData();
        List policyOrgIds = reqDto.getOrganizationIdList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)policyOrgIds)) {
            policyOrgIds = customerRespDtoList.stream().map(e -> e.getMerchantId()).collect(Collectors.toList());
        }
        List<PriceLimitPolicyEsDto> limitPolicyEsDtos = this.queryPriceLimitEsDtoNative(policyOrgIds, customerRespDtoList, itemSkuListRespDto, reqDto);
        HashMap<String, List<PriceLimitPolicyEsDto>> result = new HashMap<String, List<PriceLimitPolicyEsDto>>();
        for (CustomerRespDto customerRespDto : customerRespDtoList) {
            List<PriceLimitPolicyEsDto> custMatchPolicyEsDtos = this.getCustMatchLimitPolicy(customerRespDto, limitPolicyEsDtos);
            for (Long skuId : reqDto.getSkuIdList()) {
                ItemSkuExtRespDto skuExtRespDto = skuExtRespDtoMap.get(skuId);
                String curKey = String.valueOf(customerRespDto.getId()) + "-" + String.valueOf(skuId);
                if (skuExtRespDto == null || skuExtRespDto.getOrganizationId() == null) {
                    logger.info("skuId={}\u6240\u5c5e\u7684\u7ec4\u7ec7id\u4e3anull,\u5339\u914d\u4e0d\u5230\u4ef7\u76d8", (Object)skuId);
                    result.put(curKey, null);
                    continue;
                }
                List<PriceLimitPolicyEsDto> skuAndCustMatchEsDtos = this.getSkuMatchLimitPolicy(skuExtRespDto, custMatchPolicyEsDtos);
                if (reqDto.getQueryBestMatch() == 1) {
                    logger.info("\u67e5\u8be2custId+skuId={}\u6700\u4f18\u5339\u914d\u7684\u4ef7\u76d8", (Object)curKey);
                    PriceLimitPolicyEsDto bestMatchLimitPolicyEsDto = this.getBestMatchLimitPolicyEsDto(skuAndCustMatchEsDtos, customerRespDto);
                    result.put(curKey, bestMatchLimitPolicyEsDto == null ? null : Arrays.asList(bestMatchLimitPolicyEsDto));
                    continue;
                }
                result.put(curKey, org.apache.commons.collections.CollectionUtils.isEmpty(skuAndCustMatchEsDtos) ? null : skuAndCustMatchEsDtos);
            }
        }
        return result;
    }

    @Override
    public Comparator<PriceLimitPolicyEsDto> getDefaultLimitPriorityComp() {
        if (limitPriorityComp == null) {
            limitPriorityComp = new Comparator<PriceLimitPolicyEsDto>(){

                @Override
                public int compare(PriceLimitPolicyEsDto o1, PriceLimitPolicyEsDto o2) {
                    Integer itemDimesion2;
                    Integer itemDimesion1;
                    Integer custDimesion2;
                    Integer custDimesion1 = o1.getCustomerDimension();
                    if (custDimesion1 != (custDimesion2 = o2.getCustomerDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    if (custDimesion1 == 1) {
                        // empty if block
                    }
                    if ((itemDimesion1 = o1.getItemDimension()) != (itemDimesion2 = o2.getItemDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    Date effTime1 = o1.getEffectiveTime();
                    Date effTime2 = o2.getEffectiveTime();
                    return 0 - effTime1.compareTo(effTime2);
                }
            };
        }
        return limitPriorityComp;
    }

    private List<PriceLimitPolicyEsDto> getCustMatchLimitPolicy(CustomerRespDto customerRespDto, List<PriceLimitPolicyEsDto> limitPolicyEsDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(limitPolicyEsDtos)) {
            ArrayList<PriceLimitPolicyEsDto> res = new ArrayList<PriceLimitPolicyEsDto>();
            for (PriceLimitPolicyEsDto priceLimitPolicyEsDto : limitPolicyEsDtos) {
                if (customerRespDto.getMerchantId() == null || !customerRespDto.getMerchantId().equals(priceLimitPolicyEsDto.getOrganizationId())) {
                    logger.info("\u5ba2\u6237={}\u6240\u5c5e\u7684\u4e0a\u6e38\u5546\u54c1\u7ec4\u7ec7id={}\u4e3a\u4e0d\u7b49\u4e8e\u4ef7\u76d8\u6240\u5c5e\u7684\u7ec4\u7ec7id={}", new Object[]{customerRespDto.getId(), customerRespDto.getMerchantId(), priceLimitPolicyEsDto.getOrganizationId()});
                    continue;
                }
                String custDimensionStr = String.valueOf(priceLimitPolicyEsDto.getCustomerDimension());
                CustomerDimensionEnum custDimension = CustomerDimensionEnum.getByType((String)custDimensionStr);
                switch (custDimension) {
                    case CUSTOMER_SPECIFIED_ENUM: {
                        List custIdList = priceLimitPolicyEsDto.getCustomerSpecialCustIds();
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)custIdList) || !custIdList.contains(customerRespDto.getId())) break;
                        res.add(priceLimitPolicyEsDto);
                        break;
                    }
                    case CUSTOMER_RANGE_ENUM: {
                        List policyCustTypeIdList = priceLimitPolicyEsDto.getCustomerTypeIds();
                        List policyCustExcludeIdList = priceLimitPolicyEsDto.getCustomerExcludeCustIds();
                        List policyCustAreaCodes = priceLimitPolicyEsDto.getCustomerAreaCodes();
                        List policyCustAreaCodesWithSub = priceLimitPolicyEsDto.getCustomerAreaCodesWithSub();
                        boolean rangeMatch = true;
                        Long custTypeId = customerRespDto.getCustomerTypeId();
                        List custAreaCodeList = customerRespDto.getRegionCodeList();
                        Long custId = customerRespDto.getId();
                        if (!(org.apache.commons.collections.CollectionUtils.isEmpty((Collection)policyCustTypeIdList) || policyCustTypeIdList.contains(custTypeId) || policyCustTypeIdList.contains(-1L))) {
                            rangeMatch = false;
                            break;
                        }
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)policyCustExcludeIdList) && policyCustExcludeIdList.contains(custId)) {
                            rangeMatch = false;
                            break;
                        }
                        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)policyCustAreaCodesWithSub) && !policyCustAreaCodesWithSub.contains("-1")) {
                            boolean areaMatch = false;
                            for (String areaCode : custAreaCodeList) {
                                if (!policyCustAreaCodesWithSub.contains(areaCode)) continue;
                                areaMatch = true;
                                break;
                            }
                            if (areaMatch) {
                                rangeMatch = true;
                            }
                        } else {
                            rangeMatch = true;
                        }
                        if (!rangeMatch) break;
                        res.add(priceLimitPolicyEsDto);
                        break;
                    }
                    case CUSTOMER_ALL_ENUM: {
                        res.add(priceLimitPolicyEsDto);
                        break;
                    }
                }
            }
            return res;
        }
        return null;
    }

    public PriceLimitPolicyEsDto getBestMatchLimitPolicyEsDto(List<PriceLimitPolicyEsDto> limitPolicyEsDtos, CustomerRespDto customerRespDto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(limitPolicyEsDtos)) {
            limitPolicyEsDtos.sort(new Comparator<PriceLimitPolicyEsDto>(){

                @Override
                public int compare(PriceLimitPolicyEsDto o1, PriceLimitPolicyEsDto o2) {
                    Integer itemDimesion2;
                    Integer custDimesion2;
                    Integer custDimesion1 = o1.getCustomerDimension();
                    if (!custDimesion1.equals(custDimesion2 = o2.getCustomerDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    Integer itemDimesion1 = o1.getItemDimension();
                    if (!itemDimesion1.equals(itemDimesion2 = o2.getItemDimension())) {
                        return custDimesion1 - custDimesion2;
                    }
                    Date effTime1 = o1.getEffectiveTime();
                    Date effTime2 = o2.getEffectiveTime();
                    return 0 - effTime1.compareTo(effTime2);
                }
            });
            return limitPolicyEsDtos.get(0);
        }
        return null;
    }

    private List<PriceLimitPolicyEsDto> getSkuMatchLimitPolicy(ItemSkuExtRespDto skuExtRespDto, List<PriceLimitPolicyEsDto> skuLimitPolicyEsDtos) {
        ArrayList<PriceLimitPolicyEsDto> res = new ArrayList<PriceLimitPolicyEsDto>();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuLimitPolicyEsDtos)) {
            return res;
        }
        for (PriceLimitPolicyEsDto limitPolicyEsDto : skuLimitPolicyEsDtos) {
            Long policyOrgId = limitPolicyEsDto.getOrganizationId();
            if (skuExtRespDto.getOrganizationId() == null || !skuExtRespDto.getOrganizationId().equals(policyOrgId)) {
                logger.info("skuId={}\u6240\u5c5e\u7684\u7ec4\u7ec7id={}\u4e3a\u4e0d\u7b49\u4e8e\u4ef7\u76d8\u6240\u5c5e\u7684\u7ec4\u7ec7id={}", new Object[]{skuExtRespDto.getSkuId(), skuExtRespDto.getOrganizationId(), policyOrgId});
                continue;
            }
            String itemDimensionStr = String.valueOf(limitPolicyEsDto.getItemDimension());
            ItemDimensionEnum itemDimension = ItemDimensionEnum.getByType((String)itemDimensionStr);
            switch (itemDimension) {
                case ITEM_SPECIAL_ENUM: {
                    List skuIdList = limitPolicyEsDto.getItemList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
                    if (!skuIdList.contains(skuExtRespDto.getSkuId())) break;
                    res.add(limitPolicyEsDto);
                    break;
                }
                case ITEM_RANGE_ENUM: {
                    List subTypeList = limitPolicyEsDto.getItemSubTypes();
                    List brandIdList = limitPolicyEsDto.getItemBrandIds();
                    List dirIdList = limitPolicyEsDto.getItemBackDirs();
                    List itemBackDirsWithSub = limitPolicyEsDto.getItemBackDirsWithSub();
                    List excludeSkuIdList = limitPolicyEsDto.getItemExcludeSkuIds();
                    boolean rangeMatch = true;
                    Integer skuSubType = skuExtRespDto.getSubType();
                    Long backDirId = skuExtRespDto.getDirId();
                    Long brandId = skuExtRespDto.getBrandId();
                    Long skuId = skuExtRespDto.getSkuId();
                    if (!(CollectionUtils.isEmpty((Collection)subTypeList) || subTypeList.contains(skuSubType) || subTypeList.contains(-1))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!(CollectionUtils.isEmpty((Collection)itemBackDirsWithSub) || itemBackDirsWithSub.contains(backDirId) || itemBackDirsWithSub.contains(-1L))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!(CollectionUtils.isEmpty((Collection)brandIdList) || brandIdList.contains(brandId) || brandIdList.contains(-1L))) {
                        rangeMatch = false;
                        break;
                    }
                    if (!CollectionUtils.isEmpty((Collection)excludeSkuIdList) && excludeSkuIdList.contains(skuId) && !excludeSkuIdList.contains(-1L)) {
                        rangeMatch = false;
                        break;
                    }
                    if (!rangeMatch) break;
                    res.add(limitPolicyEsDto);
                    break;
                }
                case ITEM_ALL_ENUM: {
                    res.add(limitPolicyEsDto);
                    break;
                }
            }
        }
        return res;
    }

    private List<PriceLimitPolicyEsDto> queryPriceLimitEsDtoNative(List<Long> policyOrgIds, List<CustomerRespDto> customerRespDtoList, List<ItemSkuExtRespDto> skuExtDtos, PriceLimitEsQueryReqDto reqDto) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuExtDtos)) {
            return null;
        }
        ArrayList<PriceLimitPolicyEsDto> result = new ArrayList<PriceLimitPolicyEsDto>();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.INDEX_PREFIX + "_" + POLICY_INDEX_NAME});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        BoolQueryBuilder itemBoolQuery = QueryBuilders.boolQuery();
        this.buildMutilItemBoolQuery(itemBoolQuery, skuExtDtos);
        BoolQueryBuilder custBoolQuery = QueryBuilders.boolQuery();
        this.buildMutilCustBoolQuery(custBoolQuery, customerRespDtoList);
        Date policyDate = reqDto.getPolicyDate() == null ? new Date() : reqDto.getPolicyDate();
        String policyDateStr = DateUtil.getDateFormat(policyDate, DateUtil.DEFAULT_PATTERN);
        boolQuery.must().add(QueryBuilders.termsQuery((String)"organizationId", policyOrgIds));
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getPolicyCode())) {
            boolQuery.must().add(QueryBuilders.termsQuery((String)"policyCode", (String[])new String[]{reqDto.getPolicyCode()}));
        }
        boolQuery.must().add(QueryBuilders.termsQuery((String)"status", (String[])new String[]{PriceStatusEnum.AUDIT_PASS.getCode()}));
        BoolQueryBuilder policyDateBoolQuery = QueryBuilders.boolQuery();
        this.buildPolicyDataBoolQuery(policyDateBoolQuery, policyDateStr);
        boolQuery.must().add(policyDateBoolQuery);
        boolQuery.must().add(custBoolQuery);
        boolQuery.must().add(itemBoolQuery);
        FieldSortBuilder createTimeDesc = (FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.DESC);
        searchSourceBuilder.sort((SortBuilder)createTimeDesc);
        logger.info("\u67e5\u8be2sku-limit\u96c6\u5408 custId={}\u4e2a", (Object)customerRespDtoList.size());
        int page = 1;
        int pageSize = 100;
        int startIndex = page > 0 ? (page - 1) * pageSize : 0;
        SearchResultVo searchResultVo = null;
        do {
            searchSourceBuilder.from(startIndex).size(pageSize).fetchSource(true).query((QueryBuilder)boolQuery);
            searchResultVo = this.esNativeApiService.wrapNativeSearch(searchSourceBuilder, searchRequest);
            if (null == searchResultVo) continue;
            List pageEsDtos = searchResultVo.getDocValues().stream().map(doc -> {
                PriceLimitPolicyEsDto policyLimitEsDto = (PriceLimitPolicyEsDto)JSON.parseObject((String)JSON.toJSONString((Object)doc), PriceLimitPolicyEsDto.class);
                return policyLimitEsDto;
            }).collect(Collectors.toList());
            result.addAll(pageEsDtos);
            int n = startIndex = ++page > 0 ? (page - 1) * pageSize : 0;
        } while (searchResultVo != null && !CollectionUtils.isEmpty((Collection)searchResultVo.getDocValues()) && searchResultVo.getDocValues().size() == pageSize);
        return result;
    }

    private void buildPolicyDataBoolQuery(BoolQueryBuilder policyDateBoolQuery, String policyDateStr) {
        policyDateBoolQuery.should().add(QueryBuilders.termQuery((String)"longTermValid", (int)1));
        BoolQueryBuilder dateRangeBoolQuery = QueryBuilders.boolQuery();
        dateRangeBoolQuery.must().add(QueryBuilders.rangeQuery((String)"effectiveTime").to((Object)policyDateStr, true));
        dateRangeBoolQuery.must().add(QueryBuilders.rangeQuery((String)"invalidTime").from((Object)policyDateStr, true));
        policyDateBoolQuery.should().add(dateRangeBoolQuery);
    }

    private void buildMutilCustBoolQuery(BoolQueryBuilder custBoolQuery, List<CustomerRespDto> customerRespDtoList) {
        Set customerTypeIds = customerRespDtoList.stream().map(e -> String.valueOf(e.getCustomerTypeId())).collect(Collectors.toSet());
        HashSet<String> custAearcodes = new HashSet<String>();
        custAearcodes.add("-1");
        customerTypeIds.add("-1");
        customerRespDtoList.forEach(e -> {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)e.getRegionCodeList())) {
                List tempRegionCode = e.getRegionCodeList().stream().filter(s1 -> StringUtils.isNotEmpty((CharSequence)s1)).collect(Collectors.toList());
                custAearcodes.addAll(tempRegionCode);
            } else {
                logger.warn("customerId={},areaCode is null", (Object)e.getId());
            }
        });
        List customerIds = customerRespDtoList.stream().map(e -> String.valueOf(e.getId())).collect(Collectors.toList());
        custBoolQuery.should().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()));
        BoolQueryBuilder custRangeBoolQuery = QueryBuilders.boolQuery();
        custRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerTypeIds", customerTypeIds));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerAreaCodesWithSub", custAearcodes));
        custBoolQuery.should().add(custRangeBoolQuery);
        BoolQueryBuilder custSpecialBoolQuery = QueryBuilders.boolQuery();
        custSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        custSpecialBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerSpecialCustIds", customerIds));
        custBoolQuery.should().add(custSpecialBoolQuery);
    }

    private void buildCustBoolQuery(BoolQueryBuilder custBoolQuery, CustomerRespDto customerRespDto) {
        String customerTypeId = String.valueOf(customerRespDto.getCustomerTypeId());
        List custAearcodes = customerRespDto.getRegionCodeList();
        String customerId = String.valueOf(customerRespDto.getId());
        custBoolQuery.should().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_ALL_ENUM.getType()));
        BoolQueryBuilder custRangeBoolQuery = QueryBuilders.boolQuery();
        custRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_RANGE_ENUM.getType()));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerTypeIds", (String[])new String[]{customerTypeId}));
        custRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerAreaCodesWithSub", (Collection)custAearcodes));
        custRangeBoolQuery.mustNot().add(QueryBuilders.termsQuery((String)"customerExcludeCustIds", (String[])new String[]{customerId}));
        custBoolQuery.should().add(custRangeBoolQuery);
        BoolQueryBuilder custSpecialBoolQuery = QueryBuilders.boolQuery();
        custSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"customerDimension", (String)CustomerDimensionEnum.CUSTOMER_SPECIFIED_ENUM.getType()));
        custSpecialBoolQuery.must().add(QueryBuilders.termsQuery((String)"customerSpecialCustIds", (String[])new String[]{customerId}));
        custBoolQuery.should().add(custSpecialBoolQuery);
    }

    private void buildMutilItemBoolQuery(BoolQueryBuilder itemBoolQuery, List<ItemSkuExtRespDto> itemSkuListRespDto) {
        List skuIdList = itemSkuListRespDto.stream().map(e -> e.getId()).collect(Collectors.toList());
        List subTypeList = itemSkuListRespDto.stream().map(e -> e.getSubType()).distinct().collect(Collectors.toList());
        List brandIdList = itemSkuListRespDto.stream().map(e -> e.getBrandId()).distinct().collect(Collectors.toList());
        List dirIdList = itemSkuListRespDto.stream().map(e -> e.getDirId()).distinct().collect(Collectors.toList());
        subTypeList.add(-1);
        brandIdList.add(-1L);
        dirIdList.add(-1L);
        itemBoolQuery.should().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_ALL_ENUM.getType()));
        BoolQueryBuilder itemRangeBoolQuery = QueryBuilders.boolQuery();
        itemRangeBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_RANGE_ENUM.getType()));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemSubTypes", subTypeList));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBackDirsWithSub", dirIdList));
        itemRangeBoolQuery.must().add(QueryBuilders.termsQuery((String)"itemBrandIds", brandIdList));
        itemBoolQuery.should().add(itemRangeBoolQuery);
        BoolQueryBuilder itemSpecialBoolQuery = QueryBuilders.boolQuery();
        itemSpecialBoolQuery.must().add(QueryBuilders.termQuery((String)"itemDimension", (String)ItemDimensionEnum.ITEM_SPECIAL_ENUM.getType()));
        NestedQueryBuilder skuIdNestQuery = QueryBuilders.nestedQuery((String)"itemList", (QueryBuilder)QueryBuilders.termsQuery((String)"itemList.skuId", skuIdList), (ScoreMode)ScoreMode.None);
        itemSpecialBoolQuery.must().add(skuIdNestQuery);
        itemBoolQuery.should().add(itemSpecialBoolQuery);
    }
}

