/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.BaseExcelDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ExcelImportDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.ItemSkuPriceLimitQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceLimitRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.PriceItemSkuSectionRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceV2Service;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IImportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseImportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.PriceDirectPrcingImportVo;
import com.dtyunxi.yundt.cube.center.price.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PriceDirectPrcingImportImpl
extends BaseImportImpl
implements IImportSevice<PriceDirectPrcingImportVo> {
    private static final Logger logger = LoggerFactory.getLogger(PriceDirectPrcingImportImpl.class);
    private static final String SHOP_ID = "shopId";
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private IPriceV2Service priceV2Service;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;

    @Override
    public boolean needVerfiy() {
        return Boolean.TRUE;
    }

    @Override
    public ImportParams importParams() {
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerfiy(this.needVerfiy());
        importParams.setTitleRows(1);
        return importParams;
    }

    @Override
    public Class<PriceDirectPrcingImportVo> pojoClass() {
        return PriceDirectPrcingImportVo.class;
    }

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.IMPORT_PRICE_DIRECT_PRICING;
    }

    @Override
    public void importData(ExcelImportDto excelImportDto, BaseExcelDto baseExcelDto, List<PriceDirectPrcingImportVo> successList, List<PriceDirectPrcingImportVo> failList) {
        logger.info("\u6210\u529f\u6570\u636e\uff1a{},\u5931\u8d25\u6570\u636e\uff1a{}", JSON.toJSON(successList), JSON.toJSON(failList));
        if (CollUtil.isNotEmpty(failList)) {
            baseExcelDto.setErrorMsgList(this.getErrorList(failList));
            baseExcelDto.setSuccessDataList(ListUtil.empty());
            return;
        }
        Long shopId = (Long)excelImportDto.popValue(SHOP_ID, Long.class);
        AssertUtils.isNonNull(shopId, PriceExceptionCode.ERROR.setParamValue("\u5e97\u94faid\u4e3a\u7a7a"));
        List<String> itemCodeList = successList.stream().map(PriceDirectPrcingImportVo::getItemCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toList());
        Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMapByItemCodeListAndShopId(itemCodeList, null);
        if (CollUtil.isEmpty(skuQueryRespDtoMap)) {
            return;
        }
        List skuIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getSkuId).distinct().collect(Collectors.toList());
        ItemSkuPriceLimitQueryReqDto itemSkuPriceLimitQueryReqDto = new ItemSkuPriceLimitQueryReqDto();
        itemSkuPriceLimitQueryReqDto.setShopId(shopId);
        itemSkuPriceLimitQueryReqDto.setSkuIdList(skuIdList);
        ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto = this.basePriceApplyItemService.queryItemPriceList(itemSkuPriceLimitQueryReqDto);
        ArrayList priceItemList = ListUtil.toList((Object[])new PriceItemEo[0]);
        ArrayList list = ListUtil.toList((Object[])new PriceDirectPrcingImportVo[0]);
        HashMap skuPriceLimitListMap = MapUtil.newHashMap();
        for (PriceDirectPrcingImportVo importVo : successList) {
            PriceItemEo priceItemEo = this.getPriceItemEo(baseExcelDto, skuQueryRespDtoMap, itemSkuPriceLimitRespDto, importVo);
            if (priceItemEo == null) continue;
            PriceItemSkuSectionRespDto priceItemSkuSectionRespDto = new PriceItemSkuSectionRespDto();
            priceItemSkuSectionRespDto.setItemPrice(priceItemEo.getItemPrice());
            priceItemSkuSectionRespDto.setUpperLimit(priceItemEo.getUpperLimit());
            priceItemSkuSectionRespDto.setLowerLimit(priceItemEo.getLowerLimit());
            if (!skuPriceLimitListMap.containsKey(importVo.getSkuId())) {
                list.add(importVo);
                ArrayList skuPriceLimitList = ListUtil.toList((Object[])new PriceItemSkuSectionRespDto[0]);
                skuPriceLimitList.add(priceItemSkuSectionRespDto);
                skuPriceLimitListMap.put(importVo.getSkuId(), skuPriceLimitList);
            } else {
                ((List)skuPriceLimitListMap.get(importVo.getSkuId())).add(priceItemSkuSectionRespDto);
            }
            priceItemList.add(priceItemEo);
        }
        try {
            if (CollUtil.isNotEmpty((Collection)priceItemList)) {
                this.priceV2Service.checkSkuInterval(priceItemList);
            }
        }
        catch (BizException bizException) {
            baseExcelDto.addErrorMsg(bizException.getMessage());
        }
        catch (Exception e) {
            throw e;
        }
        if (baseExcelDto.isImportStatus()) {
            list.forEach(item -> {
                item.setLowerLimit(null);
                item.setUpperLimit(null);
                item.setSkuPriceLimitList((List)skuPriceLimitListMap.get(item.getSkuId()));
            });
            baseExcelDto.setSuccessDataList((List)list);
        }
    }

    private PriceItemEo getPriceItemEo(BaseExcelDto<?> baseExcelDto, Map<String, ItemSkuQueryRespDto> skuQueryRespDtoMap, ItemSkuPriceLimitRespDto itemSkuPriceLimitRespDto, PriceDirectPrcingImportVo importVo) {
        String itemCode = importVo.getItemCode();
        ItemSkuQueryRespDto itemSkuQueryRespDto = skuQueryRespDtoMap.get(itemCode);
        if (itemSkuQueryRespDto == null || !Objects.equals(itemSkuQueryRespDto.getItemCode(), itemCode)) {
            baseExcelDto.addErrorMsg(this.serialNumberStr(importVo.getSerialNumber()) + " \u5546\u54c1\u7f16\u7801[" + itemCode + "]\u4e0d\u5b58\u5728");
            return null;
        }
        importVo.setGiftBox(Objects.isNull(itemSkuQueryRespDto.getGiftBox()) ? null : String.valueOf(itemSkuQueryRespDto.getGiftBox()));
        importVo.setBrandName(itemSkuQueryRespDto.getBrandName());
        importVo.setDirName(itemSkuQueryRespDto.getDirName());
        importVo.setItemName(itemSkuQueryRespDto.getItemName());
        importVo.setSkuAttr(itemSkuQueryRespDto.getSkuAttr());
        importVo.setShopId(itemSkuQueryRespDto.getShopId());
        importVo.setSubType(itemSkuQueryRespDto.getSubType());
        importVo.setItemOrgName(itemSkuQueryRespDto.getItemOrgName());
        importVo.setSkuId(itemSkuQueryRespDto.getSkuId());
        importVo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
        ItemSkuPriceInfoRespDto itemSkuPriceInfoRespDto = (ItemSkuPriceInfoRespDto)itemSkuPriceLimitRespDto.getSkuPriceInfo().get(itemSkuQueryRespDto.getSkuId());
        if (Objects.nonNull(itemSkuPriceInfoRespDto)) {
            importVo.setRetailPrice(itemSkuPriceInfoRespDto.getRetailPrice());
            importVo.setControlType(itemSkuPriceInfoRespDto.getControlType());
            importVo.setLowerLimitPrice(itemSkuPriceInfoRespDto.getLowerLimitPrice());
            importVo.setUpperLimitPrice(itemSkuPriceInfoRespDto.getUpperLimitPrice());
            importVo.setExchangePrice(itemSkuPriceInfoRespDto.getExchangePrice());
            importVo.setDealerRetailPrice(itemSkuPriceInfoRespDto.getDealerRetailPrice());
        }
        PriceItemEo priceItemEo = new PriceItemEo();
        priceItemEo.setSkuId(itemSkuQueryRespDto.getSkuId());
        priceItemEo.setItemPrice(importVo.getPrice());
        priceItemEo.setItemName(importVo.getItemName());
        priceItemEo.setSkuCode(itemSkuQueryRespDto.getSkuCode());
        priceItemEo.setUpperLimit(importVo.getUpperLimit());
        priceItemEo.setLowerLimit(importVo.getLowerLimit());
        return priceItemEo;
    }
}

