/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.SetStatusEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.BasePriceItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuOptionalQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuPriceQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuRetailPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceItemRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.BasePriceItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuRetailPriceCountRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuOptionalQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuPriceQueryRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuRetailPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.constant.PriceExceptionCode;
import com.dtyunxi.yundt.cube.center.price.biz.helper.CustomerHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.PriceHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.ShopHelper;
import com.dtyunxi.yundt.cube.center.price.biz.helper.SkuHelper;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceApplyItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPriceVo;
import com.dtyunxi.yundt.cube.center.price.dao.das.BasePriceItemDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.BasePriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdBasePriceItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class BasePriceItemServiceImpl
implements IBasePriceItemService {
    private static final Logger logger = LoggerFactory.getLogger(BasePriceItemServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private BasePriceItemDas basePriceItemDas;
    @Resource
    private CustomerHelper customerHelper;
    @Resource
    private ShopHelper shopHelper;
    @Resource
    private IBasePriceApplyItemService basePriceApplyItemService;
    @Resource
    private SkuHelper skuHelper;
    @Resource
    private IPriceBasicConfigService priceBasicConfigService;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;
    @Resource
    private PriceHelper priceHelper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBasePriceItem(BasePriceItemAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceItemEo);
        basePriceItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        if (Objects.isNull(basePriceItemEo.getInstanceId())) {
            basePriceItemEo.setInstanceId(this.context.instanceId());
        }
        if (Objects.isNull(basePriceItemEo.getTenantId())) {
            basePriceItemEo.setTenantId(this.context.tenantId());
        }
        this.basePriceItemDas.insert((BaseEo)basePriceItemEo);
        return basePriceItemEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchBasePriceItem(List<BasePriceItemAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList basePriceItemEoList = ListUtil.toList((Object[])new BasePriceItemEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)basePriceItemEoList, BasePriceItemEo.class);
        if (CollUtil.isEmpty((Collection)basePriceItemEoList)) {
            return ListUtil.empty();
        }
        for (BasePriceItemEo basePriceItemEo : basePriceItemEoList) {
            basePriceItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(basePriceItemEo.getInstanceId())) {
                basePriceItemEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(basePriceItemEo.getTenantId())) continue;
            basePriceItemEo.setTenantId(this.context.tenantId());
        }
        this.basePriceItemDas.insertBatch((List)basePriceItemEoList);
        return basePriceItemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBasePriceItem(BasePriceItemModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceItemEo basePriceItemEo = (BasePriceItemEo)this.basePriceItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceItemEo)) {
            return;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceItemEo);
        this.basePriceItemDas.update((BaseEo)basePriceItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceItemById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        BasePriceItemEo basePriceItemEo = (BasePriceItemEo)this.basePriceItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceItemEo)) {
            return;
        }
        this.basePriceItemDas.logicDeleteById(basePriceItemEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBasePriceItemByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.basePriceItemDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<BasePriceItemRespDto> queryByPage(BasePriceItemQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<BasePriceItemEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.basePriceItemDas, queryWrapper, BasePriceItemRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<BasePriceItemEo> getQueryWrapper(BasePriceItemQueryReqDto reqDto) {
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)basePriceItemEo);
        basePriceItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)basePriceItemEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getTypeIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getTypeId, (Collection)reqDto.getTypeIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            queryWrapper.in(StdBasePriceItemEo::getSkuCode, (Collection)reqDto.getSkuCodeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemOrgIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getItemOrgId, (Collection)reqDto.getItemOrgIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemTypeList())) {
            queryWrapper.in(StdBasePriceItemEo::getItemType, (Collection)reqDto.getItemTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getItemId, (Collection)reqDto.getItemIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getSkuIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getSkuId, (Collection)reqDto.getSkuIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getShopIdList())) {
            queryWrapper.in(StdBasePriceItemEo::getShopId, (Collection)reqDto.getShopIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(StdBasePriceItemEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        return queryWrapper;
    }

    @Override
    public List<BasePriceItemRespDto> queryByList(BasePriceItemQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return ListUtil.empty();
        }
        return this.basePriceItemDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (BasePriceItemRespDto)item.toDto(BasePriceItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public BasePriceItemRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        BasePriceItemEo basePriceItemEo = (BasePriceItemEo)this.basePriceItemDas.selectByPrimaryKey(id);
        if (Objects.isNull(basePriceItemEo)) {
            return null;
        }
        return (BasePriceItemRespDto)basePriceItemEo.toDto(BasePriceItemRespDto.class);
    }

    @Override
    public List<BasePriceItemRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return ListUtil.empty();
        }
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        basePriceItemEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)basePriceItemEo).in(BaseEo::getId, idList);
        List basePriceItemEoList = this.basePriceItemDas.getMapper().selectList((Wrapper)queryWrapper);
        return basePriceItemEoList.stream().map(item -> (BasePriceItemRespDto)item.toDto(BasePriceItemRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public List<BasePriceItemEo> queryBrandPriceBySkuIds(List<Long> skuIdList, List<Long> typeIds, List<Long> itemOrgIds) {
        Assert.noNullElements(skuIdList, (String)"skuIdList\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.noNullElements(typeIds, (String)"typeIds\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.noNullElements(itemOrgIds, (String)"itemOrgIds\u4e0d\u80fd\u4e3a\u7a7a");
        BasePriceItemQueryReqDto reqDto = new BasePriceItemQueryReqDto();
        reqDto.setTypeIdList(typeIds);
        reqDto.setItemOrgIdList(itemOrgIds);
        reqDto.setSkuIdList(skuIdList);
        return this.basePriceItemDas.getMapper().selectList(this.getQueryWrapper(reqDto));
    }

    @Override
    public List<BasePriceItemEo> queryDealerPriceBySkuIds(List<Long> shopIdList, List<Long> skuIdList, Long priceTypeId, Long sellerOrgId) {
        Assert.noNullElements(shopIdList, (String)"shopIdList\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.noNullElements(skuIdList, (String)"skuIdList\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)priceTypeId, (String)"priceTypeId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)sellerOrgId, (String)"sellerOrgId\u4e0d\u80fd\u4e3a\u7a7a");
        BasePriceItemQueryReqDto reqDto = new BasePriceItemQueryReqDto();
        reqDto.setTypeId(priceTypeId);
        reqDto.setOrganizationId(sellerOrgId);
        reqDto.setSkuIdList(skuIdList);
        reqDto.setShopIdList(shopIdList);
        return this.basePriceItemDas.getMapper().selectList(this.getQueryWrapper(reqDto));
    }

    @Override
    public BasePriceItemEo getBrandSkuExchangePrice(Long skuId, Long itemOrgId, List<BasePriceItemEo> brandItemBasePriceList) {
        if (!CollectionUtils.isEmpty(brandItemBasePriceList)) {
            for (BasePriceItemEo basePriceItemEo : brandItemBasePriceList) {
                if (basePriceItemEo.getTypeId() != PriceTypeEnum.EXCHANGE_PRICE.getTypeId() || !basePriceItemEo.getSkuId().equals(skuId) || !basePriceItemEo.getItemOrgId().equals(itemOrgId)) continue;
                return basePriceItemEo;
            }
        }
        return null;
    }

    @Override
    public BasePriceItemEo getBrandSkuRetailPrice(Long skuId, Long itemOrgId, List<BasePriceItemEo> brandItemBasePriceList) {
        if (!CollectionUtils.isEmpty(brandItemBasePriceList)) {
            for (BasePriceItemEo basePriceItemEo : brandItemBasePriceList) {
                if (basePriceItemEo.getTypeId() != PriceTypeEnum.RETAIL_PRICE.getTypeId() || !basePriceItemEo.getSkuId().equals(skuId) || !basePriceItemEo.getItemOrgId().equals(itemOrgId)) continue;
                return basePriceItemEo;
            }
        }
        return null;
    }

    @Override
    public BasePriceItemEo getDealerSkuBasePrice(Long skuId, Long shopId, List<BasePriceItemEo> dealerItemBasePriceList) {
        if (!CollectionUtils.isEmpty(dealerItemBasePriceList)) {
            for (BasePriceItemEo basePriceItemEo : dealerItemBasePriceList) {
                if (basePriceItemEo.getTypeId() != PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId() || !basePriceItemEo.getSkuId().equals(skuId) || !basePriceItemEo.getShopId().equals(shopId)) continue;
                return basePriceItemEo;
            }
        }
        return null;
    }

    @Override
    public List<BasePriceItemSkuQueryRespDto> querySetPriceListByCondition(BasePriceItemSkuQueryReqDto basePriceItemSkuQueryReqDto) {
        return this.basePriceItemDas.querySetPriceListByCondition(basePriceItemSkuQueryReqDto);
    }

    @Override
    public SkuPriceVo getSkuPriceInfo(List<Long> orgIdList, List<Long> shopIdList, List<Long> skuIdList, Date startRenewTime, Date endRenewTime, Long ... typeId) {
        BasePriceItemSkuQueryReqDto basePriceItemSkuQueryReqDto = new BasePriceItemSkuQueryReqDto();
        if (CollUtil.isNotEmpty(orgIdList)) {
            orgIdList = orgIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            basePriceItemSkuQueryReqDto.setOrganizationIdList(orgIdList);
        }
        if (CollUtil.isNotEmpty(shopIdList)) {
            shopIdList = shopIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            basePriceItemSkuQueryReqDto.setShopIdList(shopIdList);
        }
        if (CollUtil.isNotEmpty(skuIdList)) {
            skuIdList = skuIdList.stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            basePriceItemSkuQueryReqDto.setSkuIdList(skuIdList);
        }
        basePriceItemSkuQueryReqDto.setStartRenewTime(startRenewTime);
        basePriceItemSkuQueryReqDto.setEndRenewTime(endRenewTime);
        basePriceItemSkuQueryReqDto.setTypeIdList((List)(Objects.isNull(typeId) || typeId.length == 0 ? ListUtil.toList((Object[])new Long[]{PriceTypeEnum.RETAIL_PRICE.getTypeId(), PriceTypeEnum.EXCHANGE_PRICE.getTypeId(), PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId()}) : ListUtil.toList((Object[])typeId)));
        List<BasePriceItemSkuQueryRespDto> skuList = this.querySetPriceListByCondition(basePriceItemSkuQueryReqDto);
        SkuPriceVo skuPriceVo = new SkuPriceVo();
        for (BasePriceItemSkuQueryRespDto item : skuList) {
            skuPriceVo.addInfo(item.getShopId(), item.getSkuId(), item.getSkuPriceMap());
            skuPriceVo.addUpdateTime(item.getShopId(), item.getSkuId(), item.getUpdateTime());
        }
        return skuPriceVo;
    }

    @Override
    public PageInfo<ItemSkuRetailPriceRespDto> querySkuRetailPriceByPage(ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto, Integer pageNum, Integer pageSize) {
        Long orgId = this.customerHelper.getOrgId();
        Integer channel = itemSkuRetailPriceReqDto.getChannel();
        if (Objects.equals(channel, CustomerTypeEnum.DEALER.getCode())) {
            return this.dealerSkuRetailPrice(orgId, itemSkuRetailPriceReqDto, pageNum, pageSize);
        }
        return this.brandSkuRetailPrice(orgId, itemSkuRetailPriceReqDto, pageNum, pageSize);
    }

    @Override
    public ItemSkuRetailPriceCountRespDto countSkuRetailPrice(ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto) {
        Long orgId = this.customerHelper.getOrgId();
        ItemSkuOptionalQueryReqDto itemSkuOptionalQueryReqDto = new ItemSkuOptionalQueryReqDto();
        DtoHelper.vo2Dto((BaseVo)itemSkuRetailPriceReqDto, (BaseVo)itemSkuOptionalQueryReqDto);
        itemSkuOptionalQueryReqDto.setOrgId(orgId);
        SkuPriceVo skuPriceVo = this.getSkuPriceInfo(ListUtil.toList((Object[])new Long[]{orgId}), Objects.isNull(itemSkuRetailPriceReqDto.getShopId()) ? null : ListUtil.toList((Object[])new Long[]{itemSkuRetailPriceReqDto.getShopId()}), null, null, null, new Long[0]);
        int setNum = skuPriceVo.getSkuIdList().size();
        PageInfo<ItemSkuOptionalQueryRespDto> itemSkuQueryRespDtoPageInfo = this.basePriceApplyItemService.queryOptionalItemByPage(itemSkuOptionalQueryReqDto, 1, 1);
        long total = itemSkuQueryRespDtoPageInfo.getTotal();
        return new ItemSkuRetailPriceCountRespDto(Long.valueOf(total), Long.valueOf(setNum), Long.valueOf(total - (long)setNum));
    }

    @Override
    public List<ItemSkuPriceQueryRespDto> querySkuPrice(ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto) {
        List shopConditionList = itemSkuPriceQueryReqDto.getShopConditionList();
        if (CollUtil.isEmpty((Collection)shopConditionList)) {
            return ListUtil.empty();
        }
        ArrayList shopIdList = ListUtil.toList((Object[])new Long[0]);
        ArrayList skuIdList = ListUtil.toList((Object[])new Long[0]);
        ArrayList list = ListUtil.toList((Object[])new ItemSkuPriceQueryRespDto[0]);
        for (ItemSkuPriceConditionQueryReqDto itemSkuPriceConditionQueryReqDto : shopConditionList) {
            Long shopId = itemSkuPriceConditionQueryReqDto.getShopId();
            shopIdList.add(shopId);
            Long skuId = itemSkuPriceConditionQueryReqDto.getSkuId();
            skuIdList.add(skuId);
            ItemSkuPriceQueryRespDto itemSkuPriceQueryRespDto = new ItemSkuPriceQueryRespDto();
            itemSkuPriceQueryRespDto.setSkuId(skuId);
            itemSkuPriceQueryRespDto.setShopId(shopId);
            list.add(itemSkuPriceQueryRespDto);
        }
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        basePriceItemEo.setTypeId(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId());
        if (Objects.nonNull(itemSkuPriceQueryReqDto.getPriceTypeId())) {
            basePriceItemEo.setTypeId(itemSkuPriceQueryReqDto.getPriceTypeId());
        }
        LambdaQueryWrapper<BasePriceItemEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(basePriceItemEo);
        queryWrapper.in(StdBasePriceItemEo::getShopId, (Collection)shopIdList);
        queryWrapper.in(StdBasePriceItemEo::getSkuId, (Collection)skuIdList);
        List basePriceItemEos = this.basePriceItemDas.getMapper().selectList(queryWrapper);
        Map<String, List<BasePriceItemEo>> shopSkuMap = basePriceItemEos.stream().collect(Collectors.groupingBy(item -> item.getShopId() + "-" + item.getSkuId()));
        for (ItemSkuPriceQueryRespDto itemSkuPriceQueryRespDto : list) {
            String key = itemSkuPriceQueryRespDto.getShopId() + "-" + itemSkuPriceQueryRespDto.getSkuId();
            if (!shopSkuMap.containsKey(key)) continue;
            Map<Long, BigDecimal> priceMap = shopSkuMap.get(key).stream().collect(Collectors.toMap(StdBasePriceItemEo::getTypeId, StdBasePriceItemEo::getItemPrice, (o1, o2) -> o2));
            itemSkuPriceQueryRespDto.setDealerRetailPrice(priceMap.get(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId()));
            itemSkuPriceQueryRespDto.setCostRetailPrice(priceMap.get(PriceTypeEnum.RETAIL_PRICE.getTypeId()));
        }
        return list.stream().filter(item -> Objects.nonNull(item.getDealerRetailPrice())).collect(Collectors.toList());
    }

    @Override
    public List<ItemSkuPriceQueryRespDto> queryRetailSkuPrice(ItemSkuPriceQueryReqDto itemSkuPriceQueryReqDto) {
        Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap;
        List shopConditionList = itemSkuPriceQueryReqDto.getShopConditionList();
        if (CollUtil.isEmpty((Collection)shopConditionList)) {
            return ListUtil.empty();
        }
        ArrayList shopIdList = ListUtil.toList((Object[])new Long[0]);
        ArrayList skuIdList = ListUtil.toList((Object[])new Long[0]);
        ArrayList list = ListUtil.toList((Object[])new ItemSkuPriceQueryRespDto[0]);
        for (ItemSkuPriceConditionQueryReqDto itemSkuPriceConditionQueryReqDto : shopConditionList) {
            Long shopId = itemSkuPriceConditionQueryReqDto.getShopId();
            shopIdList.add(shopId);
            Long skuId = itemSkuPriceConditionQueryReqDto.getSkuId();
            skuIdList.add(skuId);
            ItemSkuPriceQueryRespDto itemSkuPriceQueryRespDto = new ItemSkuPriceQueryRespDto();
            itemSkuPriceQueryRespDto.setSkuId(skuId);
            itemSkuPriceQueryRespDto.setShopId(shopId);
            list.add(itemSkuPriceQueryRespDto);
        }
        BasePriceItemEo basePriceItemEo = new BasePriceItemEo();
        basePriceItemEo.setTypeId(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId());
        if (Objects.nonNull(itemSkuPriceQueryReqDto.getPriceTypeId())) {
            basePriceItemEo.setTypeId(itemSkuPriceQueryReqDto.getPriceTypeId());
        }
        if (Objects.nonNull(itemSkuPriceQueryReqDto.getPriceTypeIdStr())) {
            basePriceItemEo.setTypeId(null);
        }
        if (CollUtil.isEmpty(skuQueryRespDtoMap = this.skuHelper.querySkuMap(skuIdList))) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        List<Long> ppfOrgIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getItemOrgId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (itemSkuPriceQueryReqDto.getOrgId() != null) {
            ppfOrgIdList.add(itemSkuPriceQueryReqDto.getOrgId());
        }
        if (!CollectionUtils.isEmpty((Collection)shopIdList)) {
            Map<Long, Long> orgIdByShopId = this.shopHelper.getOrgIdByShopId(shopIdList);
            ppfOrgIdList.addAll(orgIdByShopId.values());
        }
        SkuPriceVo skuPriceVo = this.getSkuPriceInfo(ppfOrgIdList, null, skuIdList, null, null, new Long[0]);
        logger.info("\u4ef7\u683cVo\u4fe1\u606f\uff1a{}", (Object)JSON.toIndentJsonString((Object)skuPriceVo));
        if (skuPriceVo == null) {
            return ListUtil.empty();
        }
        logger.info("\u8fd4\u56de\u4ef7\u683clist\u4fe1\u606f\uff1a{}", (Object)JSON.toIndentJsonString((Object)list));
        for (ItemSkuPriceQueryRespDto itemSkuPriceQueryRespDto : list) {
            Map<Long, BigDecimal> skuPrice = skuPriceVo.findSkuPrice(null, itemSkuPriceQueryRespDto.getSkuId());
            logger.info("\u54c1\u724c\u65b9\u5efa\u8bae\u96f6\u552e\u4ef7\uff1a{}", (Object)JSON.toJsonString(skuPrice));
            if (MapUtil.isNotEmpty(skuPrice)) {
                itemSkuPriceQueryRespDto.setCostRetailPrice(skuPrice.get(PriceTypeEnum.RETAIL_PRICE.getTypeId()));
                itemSkuPriceQueryRespDto.setTypeId(PriceTypeEnum.RETAIL_PRICE.getTypeId());
            }
            logger.info("\u7ecf\u9500\u5546\u96f6\u552e\u4ef7\uff1a{}", (Object)JSON.toJsonString(skuPrice));
            Map<Long, BigDecimal> skuPriceMap = skuPriceVo.findSkuPrice(itemSkuPriceQueryRespDto.getShopId(), itemSkuPriceQueryRespDto.getSkuId());
            if (!MapUtil.isNotEmpty(skuPriceMap)) continue;
            itemSkuPriceQueryRespDto.setDealerRetailPrice(skuPriceMap.get(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId()));
        }
        return list;
    }

    private PageInfo<ItemSkuRetailPriceRespDto> dealerSkuRetailPrice(Long orgId, ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto, Integer pageNum, Integer pageSize) {
        List<Long> ppfOrgIdList;
        PageInfo<ItemSkuRetailPriceRespDto> itemSkuRetailPriceRespDtoPageInfo = this.brandSkuRetailPrice(orgId, itemSkuRetailPriceReqDto, pageNum, pageSize);
        List list = itemSkuRetailPriceRespDtoPageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return itemSkuRetailPriceRespDtoPageInfo;
        }
        List<Long> shopIdList = list.stream().map(ItemSkuRetailPriceRespDto::getShopId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> skuIdList = list.stream().map(ItemSkuQueryRespDto::getSkuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, Integer> skuShelfStatusMap = this.skuHelper.getSkuShelfStatus(shopIdList, skuIdList);
        List<Long> customerIdList = this.customerHelper.getCustomerIdList();
        Map<Long, ItemSkuQueryRespDto> skuQueryRespDtoMap = this.skuHelper.querySkuMap(skuIdList);
        if (CollUtil.isEmpty(skuQueryRespDtoMap)) {
            BizExceptionHelper.throwBizException((IExceptionCode)PriceExceptionCode.INVALID_ITEM_DATA);
        }
        if (CollUtil.isEmpty(ppfOrgIdList = skuQueryRespDtoMap.values().stream().map(ItemSkuQueryRespDto::getItemOrgId).filter(Objects::nonNull).distinct().collect(Collectors.toList()))) {
            return itemSkuRetailPriceRespDtoPageInfo;
        }
        List<PriceBasicConfigRespDto> configList = this.priceBasicConfigService.getBasicConfigByOrgIdAndConfigType(ppfOrgIdList, PriceBasicConfigEnum.ConfigType.PRICE_SETTING);
        Map orgConfigMap = configList.stream().collect(Collectors.toMap(PriceBasicConfigRespDto::getOrganizationId, Function.identity(), (o1, o2) -> o2));
        SkuPriceVo skuPriceVo = this.getSkuPriceInfo(ppfOrgIdList, null, skuIdList, null, null, new Long[0]);
        PriceLimitEsQueryReqDto priceLimitEsQueryReqDto = new PriceLimitEsQueryReqDto();
        priceLimitEsQueryReqDto.setQueryBestMatch(Integer.valueOf(1));
        priceLimitEsQueryReqDto.setCustomerIdList(customerIdList);
        priceLimitEsQueryReqDto.setSkuIdList(skuIdList);
        priceLimitEsQueryReqDto.setOrganizationIdList(ppfOrgIdList);
        logger.info("[\u4ef7\u76d8\u67e5\u8be2] >>> \u5ba2\u6237{}\u5728\u54c1\u724c\u65b9{}\u4e0b\u67e5\u8be2\u9488\u5bf9sku:{}\u67e5\u8be2\u751f\u6548\u7684\u6700\u5339\u914d\u7684\u4ef7\u76d8", new Object[]{customerIdList, ppfOrgIdList, skuIdList});
        Map<String, List<PriceLimitPolicyEsDto>> priceLimitMap = this.priceLimitPolicyEsService.queryPriceLimitPolicy(priceLimitEsQueryReqDto);
        String priceLimitStr = JSON.toJsonString(priceLimitMap);
        logger.info("[\u4ef7\u76d8\u67e5\u8be2] >>> \u67e5\u8be2\u7ed3\u679c\u5982\u4e0b\uff1a{}", (Object)priceLimitStr);
        for (ItemSkuRetailPriceRespDto itemSkuRetailPriceRespDto : list) {
            Map skuPriceMap;
            Map<Long, BigDecimal> skuPrice;
            Long itemId = itemSkuRetailPriceRespDto.getItemId();
            Long shopId = itemSkuRetailPriceRespDto.getShopId();
            Long skuId = itemSkuRetailPriceRespDto.getSkuId();
            ItemSkuPriceInfoRespDto skuPriceInfo = new ItemSkuPriceInfoRespDto();
            if (orgConfigMap.containsKey(itemId)) {
                skuPriceInfo.setControlType(((PriceBasicConfigRespDto)orgConfigMap.get(itemId)).getControlType());
            }
            if (MapUtil.isNotEmpty(skuPrice = skuPriceVo.findSkuPrice(null, skuId))) {
                skuPriceInfo.setExchangePrice(skuPrice.get(PriceTypeEnum.EXCHANGE_PRICE.getTypeId()));
                skuPriceInfo.setRetailPrice(skuPrice.get(PriceTypeEnum.RETAIL_PRICE.getTypeId()));
            }
            if (MapUtil.isNotEmpty((Map)(skuPriceMap = itemSkuRetailPriceRespDto.getSkuPriceMap())) && Objects.isNull(skuPriceInfo.getDealerRetailPrice())) {
                skuPriceInfo.setDealerRetailPrice((BigDecimal)skuPriceMap.get(PriceTypeEnum.DEALER_RETAIL_PRICE.getTypeId()));
            }
            this.priceHelper.setPriceLimit(customerIdList, priceLimitMap, skuId, skuPriceInfo);
            itemSkuRetailPriceRespDto.setItemSkuPriceInfo(skuPriceInfo);
            String key = shopId + "-" + skuId;
            if (!skuShelfStatusMap.containsKey(key)) continue;
            itemSkuRetailPriceRespDto.setShelfStatus(skuShelfStatusMap.get(key));
        }
        return itemSkuRetailPriceRespDtoPageInfo;
    }

    private PageInfo<ItemSkuRetailPriceRespDto> brandSkuRetailPrice(Long orgId, ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto, Integer pageNum, Integer pageSize) {
        Integer status = itemSkuRetailPriceReqDto.getStatus();
        ItemSkuOptionalQueryReqDto itemSkuOptionalQueryReqDto = new ItemSkuOptionalQueryReqDto();
        DtoHelper.vo2Dto((BaseVo)itemSkuRetailPriceReqDto, (BaseVo)itemSkuOptionalQueryReqDto);
        itemSkuOptionalQueryReqDto.setOrgId(orgId);
        SkuPriceVo skuPriceVo = this.getSkuPriceInfo(ListUtil.toList((Object[])new Long[]{orgId}), Objects.isNull(itemSkuRetailPriceReqDto.getShopId()) ? null : ListUtil.toList((Object[])new Long[]{itemSkuRetailPriceReqDto.getShopId()}), null, itemSkuRetailPriceReqDto.getStartRenewTime(), itemSkuRetailPriceReqDto.getEndRenewTime(), new Long[0]);
        if (Objects.equals(SetStatusEnum.SET.getCode(), status)) {
            if (CollUtil.isEmpty(skuPriceVo.getSkuIdList())) {
                return new PageInfo(ListUtil.empty());
            }
            itemSkuOptionalQueryReqDto.setInSkuIdList(skuPriceVo.getSkuIdList());
        } else if (Objects.equals(SetStatusEnum.NOT_SET.getCode(), status)) {
            itemSkuOptionalQueryReqDto.setOutSkuIdList(skuPriceVo.getSkuIdList());
        } else if (itemSkuRetailPriceReqDto.getStartRenewTime() != null || itemSkuRetailPriceReqDto.getEndRenewTime() != null) {
            if (CollectionUtils.isEmpty(skuPriceVo.getSkuIdList())) {
                return new PageInfo(ListUtil.empty());
            }
            itemSkuOptionalQueryReqDto.setInSkuIdList(skuPriceVo.getSkuIdList());
        }
        PageInfo<ItemSkuOptionalQueryRespDto> itemSkuQueryRespDtoPageInfo = this.basePriceApplyItemService.queryOptionalItemByPage(itemSkuOptionalQueryReqDto, pageNum, pageSize);
        List list = itemSkuQueryRespDtoPageInfo.getList();
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, itemSkuQueryRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollUtil.isEmpty((Collection)list)) {
            return pageInfo;
        }
        List<ItemSkuRetailPriceRespDto> dataList = list.stream().map(item -> {
            ItemSkuRetailPriceRespDto itemSkuRetailPriceRespDto = new ItemSkuRetailPriceRespDto();
            DtoHelper.vo2Dto((BaseVo)item, (BaseVo)itemSkuRetailPriceRespDto);
            itemSkuRetailPriceRespDto.setSkuPriceMap(MapUtil.empty());
            return itemSkuRetailPriceRespDto;
        }).collect(Collectors.toList());
        if (!Objects.equals(SetStatusEnum.SET.getCode(), status)) {
            if (Objects.equals(SetStatusEnum.NOT_SET.getCode(), status)) {
                this.setShopName(dataList, null);
                pageInfo.setList(dataList);
                return pageInfo;
            }
            List<Long> skuIdList = dataList.stream().map(ItemSkuQueryRespDto::getSkuId).collect(Collectors.toList());
            skuPriceVo = this.getSkuPriceInfo(ListUtil.toList((Object[])new Long[]{orgId}), ListUtil.toList((Object[])new Long[]{itemSkuRetailPriceReqDto.getShopId()}), skuIdList, null, null, new Long[0]);
        }
        if (Objects.isNull(skuPriceVo)) {
            this.setShopName(dataList, null);
            pageInfo.setList(dataList);
            return pageInfo;
        }
        this.setShopName(dataList, skuPriceVo.getShopIdList());
        for (ItemSkuRetailPriceRespDto itemSkuRetailPriceRespDto : dataList) {
            Long shopId = itemSkuRetailPriceRespDto.getShopId();
            Long skuId = itemSkuRetailPriceRespDto.getSkuId();
            itemSkuRetailPriceRespDto.setSkuPriceMap(skuPriceVo.findSkuPrice(shopId, skuId));
            ItemSkuPriceInfoRespDto skuPriceInfo = new ItemSkuPriceInfoRespDto();
            skuPriceInfo.setRetailPrice((BigDecimal)itemSkuRetailPriceRespDto.getSkuPriceMap().get(PriceTypeEnum.RETAIL_PRICE.getTypeId()));
            skuPriceInfo.setExchangePrice((BigDecimal)itemSkuRetailPriceRespDto.getSkuPriceMap().get(PriceTypeEnum.EXCHANGE_PRICE.getTypeId()));
            itemSkuRetailPriceRespDto.setItemSkuPriceInfo(skuPriceInfo);
            itemSkuRetailPriceRespDto.setUpdateTime(skuPriceVo.findSkuUpdateTime(shopId, skuId));
        }
        pageInfo.setList(dataList);
        return pageInfo;
    }

    private void setShopName(List<ItemSkuRetailPriceRespDto> dataList, List<Long> shopIdList) {
        Map<Long, String> shopNameMap;
        List shopIdList1 = dataList.stream().map(ItemSkuRetailPriceRespDto::getShopId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (Objects.isNull(shopIdList)) {
            shopIdList = shopIdList1;
        } else {
            shopIdList.addAll(shopIdList1);
        }
        Map<Long, String> map = shopNameMap = CollUtil.isEmpty(shopIdList) ? MapUtil.empty() : this.shopHelper.getShopNameMap(shopIdList);
        if (CollUtil.isEmpty(shopNameMap)) {
            return;
        }
        for (ItemSkuRetailPriceRespDto itemSkuRetailPriceRespDto : dataList) {
            Long shopId = itemSkuRetailPriceRespDto.getShopId();
            if (!Objects.nonNull(shopId) || !shopNameMap.containsKey(shopId)) continue;
            itemSkuRetailPriceRespDto.setShopName(shopNameMap.get(shopId));
        }
    }
}

