/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.constants.RelateTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.CustomerConditionQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.CustomerConditionRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.ICustomerConditionService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.CustomerConditionDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.CustomerConditionEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdCustomerConditionEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerConditionServiceImpl
implements ICustomerConditionService {
    @Resource
    private CustomerConditionDas customerConditionDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerCondition(CustomerConditionAddReqDto reqDto) {
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerConditionEo);
        this.customerConditionDas.insert((BaseEo)customerConditionEo);
        return customerConditionEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomerCondition(CustomerConditionModifyReqDto reqDto) {
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerConditionEo);
        this.customerConditionDas.updateSelective((BaseEo)customerConditionEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCondition(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerConditionDas.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public CustomerConditionRespDto queryCustomerConditionById(Long id) {
        CustomerConditionEo customerConditionEo = (CustomerConditionEo)this.customerConditionDas.selectByPrimaryKey(id);
        if (customerConditionEo == null) {
            return null;
        }
        CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
        DtoHelper.eo2Dto((BaseEo)customerConditionEo, (BaseVo)customerConditionRespDto);
        return customerConditionRespDto;
    }

    @Override
    public PageInfo<CustomerConditionRespDto> queryCustomerConditionByPage(CustomerConditionQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerConditionEo);
        PageInfo eoPageInfo = this.customerConditionDas.selectPage((BaseEo)customerConditionEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerConditionRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<Long, CustomerConditionRespDto> getPriceCustomerConditionMap(RelateTypeEnum relateTypeEnum, List<Long> relateIdList) {
        if (Objects.isNull(relateTypeEnum) || CollUtil.isEmpty(relateIdList)) {
            return MapUtil.empty();
        }
        CustomerConditionEo customerConditionEo = new CustomerConditionEo();
        customerConditionEo.setRelateType(relateTypeEnum.getType());
        LambdaQueryWrapper<CustomerConditionEo> queryWrapper = MybatisPlusUtils.newLambdaQueryWrapper(customerConditionEo);
        queryWrapper.in(StdCustomerConditionEo::getRelateId, relateIdList);
        List customerConditionEos = this.customerConditionDas.getMapper().selectList(queryWrapper);
        return customerConditionEos.stream().map(item -> {
            CustomerConditionRespDto respDto = new CustomerConditionRespDto();
            respDto.setCustomerIds(StrUtil.isBlank((CharSequence)item.getCustomerIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getCustomerIds().split(",")));
            respDto.setCustomerIdNum(Integer.valueOf(respDto.getCustomerIds().size()));
            respDto.setCustomerTypeIds(StrUtil.isBlank((CharSequence)item.getCustomerTypeIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getCustomerTypeIds().split(",")));
            respDto.setCustomerTypeIdNum(Integer.valueOf(respDto.getCustomerTypeIds().size()));
            respDto.setCustomerAreaCodes(StrUtil.isBlank((CharSequence)item.getCustomerAreaCodes()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getCustomerAreaCodes().split(",")));
            respDto.setCustomerAreaCodeNum(Integer.valueOf(respDto.getCustomerAreaCodes().size()));
            respDto.setCustomerGroupIds(StrUtil.isBlank((CharSequence)item.getCustomerGroupIds()) ? ListUtil.empty() : ListUtil.toList((Object[])item.getCustomerGroupIds().split(",")));
            respDto.setCustomerGroupIdNum(Integer.valueOf(respDto.getCustomerGroupIds().size()));
            return respDto;
        }).collect(Collectors.toMap(CustomerConditionRespDto::getRelateId, Function.identity(), (o1, o2) -> o2));
    }
}

