/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceCategoryModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceCategoryQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceCategoryRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceCategoryService;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceCategoryDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceCategoryEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceCategoryServiceImpl
implements IPriceCategoryService {
    @Resource
    private PriceCategoryDas priceCategoryDas;
    @Resource
    private IContext context;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPriceCategory(PriceCategoryModifyReqDto reqDto) {
        this.validateShowName(reqDto.getId(), reqDto.getCategoryShow());
        PriceCategoryEo priceCategoryEo = new PriceCategoryEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceCategoryEo);
        this.priceCategoryDas.updateSelective((BaseEo)priceCategoryEo);
    }

    @Override
    public PageInfo<PriceCategoryRespDto> queryPriceCategoryByPage(PriceCategoryQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        PriceCategoryEo priceCategoryEo = new PriceCategoryEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceCategoryEo);
        priceCategoryEo.setTenantId(this.context.tenantId());
        priceCategoryEo.setInstanceId(this.context.instanceId());
        PageInfo eoPageInfo = this.priceCategoryDas.selectPage((BaseEo)priceCategoryEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PriceCategoryRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<PriceCategoryRespDto> queryPriceCategoryList(String categoryCode) {
        ArrayList<PriceCategoryRespDto> result = new ArrayList<PriceCategoryRespDto>();
        PriceCategoryEo condition = new PriceCategoryEo();
        condition.setCategoryCode(categoryCode);
        condition.setInstanceId(this.context.instanceId());
        condition.setTenantId(this.context.tenantId());
        List priceCategoryEoList = this.priceCategoryDas.selectList((BaseEo)condition);
        CubeBeanUtils.copyCollection(result, (Collection)priceCategoryEoList, PriceCategoryRespDto.class);
        return result;
    }

    private void validateShowName(Long id, String showName) {
        PriceCategoryEo priceCategoryEo = new PriceCategoryEo();
        priceCategoryEo.setCategoryShow(showName);
        List eoList = this.priceCategoryDas.select((BaseEo)priceCategoryEo);
        if (null != eoList && !eoList.isEmpty()) {
            eoList.forEach(eo -> {
                if (!eo.getId().equals(id)) {
                    throw new BizException("\u663e\u793a\u540d\u79f0\u91cd\u590d~");
                }
            });
        }
    }
}

