/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.es.PriceLimitPolicyEsSkuExtDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitEsQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceLimitSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceLimitSkuDetailRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.ISkuPriceLimitQueryService;
import com.dtyunxi.yundt.cube.center.price.biz.service.es.IPriceLimitPolicyEsService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SkuPriceLimitQueryServiceImpl
implements ISkuPriceLimitQueryService {
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IPriceLimitPolicyEsService priceLimitPolicyEsService;

    @Override
    public PageInfo<PriceLimitSkuDetailRespDto> queryCustSkuPriceLimitByPage(PriceLimitSkuQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        Assert.notNull((Object)reqDto.getCustomerId(), (String)"\u5ba2\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        Long itemOrgInfoId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        itemSkuQueryReqDto.setItemOrgId(itemOrgInfoId);
        itemSkuQueryReqDto.setSkuCode(reqDto.getSkuCode());
        itemSkuQueryReqDto.setKeyword(reqDto.getItemName());
        PageInfo skuQueryRespDtoPage = (PageInfo)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, pageNum, pageSize).getData();
        if (CollectionUtils.isEmpty((Collection)skuQueryRespDtoPage.getList())) {
            return new PageInfo();
        }
        PageInfo result = new PageInfo();
        ArrayList skuDetailRespDtos = new ArrayList();
        CubeBeanUtils.copyCollection(skuDetailRespDtos, (Collection)skuQueryRespDtoPage.getList(), PriceLimitSkuDetailRespDto.class);
        CubeBeanUtils.copyProperties((Object)result, (Object)skuQueryRespDtoPage, (String[])new String[]{"list", "navigatepageNums"});
        result.setList(skuDetailRespDtos);
        List skuIds = skuQueryRespDtoPage.getList().stream().map(e -> e.getSkuId()).collect(Collectors.toList());
        PriceLimitEsQueryReqDto limitEsReqDto = new PriceLimitEsQueryReqDto();
        limitEsReqDto.setOrganizationIdList(Arrays.asList(itemOrgInfoId));
        limitEsReqDto.setCustomerIdList(Arrays.asList(reqDto.getCustomerId()));
        limitEsReqDto.setSkuIdList(skuIds);
        limitEsReqDto.setPolicyDate(new Date());
        limitEsReqDto.setPolicyCode(reqDto.getPolicyCode());
        Map<String, List<PriceLimitPolicyEsDto>> skuEsLimitDtoMap = this.priceLimitPolicyEsService.queryPriceLimitPolicy(limitEsReqDto);
        Date now = new Date();
        if (!CollectionUtils.isEmpty(skuEsLimitDtoMap)) {
            for (PriceLimitSkuDetailRespDto skuDetailRespDto : skuDetailRespDtos) {
                Long curSkuId = skuDetailRespDto.getSkuId();
                String tmpKey = String.valueOf(reqDto.getCustomerId()) + "-" + String.valueOf(curSkuId);
                List<PriceLimitPolicyEsDto> limitPolicyEsDtos = skuEsLimitDtoMap.get(tmpKey);
                if (CollectionUtils.isEmpty(limitPolicyEsDtos)) continue;
                Comparator limitPriorityComp = this.priceLimitPolicyEsService.getDefaultLimitPriorityComp();
                limitPolicyEsDtos.sort(limitPriorityComp);
                AtomicReference<Integer> rankNo = new AtomicReference<Integer>(0);
                List esSkuExtDtoList = limitPolicyEsDtos.stream().filter(e -> e.getEffectiveTime() == null || e.getEffectiveTime().getTime() <= now.getTime()).map(limitEsDto -> {
                    PriceLimitPolicyEsSkuExtDto skuExtDto = new PriceLimitPolicyEsSkuExtDto();
                    rankNo.updateAndGet(v -> v + 1);
                    skuExtDto.setRankNo((Integer)rankNo.get());
                    CubeBeanUtils.copyProperties((Object)skuExtDto, (Object)limitEsDto, (String[])new String[]{""});
                    skuExtDto.setItemRangeDescList(limitEsDto.getItemRangeList());
                    skuExtDto.setCustomerRangeDescList(limitEsDto.getCustomerRangeDescList());
                    BigDecimal lowerLimit = limitEsDto.getSkuLowerLimit(curSkuId);
                    BigDecimal upperLimit = limitEsDto.getSkuUpperLimit(curSkuId);
                    skuExtDto.setSkuLowerLimit(lowerLimit);
                    skuExtDto.setSkuUpperLimit(upperLimit);
                    skuExtDto.setSkuId(curSkuId);
                    return skuExtDto;
                }).collect(Collectors.toList());
                skuDetailRespDto.setSkuLimitPolicyExtDtoList(esSkuExtDtoList);
            }
        }
        return result;
    }
}

