/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.helper;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemSkuQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IShelfQueryApi;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.vo.SkuPriceVo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class SkuHelper {
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IBasePriceItemService basePriceItemService;
    @Resource
    private IShelfQueryApi shelfQueryApi;

    public List<ItemSkuQueryRespDto> querySkuList(List<Long> skuIdList) {
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setInSkuIdList(skuIdList);
        PageInfo skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(skuIdList.size())));
        if (Objects.isNull(skuPage) || CollUtil.isEmpty((Collection)skuPage.getList())) {
            return ListUtil.empty();
        }
        return skuPage.getList();
    }

    public Map<Long, ItemSkuQueryRespDto> querySkuMap(List<Long> skuIdList) {
        return this.querySkuList(skuIdList).stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getSkuId, Function.identity(), (o1, o2) -> o2));
    }

    public SkuPriceVo getSkuPriceInfo(List<Long> orgIdList, List<Long> shopIdList, List<Long> skuIdList, Long ... typeId) {
        return this.basePriceItemService.getSkuPriceInfo(orgIdList, shopIdList, skuIdList, typeId);
    }

    public Map<String, Integer> getSkuShelfStatus(List<Long> shopIdList, List<Long> skuIdList) {
        ShelfQueryReqDto shelfQueryReqDto = new ShelfQueryReqDto();
        shelfQueryReqDto.setShopIds(shopIdList);
        shelfQueryReqDto.setSkuIds(skuIdList);
        List shelfQueryRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.shelfQueryApi.queryShelfList(shelfQueryReqDto));
        if (CollUtil.isEmpty((Collection)shelfQueryRespDtos)) {
            return MapUtil.empty();
        }
        return shelfQueryRespDtos.stream().collect(Collectors.toMap(item -> item.getShopId() + "-" + item.getSkuId(), ShelfQueryRespDto::getStatus, (o1, o2) -> o2));
    }

    public Map<String, ItemSkuQueryRespDto> querySkuMap(List<String> skuCodeList, Long shopId) {
        PageInfo skuPage;
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setSkuCodeList(skuCodeList);
        if (Objects.nonNull(shopId)) {
            itemSkuQueryReqDto.setShopIdList((List)ListUtil.toList((Object[])new Long[]{shopId}));
            itemSkuQueryReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        if (Objects.isNull(skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(skuCodeList.size())))) || CollUtil.isEmpty((Collection)skuPage.getList())) {
            return MapUtil.empty();
        }
        return skuPage.getList().stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getSkuCode, Function.identity(), (o1, o2) -> o2));
    }

    public Map<String, ItemSkuQueryRespDto> querySkuMapByItemCodeListAndShopId(List<String> itemCodeList, Long shopId) {
        PageInfo skuPage;
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setItemCodeList(itemCodeList);
        if (Objects.nonNull(shopId)) {
            itemSkuQueryReqDto.setShopIdList((List)ListUtil.toList((Object[])new Long[]{shopId}));
            itemSkuQueryReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        if (Objects.isNull(skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemCodeList.size())))) || CollUtil.isEmpty((Collection)skuPage.getList())) {
            return MapUtil.empty();
        }
        return skuPage.getList().stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getItemCode, Function.identity(), (o1, o2) -> o2));
    }

    public Map<String, ItemSkuQueryRespDto> querySkuMap(List<String> skuCodeList, Long shopId, Long itemOrgId) {
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setSkuCodeList(skuCodeList);
        if (Objects.nonNull(shopId)) {
            itemSkuQueryReqDto.setShopIdList((List)ListUtil.toList((Object[])new Long[]{shopId}));
            itemSkuQueryReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        itemSkuQueryReqDto.setItemOrgId(itemOrgId);
        PageInfo skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(skuCodeList.size())));
        if (Objects.isNull(skuPage) || CollUtil.isEmpty((Collection)skuPage.getList())) {
            return MapUtil.empty();
        }
        return skuPage.getList().stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getSkuCode, Function.identity(), (o1, o2) -> o2));
    }

    public Map<String, ItemSkuQueryRespDto> querySkuMapByItemCodeListAndShopId(List<String> itemCodeList, Long shopId, Long itemOrgId) {
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setItemCodeList(itemCodeList);
        if (Objects.nonNull(shopId)) {
            itemSkuQueryReqDto.setShopIdList((List)ListUtil.toList((Object[])new Long[]{shopId}));
            itemSkuQueryReqDto.setChannel(CustomerTypeEnum.DEALER.getCode());
        }
        itemSkuQueryReqDto.setItemOrgId(itemOrgId);
        PageInfo skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(itemCodeList.size())));
        if (Objects.isNull(skuPage) || CollUtil.isEmpty((Collection)skuPage.getList())) {
            return MapUtil.empty();
        }
        return skuPage.getList().stream().collect(Collectors.toMap(ItemSkuQueryRespDto::getItemCode, Function.identity(), (o1, o2) -> o2));
    }

    public List<ItemSkuQueryRespDto> getSkuList(Long orgId) {
        ItemSkuQueryReqDto itemSkuQueryReqDto = new ItemSkuQueryReqDto();
        itemSkuQueryReqDto.setItemOrgId(orgId);
        PageInfo skuPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.querySkuPage(itemSkuQueryReqDto, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
        return skuPage.getList();
    }
}

