/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl;

import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.yundt.cube.center.price.api.constants.ExcelUseTypeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.item.ItemSkuRetailPriceReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.ItemSkuPriceInfoRespDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.item.ItemSkuRetailPriceRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IBasePriceItemService;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.IExportSevice;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.impl.BaseExportImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.poi.ExcelExportStylerCustomImpl;
import com.dtyunxi.yundt.cube.center.price.biz.service.excel.vo.ItemSkuRetailPriceExportVo;
import com.github.pagehelper.PageInfo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RetailPriceExportImpl
extends BaseExportImpl
implements IExportSevice<ItemSkuRetailPriceExportVo, ItemSkuRetailPriceReqDto> {
    private static final Logger log = LoggerFactory.getLogger(RetailPriceExportImpl.class);
    public static final Integer PAGE_SIZE = 500;
    @Resource
    private IBasePriceItemService basePriceItemService;

    @Override
    public ExcelUseTypeEnum excelUseType() {
        return ExcelUseTypeEnum.EXPORT_RETAIL_PRICE;
    }

    @Override
    public Class<ItemSkuRetailPriceExportVo> pojoClass() {
        return ItemSkuRetailPriceExportVo.class;
    }

    @Override
    public ExportParams exportParams() {
        ExportParams exportParams = new ExportParams();
        exportParams.setTitleHeight((short)30);
        exportParams.setStyle(ExcelExportStylerCustomImpl.class);
        exportParams.setType(ExcelType.XSSF);
        return exportParams;
    }

    @Override
    public String fileName() {
        return "\u5efa\u8bae\u96f6\u552e\u4ef7\u5bfc\u51fa\u7ed3\u679c" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd") + "." + "xlsx";
    }

    @Override
    public List<ItemSkuRetailPriceExportVo> exportDataList(ItemSkuRetailPriceReqDto itemSkuRetailPriceReqDto, Integer pageNum) {
        PageInfo<ItemSkuRetailPriceRespDto> pageInfo = this.basePriceItemService.querySkuRetailPriceByPage(itemSkuRetailPriceReqDto, pageNum, PAGE_SIZE);
        List list = pageInfo.getList();
        if (CollUtil.isEmpty((Collection)list)) {
            return ListUtil.empty();
        }
        AtomicInteger serialNumber = new AtomicInteger((pageNum - 1) * PAGE_SIZE);
        return list.stream().map(item -> {
            ItemSkuRetailPriceExportVo itemSkuRetailPriceExportVo = new ItemSkuRetailPriceExportVo();
            itemSkuRetailPriceExportVo.setSerialNumber(serialNumber.incrementAndGet());
            itemSkuRetailPriceExportVo.setItemName(item.getItemName());
            itemSkuRetailPriceExportVo.setBrandName(item.getBrandName());
            itemSkuRetailPriceExportVo.setItemCode(item.getItemCode());
            itemSkuRetailPriceExportVo.setSkuCode(item.getSkuCode());
            if (StrUtil.isNotBlank((CharSequence)item.getSkuAttr())) {
                Map map = (Map)JSON.parseObject((String)item.getSkuAttr(), Map.class);
                String skuAttr = map.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(";"));
                itemSkuRetailPriceExportVo.setSkuAttr(skuAttr);
            }
            itemSkuRetailPriceExportVo.setDirName(item.getDirName());
            itemSkuRetailPriceExportVo.setGiftBox(item.getGiftBox());
            ItemSkuPriceInfoRespDto itemSkuPriceInfo = item.getItemSkuPriceInfo();
            if (Objects.nonNull(itemSkuPriceInfo)) {
                itemSkuRetailPriceExportVo.setRetailPrice(itemSkuPriceInfo.getRetailPrice());
                itemSkuRetailPriceExportVo.setExchangePrice(itemSkuPriceInfo.getExchangePrice());
            }
            return itemSkuRetailPriceExportVo;
        }).collect(Collectors.toList());
    }
}

