/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceBasicConfigEnum;
import com.dtyunxi.yundt.cube.center.price.api.constants.PriceCommonEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBasicConfigAddReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBasicConfigModifyReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceBasicConfigQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceBasicConfigRespDto;
import com.dtyunxi.yundt.cube.center.price.biz.service.IPriceBasicConfigService;
import com.dtyunxi.yundt.cube.center.price.biz.util.MybatisPlusUtils;
import com.dtyunxi.yundt.cube.center.price.dao.das.PriceBasicConfigDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceBasicConfigEo;
import com.dtyunxi.yundt.cube.center.price.dao.eo.StdPriceBasicConfigEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PriceBasicConfigServiceImpl
implements IPriceBasicConfigService {
    private static final Logger logger = LoggerFactory.getLogger(PriceBasicConfigServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private PriceBasicConfigDas priceBasicConfigDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addPriceBasicConfig(PriceBasicConfigAddReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceBasicConfigEo);
        priceBasicConfigEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData());
        PriceBasicConfigEo configEo = new PriceBasicConfigEo();
        configEo.setConfigType(priceBasicConfigEo.getConfigType());
        configEo.setOrganizationId(priceBasicConfigEo.getOrganizationId());
        configEo.setCategoryCode(priceBasicConfigEo.getCategoryCode());
        if (CollUtil.isNotEmpty((Collection)this.priceBasicConfigDas.select((BaseEo)configEo))) {
            return null;
        }
        this.priceBasicConfigDas.insert((BaseEo)priceBasicConfigEo);
        logger.info("\u65b0\u589e\u57fa\u7840\u914d\u7f6e userId={},\u5185\u5bb9={}", (Object)this.context.userId(), (Object)JSON.toJSONString((Object)reqDto));
        return priceBasicConfigEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchPriceBasicConfig(List<PriceBasicConfigAddReqDto> reqDtoList) {
        if (CollUtil.isEmpty(reqDtoList)) {
            return ListUtil.empty();
        }
        ArrayList priceBasicConfigEoList = ListUtil.toList((Object[])new PriceBasicConfigEo[0]);
        DtoHelper.dtoList2EoList(reqDtoList, (Collection)priceBasicConfigEoList, PriceBasicConfigEo.class);
        if (CollUtil.isEmpty((Collection)priceBasicConfigEoList)) {
            return ListUtil.empty();
        }
        for (PriceBasicConfigEo priceBasicConfigEo : priceBasicConfigEoList) {
            priceBasicConfigEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
            if (Objects.isNull(priceBasicConfigEo.getInstanceId())) {
                priceBasicConfigEo.setInstanceId(this.context.instanceId());
            }
            if (!Objects.isNull(priceBasicConfigEo.getTenantId())) continue;
            priceBasicConfigEo.setTenantId(this.context.tenantId());
        }
        this.priceBasicConfigDas.insertBatch((List)priceBasicConfigEoList);
        return priceBasicConfigEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modifyPriceBasicConfig(PriceBasicConfigModifyReqDto reqDto) {
        Long id = reqDto.getId();
        if (Objects.isNull(id)) {
            return null;
        }
        PriceBasicConfigEo priceBasicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceBasicConfigEo)) {
            return null;
        }
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceBasicConfigEo);
        priceBasicConfigEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData());
        this.priceBasicConfigDas.update((BaseEo)priceBasicConfigEo);
        logger.info("\u4fee\u6539\u57fa\u7840\u914d\u7f6e userId={},\u5185\u5bb9={}", (Object)this.context.userId(), (Object)JSON.toJSONString((Object)reqDto));
        return id;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceBasicConfigById(Long id) {
        if (Objects.isNull(id)) {
            return;
        }
        PriceBasicConfigEo priceBasicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceBasicConfigEo)) {
            return;
        }
        this.priceBasicConfigDas.logicDeleteById(priceBasicConfigEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePriceBasicConfigByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return;
        }
        this.priceBasicConfigDas.logicDeleteByIds(idList);
    }

    @Override
    public PageInfo<PriceBasicConfigRespDto> queryByPage(PriceBasicConfigQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        LambdaQueryWrapper<PriceBasicConfigEo> queryWrapper = this.getQueryWrapper(reqDto);
        queryWrapper.orderByDesc(BaseEo::getCreateTime);
        return MybatisPlusUtils.selectPage(this.priceBasicConfigDas, queryWrapper, PriceBasicConfigRespDto.class, pageNum, pageSize);
    }

    private LambdaQueryWrapper<PriceBasicConfigEo> getQueryWrapper(PriceBasicConfigQueryReqDto reqDto) {
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceBasicConfigEo);
        priceBasicConfigEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceBasicConfigEo);
        if (CollUtil.isNotEmpty((Collection)reqDto.getIdList())) {
            queryWrapper.in(BaseEo::getId, (Collection)reqDto.getIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getConfigTypeList())) {
            queryWrapper.in(StdPriceBasicConfigEo::getConfigType, (Collection)reqDto.getConfigTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getControlTypeList())) {
            queryWrapper.in(StdPriceBasicConfigEo::getControlType, (Collection)reqDto.getControlTypeList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getOrganizationIdList())) {
            queryWrapper.in(StdPriceBasicConfigEo::getOrganizationId, (Collection)reqDto.getOrganizationIdList());
        }
        if (CollUtil.isNotEmpty((Collection)reqDto.getCategoryCodeList())) {
            queryWrapper.in(StdPriceBasicConfigEo::getCategoryCode, (Collection)reqDto.getCategoryCodeList());
        }
        return queryWrapper;
    }

    @Override
    public List<PriceBasicConfigRespDto> queryByList(PriceBasicConfigQueryReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            return null;
        }
        return this.priceBasicConfigDas.getMapper().selectList(this.getQueryWrapper(reqDto)).stream().map(item -> (PriceBasicConfigRespDto)item.toDto(PriceBasicConfigRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceBasicConfigRespDto queryById(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        PriceBasicConfigEo priceBasicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectByPrimaryKey(id);
        if (Objects.isNull(priceBasicConfigEo)) {
            return null;
        }
        PriceBasicConfigRespDto priceBasicConfigRespDto = (PriceBasicConfigRespDto)priceBasicConfigEo.toDto(PriceBasicConfigRespDto.class);
        return priceBasicConfigRespDto;
    }

    @Override
    public List<PriceBasicConfigRespDto> queryByIds(List<Long> idList) {
        if (CollUtil.isEmpty(idList)) {
            return null;
        }
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        priceBasicConfigEo.setDr(PriceCommonEnum.Dr.VALID.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)priceBasicConfigEo).in(BaseEo::getId, idList);
        List priceBasicConfigEoList = this.priceBasicConfigDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceBasicConfigEoList.stream().map(item -> (PriceBasicConfigRespDto)item.toDto(PriceBasicConfigRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceBasicConfigRespDto query() {
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        priceBasicConfigEo.setOrganizationId((Long)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()).getData());
        PriceBasicConfigEo basicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectOne((BaseEo)priceBasicConfigEo);
        PriceBasicConfigRespDto basicConfigRespDto = new PriceBasicConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)basicConfigEo, (BaseVo)basicConfigRespDto);
        return basicConfigRespDto;
    }

    @Override
    public List<PriceBasicConfigRespDto> getBasicConfigByOrgIdAndConfigType(List<Long> orgIdList, PriceBasicConfigEnum.ConfigType configType) {
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        priceBasicConfigEo.setConfigType(configType.getCode());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)MybatisPlusUtils.newLambdaQueryWrapper(priceBasicConfigEo).in(StdPriceBasicConfigEo::getOrganizationId, orgIdList);
        List priceBasicConfigEoList = this.priceBasicConfigDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceBasicConfigEoList.stream().map(item -> (PriceBasicConfigRespDto)item.toDto(PriceBasicConfigRespDto.class)).collect(Collectors.toList());
    }

    @Override
    public PriceBasicConfigRespDto getBasicConfigByOrgIdAndConfigType(Long orgId, PriceBasicConfigEnum.ConfigType configType) {
        PriceBasicConfigEo priceBasicConfigEo = new PriceBasicConfigEo();
        priceBasicConfigEo.setConfigType(configType.getCode());
        priceBasicConfigEo.setOrganizationId(orgId);
        priceBasicConfigEo = (PriceBasicConfigEo)this.priceBasicConfigDas.selectOne((BaseEo)priceBasicConfigEo);
        if (Objects.isNull(priceBasicConfigEo)) {
            return null;
        }
        PriceBasicConfigRespDto priceBasicConfigRespDto = new PriceBasicConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)priceBasicConfigEo, (BaseVo)priceBasicConfigRespDto);
        return priceBasicConfigRespDto;
    }
}

