/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PriceUtil {
    @Autowired
    ICacheService cacheService;
    private static PriceUtil priceUtil;
    private static final String PRICE_CODE = "PRICE_CODE";

    @PostConstruct
    public void init() {
        priceUtil = this;
        PriceUtil.priceUtil.cacheService = this.cacheService;
    }

    public static String generateCode(String prefix) {
        StringBuilder code = new StringBuilder();
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        code.append(prefix).append(timeStr);
        Long activityCodeNo = PriceUtil.priceUtil.cacheService.incr(PRICE_CODE);
        Long model = activityCodeNo % 999L;
        if (model < 10L) {
            code.append("00").append(model);
        } else if (model < 100L) {
            code.append("0").append(model);
        } else {
            code.append(model);
        }
        int romNum = RandomUtils.nextInt((int)1, (int)999);
        if (romNum < 10) {
            code.append("00").append(romNum);
        } else if (romNum < 100) {
            code.append("0").append(romNum);
        } else {
            code.append(romNum);
        }
        return code.toString();
    }
}

