/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.price.dao.das;

import com.dtyunxi.yundt.cube.center.price.api.constants.CategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.price.api.dto.PriceTypeDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.request.PriceItemQueryReqDto;
import com.dtyunxi.yundt.cube.center.price.api.dto.response.PriceItemListRespDto;
import com.dtyunxi.yundt.cube.center.price.dao.das.GuidingPriceDas;
import com.dtyunxi.yundt.cube.center.price.dao.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.price.dao.eo.PriceItemEo;
import com.dtyunxi.yundt.cube.center.price.dao.mapper.PriceItemMapper;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class PriceItemDas
extends AbstractBaseDas<PriceItemEo, Long> {
    @Resource
    private PriceItemMapper priceItemMapper;
    @Resource
    private GuidingPriceDas guidingPriceDas;
    @Resource
    private IContext context;

    public List<PriceItemListRespDto> selectPageList(PriceItemQueryReqDto qry) {
        List<PriceItemListRespDto> priceItemListRespDtoList = this.priceItemMapper.selectPageList(qry);
        if (CategoryCodeEnum.BASE.getCode().equals(qry.getCategoryCode()) && CollectionUtils.isNotEmpty(priceItemListRespDtoList)) {
            priceItemListRespDtoList.forEach(item -> {
                List<PriceTypeDto> priceTypeList = this.guidingPriceDas.selectGuidingList(item.getId(), item.getSkuId(), this.context.tenantId(), this.context.instanceId());
                item.setPriceTypeList(priceTypeList);
            });
        }
        return priceItemListRespDtoList;
    }
}

