/*
 * @(#)PriceModelEo.java 1.0 2021-11-19
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.price.dao.eo;


import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;

import javax.persistence.Table;

/**
 * 价格模型(PriceModel)实体类
 *
 * @author 惜笔 | 林五弟
 * @date 2021-11-19 19:08:04
 * @since v1
 */
@Table(name="pr_price_model")
public class PriceModelEo extends StdPriceModelEo {

    public static PriceModelEo newInstance() {
        return (PriceModelEo) BaseEo.newInstance(PriceModelEo.class);
    }

    public <DTO extends BaseVo> DTO toDto(Class<DTO> dtoClass) {
        try {
            DTO dto = dtoClass.newInstance();
            DtoHelper.eo2Dto(this, dto);
            return dto;
        }catch (Exception e){
            return null;
        }
    }
}
