package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants;

/**
 * 正则匹配常量
 * @author : 萧玄
 * @Date: 14:38 2019/6/21
 */
public class RegexpConstants {
    /**
     * yyyy-MM-dd
     */
    public final static String DATE_FORMAT = "(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)";

    /**
     * hh:mm (24小时制)
     */
    public final static String SHORT_TIME_PATTERN = "([0-1][0-9]|2[0-3]):[0-5][0-9]";

    /**
     * hh:mm:ss (24小时制)
     */
    public final static String TIME_PATTERN = "([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]";

    /**
     * yyyy-MM-dd hh:mm:ss
     */
    public final static String DATE_TIME_FORMAT = "(" + DATE_FORMAT + ") " + TIME_PATTERN;
    /**
     * hh:mm:ss.SSS (24小时制)
     */
    public final static String FULL_TIME_PATTERN = "([0-1][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9].[0-9][0-9][0-9]";

    /**
     * yyyy-MM-dd hh:mm:ss.SSS
     */
    public final static String FULL_DATE_TIME_FORMAT = "(" + DATE_FORMAT + ") " + FULL_TIME_PATTERN;

    /**
     * yyyy-MM-dd 或者 yyyy-MM-dd hh:mm:ss
     */
    public final static String DATE_TIME_FORMAT_2 = DATE_FORMAT + "|" + DATE_TIME_FORMAT ;

    /**
     * yyyy-MM-dd 或者 yyyy-MM-dd hh:mm:ss 或者 yyyy-MM-dd hh:mm:ss.SSS
     */
    public final static String DATE_TIME_FORMAT_3 = DATE_FORMAT + "|" + DATE_TIME_FORMAT + "|" + FULL_DATE_TIME_FORMAT;

}
