package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 营销任务类型（0仅通知 1活动 2优惠券）
 * @author : 萧玄
 * @Date   : 16:45 2019/5/24
 */
public enum MarketingTaskTypeEnum implements IEnum {

    ONLY_NOTIFY(0, "仅通知"),
    ACTIVITY(1, "活动"),
    COUPON(2, "优惠券"),
    RIGHTS(4, "权益"),
    ;
    private int key;

    private String value;

    MarketingTaskTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
