package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

@ApiModel("营销任务-优惠券")
public class MarketingCouponRespDto implements Serializable {
    private static final long serialVersionUID = 6084942499284850661L;
    @ApiModelProperty("名称")
    private String name;
    @ApiModelProperty("编号")
    private String code;
    @ApiModelProperty("类型【0：优惠券 1：福利券】")
    private String type;
    @ApiModelProperty("券模板编号")
    private String templateCode;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty(
            name = "客户待领取优惠券记录id",
            value = "taskCustomerCouponId"
    )
    private Long taskCustomerCouponId;
    @ApiModelProperty("发放数量")
    private int count;
    @ApiModelProperty("发放方式")
    private Integer couponPushMethod;

    public MarketingCouponRespDto() {
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTaskCustomerCouponId() {
        return taskCustomerCouponId;
    }

    public void setTaskCustomerCouponId(Long taskCustomerCouponId) {
        this.taskCustomerCouponId = taskCustomerCouponId;
    }

    public int getCount() {
        return count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Integer getCouponPushMethod() {
        return couponPushMethod;
    }

    public void setCouponPushMethod(Integer couponPushMethod) {
        this.couponPushMethod = couponPushMethod;
    }
}
