package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;

/**
 * 推送渠道【1:短信,2:邮件,3:站内信,4:微信,5:APP推送,6:支付宝生活号】
 * @author : 萧玄
 * @Date   : 11:37 2019/6/5
 */
@ApiModel("触达渠道")
public class PushChannelDto  implements Serializable {

    private static final long serialVersionUID = 468445246459722189L;

    @ApiModelProperty(value = "营销和推送渠道关系表id",notes = "mk_event_marketing_push_channel或者mk_task_push_channel表",hidden = true)
    private long relationId;

    @ApiModelProperty(value = "渠道类型【1:短信 2:邮件 3:站内信 4:微信 5:APP推送 6:支付宝生活号，必填】",notes = "适用消息中心的MsgConstants.MsgType")
    private Integer type;

//    @NotNull(message = "消息模板id不能为空")icom站内信没有
    @ApiModelProperty("消息模板id，必填")
    private Long templateId;

    @ApiModelProperty("供应商提供的模板编码，选填")
    private String providerTplCode;

    @NotEmpty(message = "消息模板内容不能为空，必填")
    @ApiModelProperty("消息模板内容")
    private String msgContent;

    @ApiModelProperty("模板类型:1微信模板消息模板,2微信订阅通知模板")
    private Integer templateType;

//    @NotEmpty(message = "消息模板名称不能为空，必填") icom站内信没有
    @ApiModelProperty("消息模板名称")
    private String templateName;

    @ApiModelProperty("外部链接，选填")
    private String url;

    @ApiModelProperty("H5活动链接")
    private String h5Url;

    @ApiModelProperty("外部链接，选填")
    private String uploadUrl;

    @ApiModelProperty(value = "消息模板名称",hidden = true)
    private String extension;

    @ApiModelProperty(value = "渠道排序值【按照添加的顺序从小到大排序，选填】")
    private Integer sort;

    @ApiModelProperty(value = "跳转小程序的url")
    private String jumpUrl;

    @ApiModelProperty(value = "小程序的appid")
    private String appId;

    /**
     * 消息中心模板的code
     */
    @ApiModelProperty(value = "消息中心模板的code")
    private String code;

    /**
     * 微信公众号的渠道名称  用于选择指定某个微信公众号使用
     */
    @ApiModelProperty(value = "微信公众号的渠道名称  用于选择指定某个微信公众号使用")
    private String channelName;

    /**
     * 渠道id
     */
    @ApiModelProperty(value = "渠道id")
    private Long channelId;

    /**
     * 微信appId
     */
    @ApiModelProperty(value = "微信appId")
    private String wxAppId;

    /**
     * 是不是内部会员
     */
    private boolean memberFlag;

    public boolean isMemberFlag() {
        return memberFlag;
    }

    public void setMemberFlag(boolean memberFlag) {
        this.memberFlag = memberFlag;
    }

    public Integer getTemplateType() {
        return templateType;
    }

    public void setTemplateType(Integer templateType) {
        this.templateType = templateType;
    }

    public String getWxAppId() {
        return wxAppId;
    }

    public void setWxAppId(String wxAppId) {
        this.wxAppId = wxAppId;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public long getRelationId() {
        return relationId;
    }

    public void setRelationId(long relationId) {
        this.relationId = relationId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public String getMsgContent() {
        return msgContent;
    }

    public void setMsgContent(String msgContent) {
        this.msgContent = msgContent;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getProviderTplCode() {
        return providerTplCode;
    }

    public void setProviderTplCode(String providerTplCode) {
        this.providerTplCode = providerTplCode;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUploadUrl() {
        return uploadUrl;
    }

    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getH5Url() {
        return h5Url;
    }

    public void setH5Url(String h5Url) {
        this.h5Url = h5Url;
    }

    public String getJumpUrl() {
        return jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 优先用于填充模板参数里面的外部链接的值：优先使用h5活动链接
     * @author : 萧玄
     * @Date   : 10:26 2019/10/8
     * @return : java.lang.String
     */
    public String url2Fill(){
        return StringUtils.isEmpty(h5Url)?url:h5Url;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }
}
