package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.PushTimeReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.TargetThrongReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import java.util.List;

@ApiModel("营销任务")
public class TaskReqDto extends OperatorReqDto {

    @ApiModelProperty("名称，必填，实例下唯一")
    private String name;

    @ApiModelProperty("不受营销限制，选填")
    private boolean notLimit;

    @ApiModelProperty("营销内容，必填")
    private ContentReqDto content;

    @ApiModelProperty("目标人群，必填")
    private TargetThrongReqDto throng;

    @ApiModelProperty("推送时间，必填")
    private PushTimeReqDto pushTime;

    @Valid
    @ApiModelProperty("触达渠道，选填")
    private List<PushChannelDto> pushChannels;

    @ApiModelProperty("扩展字段，选填")
    private String extension;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNotLimit() {
        return notLimit;
    }

    public void setNotLimit(boolean notLimit) {
        this.notLimit = notLimit;
    }

    public ContentReqDto getContent() {
        return content;
    }

    public void setContent(ContentReqDto content) {
        this.content = content;
    }

    public TargetThrongReqDto getThrong() {
        return throng;
    }

    public void setThrong(TargetThrongReqDto throng) {
        this.throng = throng;
    }

    public PushTimeReqDto getPushTime() {
        return pushTime;
    }

    public void setPushTime(PushTimeReqDto pushTime) {
        this.pushTime = pushTime;
    }

    public List<PushChannelDto> getPushChannels() {
        return pushChannels;
    }

    public void setPushChannels(List<PushChannelDto> pushChannels) {
        this.pushChannels = pushChannels;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
