package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.event;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.RegexpConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.PagerDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.Pattern;
import java.util.List;

@ApiModel(value = "EventQueryReqDto", description = "查询事件参数")
public class EventMarketingQueryReqDto extends PagerDto {

    @ApiModelProperty(value = "营销编码")
    private String code;

    @ApiModelProperty(value = "营销名称")
    private String name;

    @ApiModelProperty("营销类型【留空:全部  " + DtoApiNoteConstants.MARKETING_TYPE + "】")
    private Integer marketingType;

    @ApiModelProperty(value = "事件类型【留空：全部 " + DtoApiNoteConstants.EVENT_TYPE + "】")
    private Integer type;

    @ApiModelProperty(value = "留空:全部 【" + DtoApiNoteConstants.EVENT_STATUS + "】")
    private Integer status;

    @ApiModelProperty(value = "状态列表，留空:全部 【" + DtoApiNoteConstants.EVENT_STATUS + "】")
    private List<Integer> statusList;

    @Pattern(regexp = RegexpConstants.DATE_TIME_FORMAT_2, message = "时间格式不正确（ yyyy-MM-dd HH:mm:ss或yyyy-MM-dd）")
    @ApiModelProperty(value = "更新开始时间【格式 yyyy-MM-dd HH:mm:ss或者 yyyy-MM-dd】")
    private String beginTime;

    @Pattern(regexp = RegexpConstants.DATE_TIME_FORMAT_2, message = "时间格式不正确（ yyyy-MM-dd HH:mm:ss或yyyy-MM-dd）")
    @ApiModelProperty(value = "更新结束时间【格式 yyyy-MM-dd HH:mm:ss或者 yyyy-MM-dd】")
    private String endTime;

    @ApiModelProperty(value = "更新账号")
    private String updateAccount;

    @ApiModelProperty(value = "启用账号")
    private String enableAccount;

    @ApiModelProperty(value = "触达渠道【留空：全部" + DtoApiNoteConstants.PUSH_CHANNEL + "】")
    private Integer pushChannel;

    @ApiModelProperty(name = "eventName", value = "事件名称")
    private String eventName;

    @ApiModelProperty(name = "marketingTaskSource", value = "营销任务来源 (0 事件营销引擎 1发券宝 )")
    private Integer marketingTaskSource;

    public Integer getMarketingTaskSource() {
        return marketingTaskSource;
    }

    public void setMarketingTaskSource(Integer marketingTaskSource) {
        this.marketingTaskSource = marketingTaskSource;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(String beginTime) {
        this.beginTime = beginTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public String getUpdateAccount() {
        return updateAccount;
    }

    public void setUpdateAccount(String updateAccount) {
        this.updateAccount = updateAccount;
    }

    public String getEnableAccount() {
        return enableAccount;
    }

    public void setEnableAccount(String enableAccount) {
        this.enableAccount = enableAccount;
    }

    public Integer getPushChannel() {
        return pushChannel;
    }

    public void setPushChannel(Integer pushChannel) {
        this.pushChannel = pushChannel;
    }

    public Integer getMarketingType() {
        return marketingType;
    }

    public void setMarketingType(Integer marketingType) {
        this.marketingType = marketingType;
    }

    public List<Integer> getStatusList() {
        return statusList;
    }

    public void setStatusList(List<Integer> statusList) {
        this.statusList = statusList;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }
}
