package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.event;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.OperatorReqDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.PushChannelDto;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.TwoTuple;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task.RightsDefineDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@ApiModel("事件营销")
public class EventMarketingReqDto extends OperatorReqDto {

    @NotEmpty(message = "事件营销名称不能为空")
    @ApiModelProperty("事件营销名称，必填")
    private String name;

    @ApiModelProperty("营销类型【" + DtoApiNoteConstants.MARKETING_TYPE+"】，新增必填")
    private Integer marketingType;

    @ApiModelProperty("不受营销限制【 0否 1是】，选填")
    private int limitFlag;

    @ApiModelProperty("是否被限制服务限制【 0否 1是】")
    private Integer isBeLimit;

    @Valid
    @ApiModelProperty("触达渠道")
    private List<PushChannelDto> pushChannels;

    @Valid
    @ApiModelProperty("事件规则信息")
    private EventRuleReqDto eventRuleReqDto;

    @Valid
    @ApiModelProperty("适用店铺范围，选填")
    private ApplyShop applyShop;

    @ApiModelProperty("赠送的优惠券组【first:优惠券模板id,second赠送数量】，选填")
    private List<TwoTuple<Long,Integer>> coupons;

    @ApiModelProperty("赠送的权益信息，选填")
    private List<RightsDefineDto> rights;


    @ApiModelProperty("赠送积分数量")
    private Integer presentPoint;

    @ApiModelProperty("权重，默认0，选填")
    private Integer weight = 0;

    @ApiModelProperty("有效时间类型（默认 0：永久 1：指定时间范围），选填")
    private Integer validTimeType = 0;

    @ApiModelProperty("截止有效时间")
    private Date endValidTime;

    @ApiModelProperty("初始有效时间")
    private Date firstValidTime;

    @ApiModelProperty(name = "scene", value = "发券场景：1进店有礼，2下单有礼")
    private Integer scene;

    @ApiModelProperty(name = "theme", value = "主题")
    private String theme;

    @ApiModelProperty(name = "marketingTaskSource", value = "营销任务来源 (0 事件营销引擎 1发券宝 )")
    private Integer marketingTaskSource;

    @ApiModelProperty(name = "everyoneDailyLimit", value = "每人每天限制次数")
    private Integer everyoneDailyLimit;

    @ApiModelProperty(name = "everyoneTotalLimit", value = "每人总限制次数")
    private Integer everyoneTotalLimit;

    @ApiModel("适用店铺范围")
    public static class ApplyShop{

        @ApiModelProperty("范围类型【0：所有店铺 1：线上所有店铺 2：线下所有店铺 3：部分店铺 4：排除部分店铺】，必填")
        private Integer type;

        @ApiModelProperty("选中的店铺id数组，必填")
        private List<Long> shopIds;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public List<Long> getShopIds() {
            return shopIds;
        }

        public void setShopIds(List<Long> shopIds) {
            this.shopIds = shopIds;
        }
    }

    @ApiModel("事件信息")
    public static class SelectEvent {

        @NotNull(message = "事件类型不能为空")
        @ApiModelProperty("事件类型【"+ DtoApiNoteConstants.EVENT_TYPE+"】，新增必填")
        private Integer eventType;

        @NotEmpty(message = "事件码不能为空")
        @ApiModelProperty("事件码，新增必填")
        private String eventCode;

        @ApiModelProperty("一次性消耗积分超过最小值，选填")
        private Integer minPoints;

        @ApiModelProperty("近365天累计消费总额的最小值【金额使用decimal】，选填")
        private BigDecimal minConsume;

        @ApiModelProperty("近365天累计消费总额的最大值【金额使用decimal】，选填")
        private BigDecimal maxConsume;

        @ApiModelProperty("等级升级时的目标id，选填")
        private Long levelId;

        @ApiModelProperty("选择对象id数组【有选择权益、积分规则或者优惠券等时候才有值】，选填")
        private List<Long> selectIds;

        public Integer getEventType() {
            return eventType;
        }

        public void setEventType(Integer eventType) {
            this.eventType = eventType;
        }

        public String getEventCode() {
            return eventCode;
        }

        public void setEventCode(String eventCode) {
            this.eventCode = eventCode;
        }

        public Integer getMinPoints() {
            return minPoints;
        }

        public void setMinPoints(Integer minPoints) {
            this.minPoints = minPoints;
        }

        public BigDecimal getMinConsume() {
            return minConsume;
        }

        public void setMinConsume(BigDecimal minConsume) {
            this.minConsume = minConsume;
        }

        public BigDecimal getMaxConsume() {
            return maxConsume;
        }

        public void setMaxConsume(BigDecimal maxConsume) {
            this.maxConsume = maxConsume;
        }

        public Long getLevelId() {
            return levelId;
        }

        public void setLevelId(Long levelId) {
            this.levelId = levelId;
        }

        public List<Long> getSelectIds() {
            return selectIds;
        }

        public void setSelectIds(List<Long> selectIds) {
            this.selectIds = selectIds;
        }
    }

    public List<RightsDefineDto> getRights() {
        return rights;
    }

    public void setRights(List<RightsDefineDto> rights) {
        this.rights = rights;
    }

    public Integer getIsBeLimit() {
        return isBeLimit;
    }

    public void setIsBeLimit(Integer isBeLimit) {
        this.isBeLimit = isBeLimit;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getLimitFlag() {
        return limitFlag;
    }

    public void setLimitFlag(int limitFlag) {
        this.limitFlag = limitFlag;
    }

    public List<PushChannelDto> getPushChannels() {
        return pushChannels;
    }

    public void setPushChannels(List<PushChannelDto> pushChannels) {
        this.pushChannels = pushChannels;
    }

    public ApplyShop getApplyShop() {
        return applyShop;
    }

    public void setApplyShop(ApplyShop applyShop) {
        this.applyShop = applyShop;
    }

    public List<TwoTuple<Long, Integer>> getCoupons() {
        return coupons;
    }

    public void setCoupons(List<TwoTuple<Long, Integer>> coupons) {
        this.coupons = coupons;
    }

    public Integer getPresentPoint() {
        return presentPoint;
    }

    public void setPresentPoint(Integer presentPoint) {
        this.presentPoint = presentPoint;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getMarketingType() {
        return marketingType;
    }

    public void setMarketingType(Integer marketingType) {
        this.marketingType = marketingType;
    }

    public Integer getValidTimeType() {
        return validTimeType;
    }

    public Integer getEveryoneDailyLimit() {
        return everyoneDailyLimit;
    }

    public void setEveryoneDailyLimit(Integer everyoneDailyLimit) {
        this.everyoneDailyLimit = everyoneDailyLimit;
    }

    public Integer getEveryoneTotalLimit() {
        return everyoneTotalLimit;
    }

    public void setEveryoneTotalLimit(Integer everyoneTotalLimit) {
        this.everyoneTotalLimit = everyoneTotalLimit;
    }

    public void setValidTimeType(Integer validTimeType) {
        this.validTimeType = validTimeType;
    }

    public Date getEndValidTime() {
        return endValidTime;
    }

    public void setEndValidTime(Date endValidTime) {
        this.endValidTime = endValidTime;
    }

    public Date getFirstValidTime() {
        return firstValidTime;
    }

    public void setFirstValidTime(Date firstValidTime) {

        this.firstValidTime = firstValidTime;
    }

    public EventRuleReqDto getEventRuleReqDto() {
        return eventRuleReqDto;
    }

    public void setEventRuleReqDto(EventRuleReqDto eventRuleReqDto) {
        this.eventRuleReqDto = eventRuleReqDto;
    }

    public Integer getScene() {
        return scene;
    }

    public void setScene(Integer scene) {
        this.scene = scene;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Integer getMarketingTaskSource() {
        return marketingTaskSource;
    }

    public void setMarketingTaskSource(Integer marketingTaskSource) {
        this.marketingTaskSource = marketingTaskSource;
    }
}

