package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.limit;

import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.constants.DtoApiNoteConstants;
import com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.OperatorReqDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "MarketingLimitReqDto", description = "营销限制新增/编辑参数")
public class MarketingLimitReqDto extends OperatorReqDto {

    @ApiModelProperty(name = "限制id[需要覆盖的传id过来，不然只会新增]")
    private Long id;

    @ApiModelProperty(name = "限制类型（0营销类限制 1通知类限制)")
    private Integer type;

    @ApiModelProperty(name = "限制名称[需要指定限制的名称时传递过来，默认以渠道的名称作为限制名称]")
    private String name;

    @ApiModelProperty(name = "渠道类型["+ DtoApiNoteConstants.PUSH_CHANNEL +"]")
    private Integer pushChannel;

    @ApiModelProperty(name = "每年次数(留空代表不设限)")
    private Integer yearLimit;

    @ApiModelProperty(name = "每半年次数(留空代表不设限)")
    private Integer halfYearLimit;

    @ApiModelProperty(name = "每月次数(留空代表不设限)")
    private Integer monthLimit;

    @ApiModelProperty(name = "每周次数(留空代表不设限)")
    private Integer weekLimit;

    @ApiModelProperty(name = "每天次数(留空代表不设限)")
    private Integer dayLimit;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getPushChannel() {
        return pushChannel;
    }

    public void setPushChannel(Integer pushChannel) {
        this.pushChannel = pushChannel;
    }

    public Integer getYearLimit() {
        return yearLimit;
    }

    public void setYearLimit(Integer yearLimit) {
        this.yearLimit = yearLimit;
    }

    public Integer getHalfYearLimit() {
        return halfYearLimit;
    }

    public void setHalfYearLimit(Integer halfYearLimit) {
        this.halfYearLimit = halfYearLimit;
    }

    public Integer getMonthLimit() {
        return monthLimit;
    }

    public void setMonthLimit(Integer monthLimit) {
        this.monthLimit = monthLimit;
    }

    public Integer getWeekLimit() {
        return weekLimit;
    }

    public void setWeekLimit(Integer weekLimit) {
        this.weekLimit = weekLimit;
    }

    public Integer getDayLimit() {
        return dayLimit;
    }

    public void setDayLimit(Integer dayLimit) {
        this.dayLimit = dayLimit;
    }
}
