package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

@ApiModel("营销内容")
public class Content<COUPON> implements Serializable {

    private static final long serialVersionUID = -5876446151666842517L;
    @ApiModelProperty(value = "营销类型【0:仅通知 1:H5活动 2:优惠券】，必填")
    private int type;

    @ApiModelProperty(value = "推送方式【0：定向推券 1：领券中心-通用 2：领券中心-精准】",notes = "CouponPushMethodEnum枚举")
    private Integer pushMethod;

    @ApiModelProperty(value = "H5活动【Type=1时，活动编号和活动链接必填】")
    private ActivityReqDto activity;

    @ApiModelProperty(value = "活动名称")
    private String activityName;

    @ApiModelProperty(value = "优惠券列表【Type=2时coupons必填】")
    private List<COUPON> coupons;

    /**
     * 权益信息列表 type==4 时必填项
     */
    @ApiModelProperty(value = "权益列表【Type=4 时rights必填】")
    private List<RightsDefineDto> rights;

    public List<RightsDefineDto> getRights() {
        return rights;
    }

    public void setRights(List<RightsDefineDto> rights) {
        this.rights = rights;
    }


    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public ActivityReqDto getActivity() {
        return activity;
    }

    public void setActivity(ActivityReqDto activity) {
        this.activity = activity;
    }

    public List<COUPON> getCoupons() {
        return coupons;
    }

    public void setCoupons(List<COUPON> coupons) {
        this.coupons = coupons;
    }

    public Integer getPushMethod() {
        return pushMethod;
    }

    public void setPushMethod(Integer pushMethod) {
        this.pushMethod = pushMethod;
    }
}
