package com.dtyunxi.yundt.imkt.bundle.common.center.marketing.api.dto.request.task;


import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("营销任务-权益定义信息")
public class RightsDefineDto extends BaseVo {

    /**
     * 权益id
     */
    @ApiModelProperty(name = "rightsId" , value = "权益id")
    private Long rightsId;

    /**
     * 权益分组名称
     */
    @ApiModelProperty(name = "rightTypeName" , value = "权益分组名称")
    private String rightTypeName;
    /**
     * 权益状态 1启用，0禁用
     */
    @ApiModelProperty(name = "bizStatus" , value = "权益状态 1启用，0禁用")
    private Integer bizStatus;
    /**
     * 权益类型 1专属赠品，2服务体验，3折扣价，4包邮，5资格类，6其他类
     */
    @ApiModelProperty(name = "ruleType" , value = "权益类型 1专属赠品，2服务体验，3折扣价，4包邮，5资格类，6其他类")
    private Integer ruleType;

    /**
     * 权益名称
     */
    @ApiModelProperty(name = "name" , value = "权益名称")
    private String name;

    @ApiModelProperty(
            name = "contentType",
            value = "权益内容类型（多个内容类型以逗号分隔）"
    )
    private String contentType;

    public String getContentType() {
        
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Long getRightsId() {
        return rightsId;
    }

    public void setRightsId(Long rightsId) {
        this.rightsId = rightsId;
    }

    public String getRightTypeName() {
        return rightTypeName;
    }

    public void setRightTypeName(String rightTypeName) {
        this.rightTypeName = rightTypeName;
    }

    public Integer getBizStatus() {
        return bizStatus;
    }

    public void setBizStatus(Integer bizStatus) {
        this.bizStatus = bizStatus;
    }

    public Integer getRuleType() {
        return ruleType;
    }

    public void setRuleType(Integer ruleType) {
        this.ruleType = ruleType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}